/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.util.ssl;

import com.jetbrains.service.util.ssl.CertRequestInfo;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.X509KeyManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeX509KeyManager
implements X509KeyManager {
    private final List<X509KeyManager> keyManagers = new ArrayList<X509KeyManager>();
    private CertRequestInfo lastCertRequestInfo = null;

    public CompositeX509KeyManager(@NotNull X509KeyManager[] keyManagers) {
        this.keyManagers.addAll(Arrays.asList(keyManagers));
    }

    @Override
    @Nullable
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        this.lastCertRequestInfo = new CertRequestInfo(keyType, issuers);
        for (X509KeyManager keyManager : this.keyManagers) {
            String alias = keyManager.chooseClientAlias(keyType, issuers, socket);
            if (alias == null) continue;
            this.lastCertRequestInfo.setAlias(alias);
            return alias;
        }
        return null;
    }

    @Override
    @Nullable
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        for (X509KeyManager keyManager : this.keyManagers) {
            String alias = keyManager.chooseServerAlias(keyType, issuers, socket);
            if (alias == null) continue;
            return alias;
        }
        return null;
    }

    @Override
    @Nullable
    public PrivateKey getPrivateKey(String alias) {
        for (X509KeyManager keyManager : this.keyManagers) {
            PrivateKey privateKey = keyManager.getPrivateKey(alias);
            if (privateKey == null) continue;
            return privateKey;
        }
        return null;
    }

    @Override
    @Nullable
    public X509Certificate[] getCertificateChain(String alias) {
        for (X509KeyManager keyManager : this.keyManagers) {
            X509Certificate[] chain = keyManager.getCertificateChain(alias);
            if (chain == null || chain.length <= 0) continue;
            return chain;
        }
        return null;
    }

    @Override
    @Nullable
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        ArrayList<String> aliases = new ArrayList<String>();
        for (X509KeyManager keyManager : this.keyManagers) {
            aliases.addAll(Arrays.asList(keyManager.getClientAliases(keyType, issuers)));
        }
        return aliases.isEmpty() ? null : aliases.toArray(new String[aliases.size()]);
    }

    @Override
    @Nullable
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        ArrayList<String> aliases = new ArrayList<String>();
        for (X509KeyManager keyManager : this.keyManagers) {
            aliases.addAll(Arrays.asList(keyManager.getServerAliases(keyType, issuers)));
        }
        return aliases.isEmpty() ? null : aliases.toArray(new String[aliases.size()]);
    }

    public List<X509KeyManager> getKeyManagers() {
        return Collections.unmodifiableList(this.keyManagers);
    }

    public CertRequestInfo getLastCertRequestInfo() {
        return this.lastCertRequestInfo;
    }

    public void resetLastCertRequestInfo() {
        this.lastCertRequestInfo = null;
    }
}

