/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.ep.commands;

import com.jetbrains.launcher.AppConfigFiles;
import com.jetbrains.launcher.AppFilesEx;
import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.LauncherContext;
import com.jetbrains.launcher.LauncherContextEx;
import com.jetbrains.launcher.LauncherExitCode;
import com.jetbrains.launcher.SystemInfo;
import com.jetbrains.launcher.configs.AppConfig;
import com.jetbrains.launcher.ep.Command;
import com.jetbrains.launcher.ep.commands.BaseProcessBasedCommand;
import com.jetbrains.launcher.ep.commands.BaseServiceSubCommand;
import com.jetbrains.launcher.ep.commands.MacDaemonUninstall;
import com.jetbrains.launcher.log.ConsoleLogger;
import com.jetbrains.launcher.util.ExceptionUtil;
import com.jetbrains.launcher.util.ProcessUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BaseMacDaemonSubCommand
extends BaseServiceSubCommand {
    @NotNull
    private static final String LABEL_PREFIX = "<key>Label</key>";
    @NotNull
    private static final String LABEL_BEFORE = "<string>";
    @NotNull
    private static final String LABEL_AFTER = "</string>";
    @NotNull
    private final Logger LOG = Logger.getLogger(BaseMacDaemonSubCommand.class);

    BaseMacDaemonSubCommand() {
    }

    @NotNull
    protected String getServiceCommandName() {
        if ("daemon" == null) {
            BaseMacDaemonSubCommand.$$$reportNull$$$0(0);
        }
        return "daemon";
    }

    @NotNull
    protected String getServiceTypeName() {
        if ("daemon" == null) {
            BaseMacDaemonSubCommand.$$$reportNull$$$0(1);
        }
        return "daemon";
    }

    @NotNull
    protected String getServiceNameName() {
        if ("label" == null) {
            BaseMacDaemonSubCommand.$$$reportNull$$$0(2);
        }
        return "label";
    }

    @NotNull
    protected BaseServiceSubCommand createServiceUninstallCommand() {
        MacDaemonUninstall macDaemonUninstall = new MacDaemonUninstall();
        if (macDaemonUninstall == null) {
            BaseMacDaemonSubCommand.$$$reportNull$$$0(3);
        }
        return macDaemonUninstall;
    }

    protected int getIllegalStateExitCodeValue() {
        return 1;
    }

    @Nullable
    protected String doGetOldServiceName(@NotNull String configText) {
        int prefixPos;
        if (configText == null) {
            BaseMacDaemonSubCommand.$$$reportNull$$$0(4);
        }
        if ((prefixPos = configText.indexOf(LABEL_PREFIX)) == -1) {
            return null;
        }
        int beforePos = configText.indexOf(LABEL_BEFORE, prefixPos += LABEL_PREFIX.length());
        if (beforePos == -1 || configText.substring(prefixPos, beforePos).contains("<")) {
            return null;
        }
        int afterPos = configText.indexOf(LABEL_AFTER, beforePos += LABEL_BEFORE.length());
        if (afterPos == -1) {
            return null;
        }
        return configText.substring(beforePos, afterPos).trim();
    }

    @NotNull
    protected String getCurrentServiceName(@NotNull LauncherContext context) {
        if (context == null) {
            BaseMacDaemonSubCommand.$$$reportNull$$$0(5);
        }
        String string = context.getAppConfig().getMacDaemonLabel();
        if (string == null) {
            BaseMacDaemonSubCommand.$$$reportNull$$$0(6);
        }
        return string;
    }

    protected boolean serviceExists(@NotNull LauncherContext context, @NotNull String serviceName, boolean defaultValue) {
        if (context == null) {
            BaseMacDaemonSubCommand.$$$reportNull$$$0(7);
        }
        if (serviceName == null) {
            BaseMacDaemonSubCommand.$$$reportNull$$$0(8);
        }
        List<String> command = Arrays.asList("/bin/sh", context.getAppFiles().getMacDaemonScriptFile().getAbsolutePath(), "exists", serviceName);
        return BaseMacDaemonSubCommand.runProcess((File)context.getAppFiles().getAppHome(), command, (boolean)true, (Logger)this.LOG, (BaseProcessBasedCommand.ExitCodeConverter)BaseProcessBasedCommand.ExitCodeConverter.DEFAULT) == LauncherExitCode.OK;
    }

    protected boolean serviceLoaded(@NotNull LauncherContext context, boolean defaultValue) {
        if (context == null) {
            BaseMacDaemonSubCommand.$$$reportNull$$$0(9);
        }
        try {
            ProcessUtil.ExecutionResult executionResult = ProcessUtil.runCommand(null, (String[])new String[]{"launchctl", "list"});
            if (executionResult.getExitCode() != 0) {
                this.LOG.debug((Object)("Failed to check if daemon is loaded: launchctl exited with code " + executionResult.getExitCode()));
                return defaultValue;
            }
            String daemonLabel = context.getAppConfig().getMacDaemonLabel();
            for (String line : executionResult.getStdout()) {
                if (!BaseMacDaemonSubCommand.isDaemonLine(line, daemonLabel)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            ExceptionUtil.logDebug((Logger)this.LOG, (String)"Failed to check if daemon is loaded", (Throwable)e);
            return defaultValue;
        }
    }

    private static boolean isDaemonLine(@NotNull String line, @NotNull String daemonLabel) {
        int startIndex;
        if (line == null) {
            BaseMacDaemonSubCommand.$$$reportNull$$$0(10);
        }
        if (daemonLabel == null) {
            BaseMacDaemonSubCommand.$$$reportNull$$$0(11);
        }
        if ((startIndex = line.indexOf(daemonLabel)) == -1) {
            return false;
        }
        int endIndex = startIndex + daemonLabel.length();
        int preIndex = startIndex == 0 ? 0 : startIndex - 1;
        int postIndex = endIndex == line.length() ? endIndex : endIndex + 1;
        return line.substring(preIndex, postIndex).trim().equals(daemonLabel);
    }

    @NotNull
    protected String getServiceConfigDistFileName() {
        if ("launcher.mac.daemon.plist.dist" == null) {
            BaseMacDaemonSubCommand.$$$reportNull$$$0(12);
        }
        return "launcher.mac.daemon.plist.dist";
    }

    @NotNull
    public File getServiceConfigFile(@NotNull AppConfigFiles appConfigFiles) {
        if (appConfigFiles == null) {
            BaseMacDaemonSubCommand.$$$reportNull$$$0(13);
        }
        File file = appConfigFiles.getMacDaemonConfigFile();
        if (file == null) {
            BaseMacDaemonSubCommand.$$$reportNull$$$0(14);
        }
        return file;
    }

    @NotNull
    protected String prepareConfigText(@NotNull String text, @NotNull File serviceConfigFile, @NotNull LauncherContext context) throws IOException {
        if (text == null) {
            BaseMacDaemonSubCommand.$$$reportNull$$$0(15);
        }
        if (serviceConfigFile == null) {
            BaseMacDaemonSubCommand.$$$reportNull$$$0(16);
        }
        if (context == null) {
            BaseMacDaemonSubCommand.$$$reportNull$$$0(17);
        }
        AppFilesEx appFiles = context.getAppFiles();
        AppConfig appConfig = context.getAppConfig();
        String string = text.replace("#%$!-MAC-DAEMON-LABEL-!$%#", appConfig.getMacDaemonLabel()).replace("#%$!-MAC-DAEMON-USER-!$%#", appConfig.getMacDaemonUser()).replace("#%$!-LOGS-DIR-!$%#", BaseMacDaemonSubCommand.getLogsDirPath(appFiles)).replace("#%$!-STOP-TIMEOUT-SECONDS-!$%#", String.valueOf(appConfig.getStopTimeoutSeconds() + 10)).replace("#%$!-WORK-DIR-!$%#", appFiles.getAppHome().getAbsolutePath());
        if (string == null) {
            BaseMacDaemonSubCommand.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    private static String getLogsDirPath(@NotNull AppFilesEx appFiles) {
        if (appFiles == null) {
            BaseMacDaemonSubCommand.$$$reportNull$$$0(19);
        }
        String string = appFiles.getLauncherLogsFolder().getAbsolutePath();
        if (string == null) {
            BaseMacDaemonSubCommand.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    protected LauncherExitCode doRun(@NotNull LauncherContextEx context) throws InitException {
        if (context == null) {
            BaseMacDaemonSubCommand.$$$reportNull$$$0(21);
        }
        if (!SystemInfo.isRootUser) {
            this.LOG.error((Object)"Use \"sudo\" to run this command");
            LauncherExitCode launcherExitCode = LauncherExitCode.WRONG_USAGE;
            if (launcherExitCode == null) {
                BaseMacDaemonSubCommand.$$$reportNull$$$0(22);
            }
            return launcherExitCode;
        }
        LauncherExitCode launcherExitCode = this.runUnderRoot(context);
        if (launcherExitCode == null) {
            BaseMacDaemonSubCommand.$$$reportNull$$$0(23);
        }
        return launcherExitCode;
    }

    @NotNull
    protected LauncherExitCode runUnderRoot(@NotNull LauncherContextEx context) throws InitException {
        if (context == null) {
            BaseMacDaemonSubCommand.$$$reportNull$$$0(24);
        }
        LauncherExitCode launcherExitCode = super.doRun(context);
        if (launcherExitCode == null) {
            BaseMacDaemonSubCommand.$$$reportNull$$$0(25);
        }
        return launcherExitCode;
    }

    @Nullable
    public LauncherExitCode configureService(@NotNull LauncherContextEx context) throws InitException {
        if (context == null) {
            BaseMacDaemonSubCommand.$$$reportNull$$$0(26);
        }
        return SystemInfo.isRootUser ? super.configureService(context) : null;
    }

    @Nullable
    protected List<String> buildProcessCmdLine(final @NotNull LauncherContext context) {
        if (context == null) {
            BaseMacDaemonSubCommand.$$$reportNull$$$0(27);
        }
        return new ArrayList<String>(){
            {
                this.add("/bin/sh");
                this.add(context.getAppFiles().getMacDaemonScriptFile().getAbsolutePath());
                this.add(BaseMacDaemonSubCommand.this.getMacDaemonScriptCommand());
                this.add(context.getAppConfig().getMacDaemonLabel());
                this.add(BaseMacDaemonSubCommand.getLogsDirPath(context.getAppFiles()));
                BaseMacDaemonSubCommand.this.addCustomMacDaemonScriptArguments(this, context);
            }
        };
    }

    @NotNull
    protected abstract String getMacDaemonScriptCommand();

    protected void addCustomMacDaemonScriptArguments(@NotNull List<String> args, @NotNull LauncherContext context) {
        if (args == null) {
            BaseMacDaemonSubCommand.$$$reportNull$$$0(28);
        }
        if (context == null) {
            BaseMacDaemonSubCommand.$$$reportNull$$$0(29);
        }
    }

    public void printStandaloneUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            BaseMacDaemonSubCommand.$$$reportNull$$$0(30);
        }
        if (context == null) {
            BaseMacDaemonSubCommand.$$$reportNull$$$0(31);
        }
        this.printUsage(printer, context);
        BaseMacDaemonSubCommand.printSudoInfo();
    }

    protected static void printSudoInfo() {
        ConsoleLogger.error((String)"Use \"sudo\" to run this command");
        ConsoleLogger.error();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/ep/commands/BaseMacDaemonSubCommand";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configText";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 17: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "daemonLabel";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appConfigFiles";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceConfigFile";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appFiles";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceCommandName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceTypeName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceNameName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createServiceUninstallCommand";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/ep/commands/BaseMacDaemonSubCommand";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentServiceName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceConfigDistFileName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceConfigFile";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareConfigText";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogsDirPath";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "doRun";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "runUnderRoot";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doGetOldServiceName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentServiceName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "serviceExists";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "serviceLoaded";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isDaemonLine";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getServiceConfigFile";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "prepareConfigText";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getLogsDirPath";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "runUnderRoot";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "configureService";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "buildProcessCmdLine";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addCustomMacDaemonScriptArguments";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "printStandaloneUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

