/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.transport;

import com.jetbrains.launcher.JLThread;
import com.jetbrains.launcher.log.ServerLogger;
import com.jetbrains.launcher.transport.ConnectionData;
import com.jetbrains.launcher.transport.CriticalRequestsHolder;
import com.jetbrains.launcher.transport.Request;
import com.jetbrains.launcher.transport.Response;
import com.jetbrains.launcher.transport.ResponseWriter;
import com.jetbrains.launcher.transport.ResponseWriterImpl;
import com.jetbrains.launcher.util.DateUtil;
import com.jetbrains.launcher.util.NamedDaemonThreadFactory;
import com.jetbrains.launcher.util.RandomStringGenerator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractServer
extends JLThread {
    private static final int SOCKET_READ_TIMEOUT = 30000;
    @NotNull
    private final ServerSocket myServerSocket;
    @NotNull
    private final ExecutorService myExecutor;
    @NotNull
    private final ThreadLocal<Socket> myConnectedSocket;
    @NotNull
    private final CriticalRequestsHolder myCriticalRequestsHolder;
    @NotNull
    private final String myAuthToken;
    @NotNull
    private final ServerLogger myLogger;

    protected AbstractServer(@NotNull String threadName, @NotNull ServerLogger logger) throws IOException {
        if (threadName == null) {
            AbstractServer.$$$reportNull$$$0(0);
        }
        if (logger == null) {
            AbstractServer.$$$reportNull$$$0(1);
        }
        super(threadName);
        this.myServerSocket = new ServerSocket(0, 0, InetAddress.getByName("127.0.0.1"));
        this.myExecutor = Executors.newCachedThreadPool((ThreadFactory)new NamedDaemonThreadFactory("Socket Request Processor"));
        this.myConnectedSocket = new ThreadLocal();
        this.myCriticalRequestsHolder = new CriticalRequestsHolder();
        this.myAuthToken = new RandomStringGenerator().next(32);
        this.myLogger = logger;
        this.setDaemon(true);
        this.log("Server started on port " + this.getConnectionData().getPort());
    }

    public void addCriticalUrl(@NotNull String url) {
        if (url == null) {
            AbstractServer.$$$reportNull$$$0(2);
        }
        this.myCriticalRequestsHolder.addCriticalUrl(url);
    }

    @NotNull
    public ConnectionData getConnectionData() {
        ConnectionData connectionData = new ConnectionData(this.myServerSocket.getLocalPort(), this.myAuthToken);
        if (connectionData == null) {
            AbstractServer.$$$reportNull$$$0(3);
        }
        return connectionData;
    }

    public void run() {
        while (!this.myServerSocket.isClosed()) {
            final Socket socket = this.acceptConnection();
            if (socket == null) continue;
            try {
                final CriticalRequestsHolder.FutureRequestMatcher futureRequestMatcher = this.myCriticalRequestsHolder.createNewFutureRequestMatcher();
                futureRequestMatcher.setFuture(this.myExecutor.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        AbstractServer.this.myConnectedSocket.set(socket);
                        try {
                            socket.setSoTimeout(30000);
                            AbstractServer.this.processConnection(socket, futureRequestMatcher);
                        }
                        catch (IOException e) {
                            AbstractServer.this.log("Failed to process connection: " + e, e);
                        }
                        finally {
                            AbstractServer.this.myConnectedSocket.remove();
                            try {
                                socket.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }));
            }
            catch (Exception exception) {}
        }
    }

    @Nullable
    private Socket acceptConnection() {
        try {
            return this.myServerSocket.accept();
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processConnection(@NotNull Socket socket, @NotNull CriticalRequestsHolder.FutureRequestMatcher futureRequestMatcher) throws IOException {
        if (socket == null) {
            AbstractServer.$$$reportNull$$$0(4);
        }
        if (futureRequestMatcher == null) {
            AbstractServer.$$$reportNull$$$0(5);
        }
        Thread currentThread = Thread.currentThread();
        String oldName = currentThread.getName();
        try {
            Request request = this.readRequest(new ObjectInputStream(socket.getInputStream()));
            if (request == null) {
                return;
            }
            String requestDescription = request.describe();
            JLThread.setName((Thread)currentThread, (String)("[" + DateUtil.getPrettyDateTimeString() + "] " + JLThread.getRawName((String)oldName) + " (Request: " + requestDescription + ")"));
            futureRequestMatcher.setRequest(request);
            final boolean mustLogRequest = this.mustLogRequest(request);
            if (mustLogRequest) {
                this.log("Processing request: " + requestDescription);
            }
            ResponseWriterImpl responseWriter = new ResponseWriterImpl(socket){

                @Override
                protected void logResponse(@NotNull Response response) {
                    if (response == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (mustLogRequest) {
                        AbstractServer.this.log("Sending response: " + response.getCode() + " " + response.getText());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "response", "com/jetbrains/launcher/transport/AbstractServer$2", "logResponse"));
                }
            };
            if (!this.myAuthToken.equals(request.getAuthToken())) {
                this.log("Request was not authenticated: " + requestDescription);
                responseWriter.write(new Response(401, "Invalid auth token"));
                return;
            }
            this.processRequest(request, responseWriter);
        }
        finally {
            currentThread.setName(oldName);
        }
    }

    protected abstract boolean mustLogRequest(@NotNull Request var1);

    @Nullable
    private Request readRequest(@NotNull ObjectInputStream inputStream) throws IOException {
        if (inputStream == null) {
            AbstractServer.$$$reportNull$$$0(6);
        }
        try {
            Object request = inputStream.readObject();
            if (request instanceof Request) {
                return (Request)request;
            }
            this.log("Request object has wrong type: " + request.getClass().getName());
        }
        catch (ClassNotFoundException e) {
            this.log("Failed to read request object", e);
        }
        return null;
    }

    protected abstract void processRequest(@NotNull Request var1, @NotNull ResponseWriter var2) throws IOException;

    public void shutdown() {
        this.log("Shutting the server down...");
        this.myExecutor.shutdown();
        this.myCriticalRequestsHolder.waitForCriticalRequests();
        if (!this.waitForExecutor()) {
            this.myExecutor.shutdownNow();
        }
        try {
            this.myServerSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.log("Server has shut down");
    }

    private boolean waitForExecutor() {
        try {
            return this.myExecutor.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    protected void log(@NotNull String message) {
        if (message == null) {
            AbstractServer.$$$reportNull$$$0(7);
        }
        this.myLogger.debug(this.getLogMessage(message));
    }

    protected void log(@NotNull String message, @NotNull Throwable e) {
        if (message == null) {
            AbstractServer.$$$reportNull$$$0(8);
        }
        if (e == null) {
            AbstractServer.$$$reportNull$$$0(9);
        }
        this.myLogger.debug(this.getLogMessage(message), e);
    }

    @NotNull
    private String getLogMessage(@NotNull String message) {
        if (message == null) {
            AbstractServer.$$$reportNull$$$0(10);
        }
        StringBuilder sb = new StringBuilder("[Server] ");
        Socket socket = this.myConnectedSocket.get();
        if (socket != null) {
            sb.append("[");
            InetAddress inetAddress = socket.getInetAddress();
            if (inetAddress != null) {
                sb.append(inetAddress.getHostAddress()).append(":");
            }
            sb.append(socket.getPort()).append("] ");
        }
        sb.append(message);
        String string = sb.toString();
        if (string == null) {
            AbstractServer.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/transport/AbstractServer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "socket";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "futureRequestMatcher";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/transport/AbstractServer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionData";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addCriticalUrl";
                break;
            }
            case 3: 
            case 11: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processConnection";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readRequest";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "log";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLogMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

