/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.transport;

import com.jetbrains.launcher.log.ServerLogger;
import com.jetbrains.launcher.transport.AbstractServer;
import com.jetbrains.launcher.transport.Request;
import com.jetbrains.launcher.transport.RequestHandler;
import com.jetbrains.launcher.transport.Response;
import com.jetbrains.launcher.transport.ResponseWriter;
import com.jetbrains.launcher.util.DevUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class Server
extends AbstractServer {
    @NotNull
    private final Map<String, RequestHandler> myHandlers;
    @NotNull
    private final Set<String> myFrequentUrls;

    public Server(@NotNull String threadName, @NotNull ServerLogger logger) throws IOException {
        if (threadName == null) {
            Server.$$$reportNull$$$0(0);
        }
        if (logger == null) {
            Server.$$$reportNull$$$0(1);
        }
        super(threadName, logger);
        this.myHandlers = new HashMap<String, RequestHandler>();
        this.myFrequentUrls = new HashSet<String>();
    }

    public void addHandler(@NotNull String url, @NotNull RequestHandler handler) {
        if (url == null) {
            Server.$$$reportNull$$$0(2);
        }
        if (handler == null) {
            Server.$$$reportNull$$$0(3);
        }
        this.myHandlers.put(url, handler);
    }

    public void addFrequentUrl(@NotNull String url) {
        if (url == null) {
            Server.$$$reportNull$$$0(4);
        }
        this.myFrequentUrls.add(url);
    }

    @Override
    protected boolean mustLogRequest(@NotNull Request request) {
        if (request == null) {
            Server.$$$reportNull$$$0(5);
        }
        return !this.myFrequentUrls.contains(request.getURL()) || DevUtil.isDevMode();
    }

    @Override
    protected void processRequest(@NotNull Request request, @NotNull ResponseWriter responseWriter) throws IOException {
        String url;
        RequestHandler handler;
        if (request == null) {
            Server.$$$reportNull$$$0(6);
        }
        if (responseWriter == null) {
            Server.$$$reportNull$$$0(7);
        }
        if ((handler = this.myHandlers.get(url = request.getURL())) == null) {
            this.log("Handler is not registered for request: " + request.describe());
            responseWriter.write(new Response(404, "URL \"" + url + "\" is not found"));
            return;
        }
        try {
            handler.processRequest(request, responseWriter);
            if (!responseWriter.isResponseWritten()) {
                responseWriter.write(new Response(500, "No response"));
            }
        }
        catch (Throwable e) {
            this.log("Failed to process request (" + request.describe() + ")", e);
            responseWriter.write(new Response(500, e.getMessage()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "responseWriter";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/launcher/transport/Server";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addFrequentUrl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "mustLogRequest";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "processRequest";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

