/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessContext {
    @NotNull
    private static final InheritableThreadLocal<ProcessContext> myProcessContext = new InheritableThreadLocal<ProcessContext>(){

        @Override
        protected ProcessContext initialValue() {
            return new ProcessContext(null);
        }
    };
    @NotNull
    private final ConcurrentMap<Key, Object> myValues = new ConcurrentHashMap<Key, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessContext(@Nullable ProcessContext parentContext) {
        if (parentContext != null) {
            ConcurrentMap<Key, Object> concurrentMap = parentContext.myValues;
            synchronized (concurrentMap) {
                this.myValues.putAll(parentContext.myValues);
            }
        }
    }

    public static void initChildContext(@NotNull ProcessContext parentContext) {
        if (parentContext == null) {
            ProcessContext.$$$reportNull$$$0(0);
        }
        ProcessContext.set(new ProcessContext(parentContext));
    }

    @NotNull
    public static ProcessContext get() {
        ProcessContext processContext = (ProcessContext)myProcessContext.get();
        if (processContext == null) {
            ProcessContext.$$$reportNull$$$0(1);
        }
        return processContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runInContext(@NotNull Runnable action) {
        if (action == null) {
            ProcessContext.$$$reportNull$$$0(2);
        }
        ProcessContext oldProcessContext = ProcessContext.get();
        try {
            ProcessContext.set(this);
            action.run();
        }
        finally {
            ProcessContext.set(oldProcessContext);
        }
    }

    private static void set(@NotNull ProcessContext context) {
        if (context == null) {
            ProcessContext.$$$reportNull$$$0(3);
        }
        myProcessContext.set(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public <T> T getOrCreateValue(@NotNull Key<T> key) {
        T value;
        if (key == null) {
            ProcessContext.$$$reportNull$$$0(4);
        }
        if ((value = this.getValue(key)) != null) {
            T t = value;
            if (t == null) {
                ProcessContext.$$$reportNull$$$0(5);
            }
            return t;
        }
        ConcurrentMap<Key, Object> concurrentMap = this.myValues;
        synchronized (concurrentMap) {
            value = this.getValue(key);
            if (value == null) {
                value = this.createValue(key);
            }
        }
        T t = value;
        if (t == null) {
            ProcessContext.$$$reportNull$$$0(6);
        }
        return t;
    }

    @Nullable
    public <T> T getValue(@NotNull Key<T> key) {
        if (key == null) {
            ProcessContext.$$$reportNull$$$0(7);
        }
        return (T)this.myValues.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public <T> T createValue(@NotNull Key<T> key) {
        if (key == null) {
            ProcessContext.$$$reportNull$$$0(8);
        }
        ConcurrentMap<Key, Object> concurrentMap = this.myValues;
        // MONITORENTER : concurrentMap
        T value = key.createDefaultValue();
        this.myValues.put(key, value);
        T t = value;
        // MONITOREXIT : concurrentMap
        if (t != null) return t;
        ProcessContext.$$$reportNull$$$0(9);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void setValue(@NotNull Key<T> key, @NotNull T value) {
        if (key == null) {
            ProcessContext.$$$reportNull$$$0(10);
        }
        if (value == null) {
            ProcessContext.$$$reportNull$$$0(11);
        }
        ConcurrentMap<Key, Object> concurrentMap = this.myValues;
        synchronized (concurrentMap) {
            this.myValues.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ConcurrentMap<Key, Object> concurrentMap = this.myValues;
        synchronized (concurrentMap) {
            this.myValues.clear();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentContext";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/ProcessContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/ProcessContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateValue";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initChildContext";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "runInContext";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createValue";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Key<T> {
        @NotNull
        public T createDefaultValue();
    }
}

