/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.util;

import com.jetbrains.launcher.SystemInfo;
import com.jetbrains.launcher.UserMessageTransformer;
import com.jetbrains.launcher.util.StringUtil;
import com.jetbrains.launcher.util.ThreadUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileUtil {
    @NotNull
    public static final String UTF_8 = "UTF-8";

    @NotNull
    public static File resolvePath(@NotNull File baseDir, @NotNull String path) {
        File file;
        if (baseDir == null) {
            FileUtil.$$$reportNull$$$0(0);
        }
        if (path == null) {
            FileUtil.$$$reportNull$$$0(1);
        }
        File file2 = (file = new File(path)).isAbsolute() ? file : new File(baseDir, path);
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(2);
        }
        return file2;
    }

    @NotNull
    public static String loadText(@NotNull File file) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(3);
        }
        String string = FileUtil.loadText(file, UTF_8);
        if (string == null) {
            FileUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String loadText(@NotNull File file, @NotNull String charsetName) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(5);
        }
        if (charsetName == null) {
            FileUtil.$$$reportNull$$$0(6);
        }
        String string = FileUtil.loadText(file.toURI().toURL(), charsetName);
        if (string == null) {
            FileUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static String loadText(@NotNull URL url) throws IOException {
        if (url == null) {
            FileUtil.$$$reportNull$$$0(8);
        }
        String string = FileUtil.loadText(url, UTF_8);
        if (string == null) {
            FileUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static String loadText(@NotNull URL url, @NotNull String charsetName) throws IOException {
        String string;
        if (url == null) {
            FileUtil.$$$reportNull$$$0(10);
        }
        if (charsetName == null) {
            FileUtil.$$$reportNull$$$0(11);
        }
        InputStreamReader fis = null;
        try {
            int c;
            fis = new InputStreamReader((InputStream)new BufferedInputStream(FileUtil.openStream(url)), charsetName);
            StringBuilder sb = new StringBuilder();
            while ((c = ((Reader)fis).read()) >= 0) {
                sb.append((char)c);
            }
            string = sb.toString();
        }
        catch (IOException e) {
            try {
                throw new IOException(UserMessageTransformer.transform("Failed to read file \"" + url.toExternalForm() + "\": " + e.getMessage()), e);
            }
            catch (Throwable throwable) {
                FileUtil.close(fis);
                throw throwable;
            }
        }
        FileUtil.close(fis);
        String string2 = string;
        if (string2 == null) {
            FileUtil.$$$reportNull$$$0(12);
        }
        return string2;
    }

    @NotNull
    public static InputStream openStream(@NotNull URL url) throws IOException {
        if (url == null) {
            FileUtil.$$$reportNull$$$0(13);
        }
        URLConnection urlConnection = url.openConnection();
        urlConnection.setUseCaches(false);
        InputStream inputStream = urlConnection.getInputStream();
        if (inputStream == null) {
            FileUtil.$$$reportNull$$$0(14);
        }
        return inputStream;
    }

    public static void setFileFlag(@NotNull File file) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(15);
        }
        FileUtil.saveText(file, "");
    }

    public static void saveText(@NotNull File file, @NotNull String text) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(16);
        }
        if (text == null) {
            FileUtil.$$$reportNull$$$0(17);
        }
        FileUtil.saveText(file, text, UTF_8);
    }

    public static void saveText(@NotNull File file, @NotNull String text, @NotNull String charsetName) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(18);
        }
        if (text == null) {
            FileUtil.$$$reportNull$$$0(19);
        }
        if (charsetName == null) {
            FileUtil.$$$reportNull$$$0(20);
        }
        OutputStreamWriter fis = null;
        try {
            FileUtil.ensureParent(file);
            fis = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), charsetName);
            fis.write(text);
            ((Writer)fis).flush();
        }
        catch (IOException e) {
            try {
                throw new IOException(UserMessageTransformer.transform("Failed to write " + file + ". " + e.getMessage()), e);
            }
            catch (Throwable throwable) {
                FileUtil.close(fis);
                throw throwable;
            }
        }
        FileUtil.close(fis);
    }

    @NotNull
    public static List<String> readLines(@NotNull File file) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(21);
        }
        List<String> list = FileUtil.readLines(file, UTF_8);
        if (list == null) {
            FileUtil.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    public static List<String> readLines(@NotNull File file, @NotNull String charsetName) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(23);
        }
        if (charsetName == null) {
            FileUtil.$$$reportNull$$$0(24);
        }
        if (!file.exists()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                FileUtil.$$$reportNull$$$0(25);
            }
            return list;
        }
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            try {
                throw new IOException(UserMessageTransformer.transform("Failed to read file \"" + file.getAbsolutePath() + "\": " + e.getMessage()), e);
            }
            catch (Throwable throwable) {
                FileUtil.close(reader);
                throw throwable;
            }
        }
        FileUtil.close(reader);
        ArrayList<String> arrayList = lines;
        if (arrayList == null) {
            FileUtil.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    public static void writeLines(@NotNull File file, @NotNull List<String> lines) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(27);
        }
        if (lines == null) {
            FileUtil.$$$reportNull$$$0(28);
        }
        FileUtil.writeLines(file, lines, UTF_8);
    }

    public static void writeLines(@NotNull File file, @NotNull List<String> lines, @NotNull String charsetName) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(29);
        }
        if (lines == null) {
            FileUtil.$$$reportNull$$$0(30);
        }
        if (charsetName == null) {
            FileUtil.$$$reportNull$$$0(31);
        }
        BufferedWriter writer = null;
        try {
            FileUtil.ensureParent(file);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charsetName));
            for (String line : lines) {
                writer.write(line);
                writer.newLine();
            }
            writer.flush();
        }
        catch (IOException e) {
            try {
                throw new IOException(UserMessageTransformer.transform("Failed to write file \"" + file.getAbsolutePath() + "\": " + e.getMessage()), e);
            }
            catch (Throwable throwable) {
                FileUtil.close(writer);
                throw throwable;
            }
        }
        FileUtil.close(writer);
    }

    private static void ensureParent(@NotNull File file) throws IOException {
        File parent;
        if (file == null) {
            FileUtil.$$$reportNull$$$0(32);
        }
        if ((parent = file.getParentFile()) == null) {
            throw new IOException(UserMessageTransformer.transform("Failed to find parent file for: " + file.getAbsolutePath()));
        }
        FileUtil.mkdirs(parent);
    }

    public static void mkdirs(@NotNull File dir) throws IOException {
        if (dir == null) {
            FileUtil.$$$reportNull$$$0(33);
        }
        if (!FileUtil.mkdirsInternal(dir)) {
            throw new IOException(UserMessageTransformer.transform("Failed to create directory: " + dir.getAbsolutePath()));
        }
    }

    private static boolean mkdirsInternal(final @NotNull File dir) {
        if (dir == null) {
            FileUtil.$$$reportNull$$$0(34);
        }
        return dir.isDirectory() || FileUtil.runFSActionWithRetry(new FSAction(){

            @Override
            public boolean run() {
                dir.mkdirs();
                return dir.isDirectory();
            }

            @Override
            public boolean onFailed() {
                return false;
            }
        });
    }

    public static void close(@Nullable Closeable is) {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean isFileInside(@NotNull File baseDir, @NotNull File file) {
        if (baseDir == null) {
            FileUtil.$$$reportNull$$$0(35);
        }
        if (file == null) {
            FileUtil.$$$reportNull$$$0(36);
        }
        return FileUtil.isInnerPath(FileUtil.getRelativePath(baseDir, file));
    }

    @NotNull
    public static String getShortPath(@NotNull File baseDir, @NotNull File file) {
        if (baseDir == null) {
            FileUtil.$$$reportNull$$$0(37);
        }
        if (file == null) {
            FileUtil.$$$reportNull$$$0(38);
        }
        String relativePath = FileUtil.getRelativePath(baseDir, file);
        String absolutePath = FileUtil.getCanonicalPath(file);
        String string = relativePath.length() < absolutePath.length() ? relativePath : absolutePath;
        if (string == null) {
            FileUtil.$$$reportNull$$$0(39);
        }
        return string;
    }

    @NotNull
    public static String getRelativePath(@NotNull File baseDir, @NotNull File file) {
        String string;
        int commonCount;
        List<String> filePath;
        block13: {
            String string2;
            block14: {
                List<String> baseDirPath;
                block12: {
                    if (baseDir == null) {
                        FileUtil.$$$reportNull$$$0(40);
                    }
                    if (file == null) {
                        FileUtil.$$$reportNull$$$0(41);
                    }
                    baseDirPath = FileUtil.getFilePath(baseDir);
                    filePath = FileUtil.getFilePath(file);
                    int minSize = Math.min(baseDirPath.size(), filePath.size());
                    for (commonCount = 0; commonCount < minSize && FileUtil.fileNamesAreEqual(baseDirPath.get(commonCount), filePath.get(commonCount)); ++commonCount) {
                    }
                    if (commonCount != 0) break block12;
                    String string3 = file.getAbsolutePath();
                    if (string3 == null) {
                        FileUtil.$$$reportNull$$$0(42);
                    }
                    return string3;
                }
                if (baseDirPath.size() != commonCount || filePath.size() != commonCount) break block13;
                string2 = ".";
                if ("." != null) break block14;
                FileUtil.$$$reportNull$$$0(43);
            }
            return string2;
        }
        try {
            int i;
            StringBuilder sb = new StringBuilder();
            for (i = baseDirPath.size(); i > commonCount; --i) {
                StringUtil.append(sb, File.separator, "..");
            }
            for (i = commonCount; i < filePath.size(); ++i) {
                StringUtil.append(sb, File.separator, filePath.get(i));
            }
            string = sb.toString();
        }
        catch (IOException e) {
            String string4 = file.getAbsolutePath();
            if (string4 == null) {
                FileUtil.$$$reportNull$$$0(45);
            }
            return string4;
        }
        if (string == null) {
            FileUtil.$$$reportNull$$$0(44);
        }
        return string;
    }

    @NotNull
    private static String getCanonicalPath(@NotNull File file) {
        String string;
        if (file == null) {
            FileUtil.$$$reportNull$$$0(46);
        }
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException e) {
            String string2 = file.getAbsolutePath();
            if (string2 == null) {
                FileUtil.$$$reportNull$$$0(48);
            }
            return string2;
        }
        if (string == null) {
            FileUtil.$$$reportNull$$$0(47);
        }
        return string;
    }

    @NotNull
    private static List<String> getFilePath(@NotNull File file) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(49);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (File parent = file.getCanonicalFile(); parent != null; parent = parent.getParentFile()) {
            result.add(0, FileUtil.getFileName(parent));
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            FileUtil.$$$reportNull$$$0(50);
        }
        return arrayList;
    }

    @NotNull
    private static String getFileName(@NotNull File file) {
        String name;
        if (file == null) {
            FileUtil.$$$reportNull$$$0(51);
        }
        if ((name = file.getName()).trim().length() != 0) {
            String string = name;
            if (string == null) {
                FileUtil.$$$reportNull$$$0(52);
            }
            return string;
        }
        if (file.getParentFile() == null) {
            String string = file.getAbsolutePath();
            if (string == null) {
                FileUtil.$$$reportNull$$$0(53);
            }
            return string;
        }
        String string = name;
        if (string == null) {
            FileUtil.$$$reportNull$$$0(54);
        }
        return string;
    }

    private static boolean fileNamesAreEqual(@NotNull String fileName1, @NotNull String fileName2) {
        if (fileName1 == null) {
            FileUtil.$$$reportNull$$$0(55);
        }
        if (fileName2 == null) {
            FileUtil.$$$reportNull$$$0(56);
        }
        return SystemInfo.isWindows ? fileName1.equalsIgnoreCase(fileName2) : fileName1.equals(fileName2);
    }

    public static boolean isInnerPath(@NotNull String relativePath) {
        if (relativePath == null) {
            FileUtil.$$$reportNull$$$0(57);
        }
        int depth = 0;
        for (String pathPart : relativePath.split(Pattern.quote(File.separator))) {
            if (pathPart.equals(".")) continue;
            if (pathPart.equals("..")) {
                if (--depth >= 0) continue;
                return false;
            }
            ++depth;
        }
        return true;
    }

    @NotNull
    public static URL getFileInJarUrl(@NotNull File jar, @NotNull String filePath) throws MalformedURLException {
        if (jar == null) {
            FileUtil.$$$reportNull$$$0(58);
        }
        if (filePath == null) {
            FileUtil.$$$reportNull$$$0(59);
        }
        URL uRL = new URL("jar:" + FileUtil.toURL(jar).toExternalForm() + "!/" + filePath);
        if (uRL == null) {
            FileUtil.$$$reportNull$$$0(60);
        }
        return uRL;
    }

    @NotNull
    public static URL toURL(@NotNull File file) {
        URL uRL;
        if (file == null) {
            FileUtil.$$$reportNull$$$0(61);
        }
        try {
            uRL = file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        if (uRL == null) {
            FileUtil.$$$reportNull$$$0(62);
        }
        return uRL;
    }

    public static boolean runFSActionWithRetry(@NotNull FSAction action) {
        if (action == null) {
            FileUtil.$$$reportNull$$$0(63);
        }
        for (int attempts = 0; attempts < 5; ++attempts) {
            if (action.run()) {
                return true;
            }
            ThreadUtil.sleep(200L);
        }
        return action.onFailed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(@NotNull File fromFile, @NotNull File toFile) throws IOException {
        if (fromFile == null) {
            FileUtil.$$$reportNull$$$0(64);
        }
        if (toFile == null) {
            FileUtil.$$$reportNull$$$0(65);
        }
        FileInputStream fis = new FileInputStream(fromFile);
        try {
            FileUtil.copy(fis, toFile);
        }
        finally {
            FileUtil.close(fis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(@NotNull URL fromUrl, @NotNull File toFile) throws IOException {
        if (fromUrl == null) {
            FileUtil.$$$reportNull$$$0(66);
        }
        if (toFile == null) {
            FileUtil.$$$reportNull$$$0(67);
        }
        InputStream is = FileUtil.openStream(fromUrl);
        try {
            FileUtil.copy(is, toFile);
        }
        finally {
            FileUtil.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(@NotNull InputStream fromStream, @NotNull File toFile) throws IOException {
        if (fromStream == null) {
            FileUtil.$$$reportNull$$$0(68);
        }
        if (toFile == null) {
            FileUtil.$$$reportNull$$$0(69);
        }
        FileOutputStream fos = new FileOutputStream(toFile);
        try {
            FileUtil.copyStreams(fromStream, fos);
        }
        finally {
            FileUtil.close(fos);
        }
    }

    public static void copyStreams(@NotNull InputStream input, @NotNull OutputStream output) throws IOException {
        if (input == null) {
            FileUtil.$$$reportNull$$$0(70);
        }
        if (output == null) {
            FileUtil.$$$reportNull$$$0(71);
        }
        byte[] buffer = new byte[65536];
        int read = 0;
        while (read != -1) {
            read = input.read(buffer, 0, buffer.length);
            if (read == -1) continue;
            output.write(buffer, 0, read);
        }
    }

    public static boolean delete(final @NotNull File file) {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(72);
        }
        return !file.exists() || FileUtil.runFSActionWithRetry(new FSAction(){

            @Override
            public boolean run() {
                file.delete();
                return !file.exists();
            }

            @Override
            public boolean onFailed() {
                return false;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 22: 
            case 25: 
            case 26: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 60: 
            case 62: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 22: 
            case 25: 
            case 26: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 60: 
            case 62: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 22: 
            case 25: 
            case 26: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 60: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/util/FileUtil";
                break;
            }
            case 3: 
            case 5: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 27: 
            case 29: 
            case 32: 
            case 36: 
            case 38: 
            case 41: 
            case 46: 
            case 49: 
            case 51: 
            case 61: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 11: 
            case 20: 
            case 24: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charsetName";
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName1";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName2";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jar";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromFile";
                break;
            }
            case 65: 
            case 67: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toFile";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromUrl";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromStream";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/util/FileUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePath";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "openStream";
                break;
            }
            case 22: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "readLines";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortPath";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalPath";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileInJarUrl";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "toURL";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolvePath";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 22: 
            case 25: 
            case 26: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 60: 
            case 62: {
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "openStream";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setFileFlag";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "saveText";
                break;
            }
            case 21: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "readLines";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "writeLines";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "ensureParent";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "mkdirs";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "mkdirsInternal";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isFileInside";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getShortPath";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalPath";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getFilePath";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getFileName";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "fileNamesAreEqual";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isInnerPath";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getFileInJarUrl";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "toURL";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "runFSActionWithRetry";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "copyStreams";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 22: 
            case 25: 
            case 26: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 60: 
            case 62: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface FSAction {
        public boolean run();

        public boolean onFailed();
    }
}

