/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OptionsProcessor<Opt, PLine extends ParsedLine<PLine, Opt>, E extends Throwable> {
    @NotNull
    private final Map<String, Opt> myNewOptions;
    private final boolean myFixCommentedOptionsOnly;

    public OptionsProcessor(@NotNull Map<String, Opt> newOptions, boolean fixCommentedOptionsOnly) {
        if (newOptions == null) {
            OptionsProcessor.$$$reportNull$$$0(0);
        }
        this.myNewOptions = newOptions;
        this.myFixCommentedOptionsOnly = fixCommentedOptionsOnly;
    }

    @NotNull
    public List<String> processOptionLines(@NotNull List<String> lines) throws E {
        Opt option;
        String key;
        if (lines == null) {
            OptionsProcessor.$$$reportNull$$$0(1);
        }
        HashSet<String> updatedKeys = new HashSet<String>();
        List<PLine> parsedLines = this.parseLines(lines);
        for (int i = parsedLines.size() - 1; i >= 0; --i) {
            ParsedLine line = (ParsedLine)parsedLines.get(i);
            key = line.getKey();
            if (key == null || !this.myNewOptions.containsKey(key)) continue;
            option = this.myNewOptions.get(key);
            if (this.myFixCommentedOptionsOnly) {
                if (this.isOptionToRemove(option) || !line.isCommented() || line.isRemovingLine()) continue;
                parsedLines.set(i, this.createLine(key, option).commentOut());
                continue;
            }
            if (this.isOptionToRemove(option)) {
                if (line.isRemovingLine()) {
                    if (line.hasSameValue(option) && updatedKeys.add(key)) {
                        parsedLines.set(i, this.createLine(key, option));
                        continue;
                    }
                    parsedLines.set(i, line.commentOut());
                    continue;
                }
                parsedLines.set(i, line.commentOut());
                if (!this.addRemovingLines() || !updatedKeys.add(key)) continue;
                parsedLines.add(i + 1, this.createLine(key, option));
                continue;
            }
            if (line.isRemovingLine()) {
                if (updatedKeys.contains(key)) continue;
                parsedLines.set(i, line.commentOut());
                continue;
            }
            if (!updatedKeys.add(key)) continue;
            parsedLines.set(i, this.createLine(key, option));
        }
        if (!this.myFixCommentedOptionsOnly) {
            for (Map.Entry<String, Opt> entry : this.myNewOptions.entrySet()) {
                key = entry.getKey();
                if (!updatedKeys.add(key) || (option = entry.getValue()) == null) continue;
                parsedLines.add(this.createLine(key, option));
            }
        }
        List<String> list = this.getRawLines(parsedLines);
        if (list == null) {
            OptionsProcessor.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    private List<PLine> parseLines(@NotNull List<String> lines) throws E {
        if (lines == null) {
            OptionsProcessor.$$$reportNull$$$0(3);
        }
        ArrayList<PLine> result = new ArrayList<PLine>(lines.size());
        for (String line : lines) {
            result.add(this.parseLine(line));
        }
        ArrayList<PLine> arrayList = result;
        if (arrayList == null) {
            OptionsProcessor.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    private PLine parseLine(@NotNull String line) throws E {
        if (line == null) {
            OptionsProcessor.$$$reportNull$$$0(5);
        }
        String commentPrefix = this.getCommentPrefix();
        String actualLine = line.trim();
        boolean isCommented = false;
        while (actualLine.startsWith(commentPrefix)) {
            isCommented = true;
            actualLine = actualLine.substring(commentPrefix.length()).trim();
        }
        PLine PLine = this.doParseLine(line, actualLine, isCommented);
        if (PLine == null) {
            OptionsProcessor.$$$reportNull$$$0(6);
        }
        return PLine;
    }

    @NotNull
    protected abstract String getCommentPrefix();

    @NotNull
    protected abstract PLine doParseLine(@NotNull String var1, @NotNull String var2, boolean var3) throws E;

    @Contract(value="null -> true")
    protected abstract boolean isOptionToRemove(@Nullable Opt var1);

    @NotNull
    protected abstract PLine createLine(@NotNull String var1, @NotNull Opt var2);

    protected abstract boolean addRemovingLines();

    @NotNull
    private List<String> getRawLines(@NotNull List<PLine> parsedLines) {
        if (parsedLines == null) {
            OptionsProcessor.$$$reportNull$$$0(7);
        }
        ArrayList<String> result = new ArrayList<String>(parsedLines.size());
        for (ParsedLine parsedLine : parsedLines) {
            result.add(parsedLine.getRawLine());
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            OptionsProcessor.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newOptions";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/util/OptionsProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsedLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/util/OptionsProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "processOptionLines";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseLines";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseLine";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processOptionLines";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseLines";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseLine";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRawLines";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ParsedLine<T extends ParsedLine<T, Opt>, Opt> {
        public boolean isCommented();

        public boolean isRemovingLine();

        @Nullable
        public String getKey();

        @NotNull
        public String getRawLine();

        @NotNull
        public T commentOut();

        public boolean hasSameValue(@NotNull Opt var1);
    }
}

