/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.util;

import com.jetbrains.launcher.Destroyer;
import com.jetbrains.launcher.DestroyerStep;
import com.jetbrains.launcher.util.ThreadUtil;
import com.jetbrains.launcher.util.TimeoutException;
import org.jetbrains.annotations.Nullable;

public abstract class WaitFor<E extends Throwable> {
    private volatile boolean myInterrupted = false;

    public WaitFor(@Nullable Long timeoutMillis) throws TimeoutException, InterruptedException, E {
        this(timeoutMillis, 100L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WaitFor(@Nullable Long timeoutMillis, long delayMillis) throws TimeoutException, InterruptedException, E {
        DestroyerStep destroyerStep = Destroyer.get().addStep(new Runnable(){

            @Override
            public void run() {
                WaitFor.this.myInterrupted = true;
            }
        });
        try {
            Long deadline = timeoutMillis == null ? null : Long.valueOf(System.currentTimeMillis() + timeoutMillis);
            do {
                this.checkNotInterrupted();
                if (this.condition()) {
                    return;
                }
                ThreadUtil.sleep(delayMillis);
            } while (deadline == null || System.currentTimeMillis() < deadline);
            this.checkNotInterrupted();
            if (!this.condition()) {
                throw new TimeoutException();
            }
        }
        finally {
            destroyerStep.remove();
        }
    }

    private void checkNotInterrupted() throws InterruptedException {
        if (this.myInterrupted) {
            throw new InterruptedException("Interrupted");
        }
    }

    protected abstract boolean condition() throws E;
}

