/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.util.process;

import com.jetbrains.launcher.util.process.ProcessOutputPart;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessOutputReader
implements Closeable {
    public static final int AVERAGE_LINE_SIZE = 80;
    private static final int BUFFER_SIZE = 8192;
    @NotNull
    private final Reader myReader;
    @NotNull
    private final CharBuffer myBuffer;
    private boolean mySkipLF;
    private boolean myLineStart;

    public ProcessOutputReader(@NotNull Reader reader) {
        if (reader == null) {
            ProcessOutputReader.$$$reportNull$$$0(0);
        }
        this.mySkipLF = false;
        this.myLineStart = true;
        this.myReader = reader;
        this.myBuffer = CharBuffer.allocate(8192);
        this.myBuffer.limit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ProcessOutputPart readNextPart() throws IOException {
        if (!this.myBuffer.hasRemaining() && !this.fillBuffer()) {
            return null;
        }
        StringBuilder text = new StringBuilder(80);
        boolean lineEnd = this.readLineFromBuffer(text);
        try {
            ProcessOutputPart processOutputPart = new ProcessOutputPart(text.toString(), this.myLineStart, lineEnd);
            return processOutputPart;
        }
        finally {
            this.myLineStart = lineEnd;
        }
    }

    private boolean readLineFromBuffer(@NotNull StringBuilder text) {
        if (text == null) {
            ProcessOutputReader.$$$reportNull$$$0(1);
        }
        while (this.myBuffer.hasRemaining()) {
            char symbol = this.myBuffer.get();
            if (this.mySkipLF) {
                this.mySkipLF = false;
                if (symbol == '\n') continue;
            }
            if (symbol == '\r') {
                this.mySkipLF = true;
                return true;
            }
            if (symbol == '\n') {
                return true;
            }
            text.append(symbol);
        }
        return false;
    }

    private boolean fillBuffer() throws IOException {
        this.myBuffer.clear();
        if (this.myReader.read(this.myBuffer) == -1) {
            return false;
        }
        this.myBuffer.flip();
        return true;
    }

    @Override
    public void close() throws IOException {
        this.myBuffer.clear();
        this.myReader.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/launcher/util/process/ProcessOutputReader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "readLineFromBuffer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

