/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.util.stream;

import com.jetbrains.launcher.JLThread;
import com.jetbrains.launcher.util.Event;
import com.jetbrains.launcher.util.FileUtil;
import com.jetbrains.launcher.util.stream.SourceNonLockingStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAsyncReader<R extends Closeable>
extends JLThread {
    @NotNull
    private final SourceNonLockingStream mySource;
    @NotNull
    private final Event.SimpleEvent myReadingFinishedEvent;
    private volatile boolean myCancelled;
    private volatile IOException myError;

    protected AbstractAsyncReader(@NotNull String threadName, @NotNull InputStream source) {
        if (threadName == null) {
            AbstractAsyncReader.$$$reportNull$$$0(0);
        }
        if (source == null) {
            AbstractAsyncReader.$$$reportNull$$$0(1);
        }
        super(threadName);
        this.myReadingFinishedEvent = new Event.SimpleEvent();
        this.myCancelled = false;
        this.setDaemon(true);
        this.mySource = new SourceNonLockingStream(source);
    }

    public void cancel() {
        this.myCancelled = true;
        FileUtil.close(this.mySource);
    }

    public void prepareToFinish() {
        this.mySource.treatNonAvailableInputAsEOF();
    }

    public void waitFor() {
        this.myReadingFinishedEvent.waitFor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Closeable reader = null;
        try {
            reader = (Closeable)this.createReader(this.mySource);
            while (!this.myCancelled && this.doRead(reader)) {
            }
        }
        catch (IOException e) {
            if (!this.myCancelled) {
                this.myError = e;
            }
        }
        finally {
            FileUtil.close(reader);
            this.myReadingFinishedEvent.fire();
        }
    }

    @Nullable
    public IOException getError() {
        return this.myError;
    }

    @NotNull
    protected abstract R createReader(@NotNull InputStream var1) throws IOException;

    protected abstract boolean doRead(@NotNull R var1) throws IOException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "threadName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "source";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/launcher/util/stream/AbstractAsyncReader";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

