/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.util.stream;

import com.jetbrains.launcher.util.ThreadUtil;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

class SourceNonLockingStream
extends InputStream {
    @NotNull
    private final InputStream mySource;
    private volatile boolean myTreatNonAvailableInputAsEOF;
    private volatile boolean myClosed;

    public SourceNonLockingStream(@NotNull InputStream source) {
        if (source == null) {
            SourceNonLockingStream.$$$reportNull$$$0(0);
        }
        this.myTreatNonAvailableInputAsEOF = false;
        this.myClosed = false;
        this.mySource = source;
    }

    @Override
    public int read() throws IOException {
        if (!this.waitForInput()) {
            return -1;
        }
        return this.mySource.read();
    }

    @Override
    public int read(@NotNull byte[] buf, int offset, int len) throws IOException {
        if (buf == null) {
            SourceNonLockingStream.$$$reportNull$$$0(1);
        }
        if (len == 0) {
            return 0;
        }
        if (!this.waitForInput()) {
            return -1;
        }
        return this.mySource.read(buf, offset, Math.min(len, this.available()));
    }

    private boolean waitForInput() throws IOException {
        while (this.available() == 0) {
            if (this.myTreatNonAvailableInputAsEOF) {
                return false;
            }
            this.checkClosed();
            ThreadUtil.sleep(10L);
        }
        return true;
    }

    @Override
    public int available() throws IOException {
        return this.mySource.available();
    }

    private void checkClosed() throws IOException {
        if (this.myClosed) {
            throw new IOException("Stream is closed");
        }
    }

    public void treatNonAvailableInputAsEOF() {
        this.myTreatNonAvailableInputAsEOF = true;
    }

    @Override
    public void close() throws IOException {
        this.myClosed = true;
        this.mySource.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/launcher/util/stream/SourceNonLockingStream";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

