/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.util;

import com.jetbrains.launcher.Static;
import com.jetbrains.launcher.SystemInfo;
import com.jetbrains.launcher.log.Console;
import com.jetbrains.launcher.util.ThreadUtil;
import java.io.File;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemUtil {
    @Static
    @Nullable
    private static volatile Long ourExitDelay = null;

    public static void loadDll(@NotNull File dir, @NotNull String dllName) {
        if (dir == null) {
            SystemUtil.$$$reportNull$$$0(0);
        }
        if (dllName == null) {
            SystemUtil.$$$reportNull$$$0(1);
        }
        System.load(new File(dir, dllName + (SystemInfo.isJvm64Bit ? "64" : "32") + ".dll").getAbsolutePath());
    }

    public static void setExitDelay(long exitDelayMilliseconds) {
        ourExitDelay = exitDelayMilliseconds;
    }

    @Contract(value="_ -> fail")
    public static void exit(int exitCode) {
        Console.flush();
        Long exitDelay = ourExitDelay;
        if (exitDelay != null) {
            ThreadUtil.sleep((long)exitDelay);
        }
        System.exit(exitCode);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dir";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dllName";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/launcher/util/SystemUtil";
        objectArray[2] = "loadDll";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

