/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.configs;

import com.jetbrains.launcher.AppConfigFilesEx;
import com.jetbrains.launcher.AppFixedFilesEx;
import com.jetbrains.launcher.AppName;
import com.jetbrains.launcher.AppNameImpl;
import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.ProcessContext;
import com.jetbrains.launcher.Resource;
import com.jetbrains.launcher.configs.AppConfig;
import com.jetbrains.launcher.configs.properties.AppConfigProperty;
import com.jetbrains.launcher.configs.properties.BaseDirProperty;
import com.jetbrains.launcher.configs.properties.ConfDirProperty;
import com.jetbrains.launcher.configs.properties.DescriptionProperty;
import com.jetbrains.launcher.configs.properties.DisplayNameProperty;
import com.jetbrains.launcher.configs.properties.LauncherLogsDirProperty;
import com.jetbrains.launcher.configs.properties.LibDirProperty;
import com.jetbrains.launcher.configs.properties.LogsDirProperty;
import com.jetbrains.launcher.configs.properties.MacDaemonLabelProperty;
import com.jetbrains.launcher.configs.properties.MacDaemonUserProperty;
import com.jetbrains.launcher.configs.properties.StartTimeoutProperty;
import com.jetbrains.launcher.configs.properties.StopTimeoutProperty;
import com.jetbrains.launcher.configs.properties.WinServiceNameProperty;
import com.jetbrains.launcher.configs.properties.YourKitHomeProperty;
import com.jetbrains.launcher.util.NameUtil;
import com.jetbrains.launcher.util.PropertiesUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppConfigImpl
implements AppConfig {
    @NotNull
    private static final ProcessContext.Key<Map<String, AppConfigProperty>> ALL_PROPERTIES_KEY = new ProcessContext.Key<Map<String, AppConfigProperty>>(){

        @NotNull
        public Map<String, AppConfigProperty> createDefaultValue() {
            Map<String, AppConfigProperty> map = this.toMap(new DisplayNameProperty(), new DescriptionProperty(), new WinServiceNameProperty(), new MacDaemonLabelProperty(), new MacDaemonUserProperty(), new StartTimeoutProperty(), new StopTimeoutProperty(), new BaseDirProperty(), new ConfDirProperty(), new LibDirProperty(), new LogsDirProperty(), new LauncherLogsDirProperty(), new YourKitHomeProperty());
            if (map == null) {
                1.$$$reportNull$$$0(0);
            }
            return map;
        }

        @NotNull
        private Map<String, AppConfigProperty> toMap(AppConfigProperty ... properties) {
            if (properties == null) {
                1.$$$reportNull$$$0(1);
            }
            HashMap<String, AppConfigProperty> result = new HashMap<String, AppConfigProperty>();
            for (AppConfigProperty property : properties) {
                result.put(property.getName(), property);
            }
            HashMap<String, AppConfigProperty> hashMap = result;
            if (hashMap == null) {
                1.$$$reportNull$$$0(2);
            }
            return hashMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/launcher/configs/AppConfigImpl$1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDefaultValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/launcher/configs/AppConfigImpl$1";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "toMap";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    @NotNull
    private final Properties myProperties;
    @NotNull
    private final AppName myAppName;

    @NotNull
    public static Map<String, AppConfigProperty> getAllProperties() {
        Map map = (Map)ProcessContext.get().getOrCreateValue(ALL_PROPERTIES_KEY);
        if (map == null) {
            AppConfigImpl.$$$reportNull$$$0(0);
        }
        return map;
    }

    private AppConfigImpl(@NotNull Properties properties) {
        if (properties == null) {
            AppConfigImpl.$$$reportNull$$$0(1);
        }
        this.myProperties = properties;
        this.myAppName = new AppNameImpl(this.readAppDisplayName());
    }

    @NotNull
    private String readAppDisplayName() {
        String appDisplayName = this.getProperty("display-name");
        String string = appDisplayName == null ? "application" : appDisplayName.replace("\"", "_").replace("'", "_");
        if (string == null) {
            AppConfigImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public AppName getAppName() {
        AppName appName = this.myAppName;
        if (appName == null) {
            AppConfigImpl.$$$reportNull$$$0(3);
        }
        return appName;
    }

    @NotNull
    public String getAppDescription() {
        String appDescription = this.getProperty("description");
        String string = appDescription == null ? this.getAppName().getName() : appDescription;
        if (string == null) {
            AppConfigImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getWinServiceName() {
        String winServiceName = this.getProperty("win-service-name");
        String string = winServiceName == null ? NameUtil.fixWinServiceName((String)this.getAppName().getName()) : winServiceName;
        if (string == null) {
            AppConfigImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getMacDaemonLabel() {
        String macDaemonLabel = this.getProperty("mac-daemon-label");
        String string = macDaemonLabel == null ? NameUtil.fixMacDaemonLabel((String)this.getAppName().getName()) : macDaemonLabel;
        if (string == null) {
            AppConfigImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getMacDaemonUser() {
        String macDaemonUser = this.getProperty("mac-daemon-user");
        String string = macDaemonUser == null ? "root" : macDaemonUser;
        if (string == null) {
            AppConfigImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    public int getStartTimeoutSeconds() {
        return this.getIntProperty("start-timeout-seconds", 300);
    }

    public int getStopTimeoutSeconds() {
        return this.getIntProperty("stop-timeout-seconds", 300);
    }

    @Nullable
    public String getBaseDirPath() {
        return this.getProperty("base-dir");
    }

    @Nullable
    public String getAppLibDirPath() {
        return this.getProperty("lib-dir");
    }

    @Nullable
    public String getAppLogsDirPath() {
        return this.getProperty("logs-dir");
    }

    @Nullable
    public String getLauncherLogsDirPath() {
        return this.getProperty("launcher.logs-dir");
    }

    @Nullable
    public String getYourKitHomePath() {
        return this.getProperty("yourkit-home");
    }

    private int getIntProperty(@NotNull String propertyKey, int defaultValue) {
        if (propertyKey == null) {
            AppConfigImpl.$$$reportNull$$$0(8);
        }
        try {
            return Integer.parseInt(this.getProperty(propertyKey));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Nullable
    private String getProperty(@NotNull String propertyKey) {
        if (propertyKey == null) {
            AppConfigImpl.$$$reportNull$$$0(9);
        }
        return PropertiesUtil.getProperty((Properties)this.myProperties, (String)propertyKey);
    }

    @NotNull
    public static AppConfig parseConfig(@NotNull AppConfigFilesEx appFiles) throws InitException {
        if (appFiles == null) {
            AppConfigImpl.$$$reportNull$$$0(10);
        }
        Properties properties = new Properties();
        AppConfigImpl.loadFromDefaultAppConfig(properties, (AppFixedFilesEx)appFiles);
        AppConfigImpl.loadFromAppConfig(properties, appFiles);
        AppConfigImpl appConfigImpl = new AppConfigImpl(properties);
        if (appConfigImpl == null) {
            AppConfigImpl.$$$reportNull$$$0(11);
        }
        return appConfigImpl;
    }

    private static void loadFromDefaultAppConfig(@NotNull Properties properties, @NotNull AppFixedFilesEx appFixedFiles) throws InitException {
        Resource defaultAppConfigFile;
        if (properties == null) {
            AppConfigImpl.$$$reportNull$$$0(12);
        }
        if (appFixedFiles == null) {
            AppConfigImpl.$$$reportNull$$$0(13);
        }
        if (!(defaultAppConfigFile = appFixedFiles.resolveLauncherAppConfigFile(".default.launch.config")).exists()) {
            throw new InitException("Failed to find application default launch configuration file: " + defaultAppConfigFile.getURL().toExternalForm());
        }
        AppConfigImpl.loadFromUrl(properties, defaultAppConfigFile.getURL());
    }

    private static void loadFromAppConfig(@NotNull Properties properties, @NotNull AppConfigFilesEx appFiles) throws InitException {
        if (properties == null) {
            AppConfigImpl.$$$reportNull$$$0(14);
        }
        if (appFiles == null) {
            AppConfigImpl.$$$reportNull$$$0(15);
        }
        try {
            File appConfigFile = appFiles.getAppConfigFile(".launch.config");
            if (appConfigFile.isFile()) {
                AppConfigImpl.loadFromUrl(properties, appConfigFile.toURI().toURL());
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private static void loadFromUrl(@NotNull Properties properties, @NotNull URL url) throws InitException {
        if (properties == null) {
            AppConfigImpl.$$$reportNull$$$0(16);
        }
        if (url == null) {
            AppConfigImpl.$$$reportNull$$$0(17);
        }
        try {
            PropertiesUtil.loadFromUrl((Properties)properties, (URL)url);
        }
        catch (IOException e) {
            throw new InitException("Failed to read application launch configuration from the file \"" + url.toExternalForm() + "\": " + e, (Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/configs/AppConfigImpl";
                break;
            }
            case 1: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyKey";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appFiles";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appFixedFiles";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProperties";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/configs/AppConfigImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "readAppDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppDescription";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getWinServiceName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacDaemonLabel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacDaemonUser";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "parseConfig";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getIntProperty";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getProperty";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseConfig";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadFromDefaultAppConfig";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadFromAppConfig";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "loadFromUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

