/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.configs;

import com.jetbrains.launcher.AppFiles;
import com.jetbrains.launcher.SystemInfo;
import com.jetbrains.launcher.configs.AppConfig;
import com.jetbrains.launcher.util.ExceptionUtil;
import com.jetbrains.launcher.util.FileUtil;
import com.jetbrains.launcher.util.StringUtil;
import com.jetbrains.launcher.util.java.CachingJvmOptionVariableValueProvider;
import com.jetbrains.launcher.util.java.InvalidJvmOptionException;
import com.jetbrains.launcher.util.java.JvmOptionVariableValueProvider;
import com.jetbrains.launcher.util.java.StringValueProvider;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class JvmOptionVariablesProvider {
    @NotNull
    private final Logger LOG;
    @NotNull
    private final AppFiles myAppFiles;
    @NotNull
    private final AppConfig myAppConfig;

    public JvmOptionVariablesProvider(@NotNull AppFiles appFiles, @NotNull AppConfig appConfig) {
        if (appFiles == null) {
            JvmOptionVariablesProvider.$$$reportNull$$$0(0);
        }
        if (appConfig == null) {
            JvmOptionVariablesProvider.$$$reportNull$$$0(1);
        }
        this.LOG = Logger.getLogger(JvmOptionVariablesProvider.class);
        this.myAppFiles = appFiles;
        this.myAppConfig = appConfig;
    }

    @NotNull
    public Map<String, JvmOptionVariableValueProvider> get() {
        HashMap<String, JvmOptionVariableValueProvider> result = new HashMap<String, JvmOptionVariableValueProvider>();
        result.put("FILE_SEPARATOR", new StringValueProvider(File.separator));
        result.put("APP_LOGS_DIR", new StringValueProvider(FileUtil.getShortPath((File)this.myAppFiles.getAppHome(), (File)this.myAppFiles.getAppLogsFolder())));
        final FreePortProvider freePortProvider = new FreePortProvider();
        result.put("DEBUG_PORT", new JvmOptionVariableValueProvider(){

            @Override
            @NotNull
            public String get() throws InvalidJvmOptionException {
                String string;
                try {
                    int port = freePortProvider.get();
                    JvmOptionVariablesProvider.this.LOG.info((Object)("Debug port is " + port));
                    string = String.valueOf(port);
                }
                catch (IOException e) {
                    throw new InvalidJvmOptionException("Failed to find free socket port for debug: " + e.getMessage(), e);
                }
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/launcher/configs/JvmOptionVariablesProvider$1", "get"));
            }
        });
        result.put("YOURKIT_AGENT_PORT", new JvmOptionVariableValueProvider(){

            @Override
            @NotNull
            public String get() throws InvalidJvmOptionException {
                String string;
                try {
                    int port = freePortProvider.get();
                    JvmOptionVariablesProvider.this.LOG.info((Object)("YourKit agent port is " + port));
                    string = String.valueOf(port);
                }
                catch (IOException e) {
                    throw new InvalidJvmOptionException("Failed to find free socket port for YourKit agent: " + e.getMessage(), e);
                }
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/launcher/configs/JvmOptionVariablesProvider$2", "get"));
            }
        });
        result.put("YOURKIT_AGENT_LIBRARY_PATH", new CachingJvmOptionVariableValueProvider(){

            @Override
            @NotNull
            protected String doGet() throws InvalidJvmOptionException {
                String string = new File(JvmOptionVariablesProvider.this.getYourKitHome(), JvmOptionVariablesProvider.getYourKitAgentLibraryRelativePath()).getAbsolutePath();
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/launcher/configs/JvmOptionVariablesProvider$3", "doGet"));
            }
        });
        HashMap<String, JvmOptionVariableValueProvider> hashMap = result;
        if (hashMap == null) {
            JvmOptionVariablesProvider.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    @NotNull
    private String getYourKitHome() throws InvalidJvmOptionException {
        String yourKitHomePath = this.myAppConfig.getYourKitHomePath();
        if (StringUtil.isEmpty((String)yourKitHomePath)) {
            throw new InvalidJvmOptionException("Path to YourKit is not specified. To set it run the following command: " + this.myAppFiles.getAppScriptFile().getName() + " " + "configure" + " --" + "yourkit-home" + "=<YourKit Home>");
        }
        String string = yourKitHomePath;
        if (string == null) {
            JvmOptionVariablesProvider.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private static String getYourKitAgentLibraryRelativePath() throws InvalidJvmOptionException {
        String arch;
        String os;
        if (SystemInfo.isWindows) {
            String string = SystemInfo.isJvm64Bit ? "bin/win64/yjpagent.dll" : "bin/win32/yjpagent.dll";
            if (string == null) {
                JvmOptionVariablesProvider.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (SystemInfo.isMac) {
            if ("bin/mac/libyjpagent.jnilib" == null) {
                JvmOptionVariablesProvider.$$$reportNull$$$0(5);
            }
            return "bin/mac/libyjpagent.jnilib";
        }
        String string = SystemInfo.isLinux ? "linux" : (SystemInfo.isSolaris ? "solaris" : (SystemInfo.isFreeBSD ? "freebsd" : (os = SystemInfo.isAIX ? "aix" : null)));
        String string2 = SystemInfo.isX86 || SystemInfo.isAMD ? "x86" : (SystemInfo.isPPC ? "ppc" : (arch = SystemInfo.isSPARC ? "sparc" : null));
        if (os == null || arch == null) {
            throw new InvalidJvmOptionException("YourKit agent is not supported for your system (OS: " + SystemInfo.OS_NAME + ", arch: " + SystemInfo.OS_ARCH + ")");
        }
        String string3 = "bin/" + os + "-" + arch + "-" + (SystemInfo.isJvm64Bit ? "64" : "32") + "/libyjpagent.so";
        if (string3 == null) {
            JvmOptionVariablesProvider.$$$reportNull$$$0(6);
        }
        return string3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appFiles";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appConfig";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/configs/JvmOptionVariablesProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/configs/JvmOptionVariablesProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getYourKitHome";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getYourKitAgentLibraryRelativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class FreePortProvider {
        @NotNull
        private final Set<Integer> myPorts = new HashSet<Integer>();

        private FreePortProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int get() throws IOException {
            Object socket;
            int port;
            ArrayList<ServerSocket> sockets = new ArrayList<ServerSocket>();
            do {
                socket = new ServerSocket(0);
                sockets.add((ServerSocket)socket);
            } while (!this.myPorts.add(port = ((ServerSocket)socket).getLocalPort()));
            socket = sockets;
            synchronized (socket) {
                try {
                    sockets.wait(1L);
                }
                catch (InterruptedException e) {
                    ExceptionUtil.logStackTrace((Logger)JvmOptionVariablesProvider.this.LOG, (String)"Interrupted", (Throwable)e);
                }
            }
            for (ServerSocket socket2 : sockets) {
                try {
                    socket2.close();
                }
                catch (IOException ignore) {}
            }
            return port;
        }
    }
}

