/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.configs.properties;

import com.jetbrains.launcher.AppFilesEx;
import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.LauncherContext;
import com.jetbrains.launcher.configs.AppConfig;
import com.jetbrains.launcher.configs.properties.BaseAppConfigPathProperty;
import com.jetbrains.launcher.util.FileUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseDirProperty
extends BaseAppConfigPathProperty {
    @Override
    @NotNull
    public String getName() {
        if ("base-dir" == null) {
            BaseDirProperty.$$$reportNull$$$0(0);
        }
        return "base-dir";
    }

    @Override
    protected boolean isJavaOnlyProperty() {
        return false;
    }

    @Override
    @Nullable
    protected String getRawValue(@NotNull AppConfig appConfig) {
        if (appConfig == null) {
            BaseDirProperty.$$$reportNull$$$0(1);
        }
        return appConfig.getBaseDirPath();
    }

    @Override
    @NotNull
    protected String getDefaultRawValue(@NotNull AppConfig appConfig) {
        if (appConfig == null) {
            BaseDirProperty.$$$reportNull$$$0(2);
        }
        if ("." == null) {
            BaseDirProperty.$$$reportNull$$$0(3);
        }
        return ".";
    }

    @Override
    @NotNull
    public String toRawValue(@NotNull LauncherContext context, @NotNull String value) throws InitException {
        if (context == null) {
            BaseDirProperty.$$$reportNull$$$0(4);
        }
        if (value == null) {
            BaseDirProperty.$$$reportNull$$$0(5);
        }
        AppFilesEx appFiles = context.getAppFiles();
        File appHome = appFiles.getAppHome();
        File resolvedBaseDir = appFiles.resolvePath(value);
        if (!FileUtil.isFileInside((File)resolvedBaseDir, (File)appHome)) {
            throw new InitException("Base directory does not contain " + context.getAppConfig().getAppName().getName() + " home directory: " + resolvedBaseDir.getAbsolutePath());
        }
        String string = FileUtil.getRelativePath((File)appHome, (File)resolvedBaseDir);
        if (string == null) {
            BaseDirProperty.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/configs/properties/BaseDirProperty";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appConfig";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/configs/properties/BaseDirProperty";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultRawValue";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toRawValue";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRawValue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultRawValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toRawValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

