/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.ep;

import com.jetbrains.launcher.Arguments;
import com.jetbrains.launcher.LauncherArgumentsParser;
import com.jetbrains.launcher.ProcessContext;
import com.jetbrains.launcher.ep.Command;
import com.jetbrains.launcher.ep.CommandsProvider;
import com.jetbrains.launcher.ep.commands.Attach;
import com.jetbrains.launcher.ep.commands.Configure;
import com.jetbrains.launcher.ep.commands.Do;
import com.jetbrains.launcher.ep.commands.Dump;
import com.jetbrains.launcher.ep.commands.Get;
import com.jetbrains.launcher.ep.commands.GetAppLaunchCommand;
import com.jetbrains.launcher.ep.commands.GetLaunchInfo;
import com.jetbrains.launcher.ep.commands.Java;
import com.jetbrains.launcher.ep.commands.Kill;
import com.jetbrains.launcher.ep.commands.L1st;
import com.jetbrains.launcher.ep.commands.Launcher;
import com.jetbrains.launcher.ep.commands.Lock;
import com.jetbrains.launcher.ep.commands.Pid;
import com.jetbrains.launcher.ep.commands.Rerun;
import com.jetbrains.launcher.ep.commands.Restart;
import com.jetbrains.launcher.ep.commands.Run;
import com.jetbrains.launcher.ep.commands.Start;
import com.jetbrains.launcher.ep.commands.Status;
import com.jetbrains.launcher.ep.commands.Stop;
import com.jetbrains.launcher.ep.commands.Unlock;
import com.jetbrains.launcher.ep.commands.Usage;
import com.jetbrains.launcher.plugins.PluginManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Commands {
    @NotNull
    private static final ProcessContext.Key<List<Command>> COMMANDS_KEY = new ProcessContext.Key<List<Command>>(){

        @NotNull
        public List<Command> createDefaultValue() {
            ArrayList<Command> commands = new ArrayList<Command>(Commands.getCoreCommands());
            for (CommandsProvider commandsProvider : PluginManager.getInstance().loadExtensions(CommandsProvider.class)) {
                commands.addAll(commandsProvider.getCommands());
            }
            Collections.sort(commands, new Comparator<Command>(){

                @Override
                public int compare(@NotNull Command c1, @NotNull Command c2) {
                    if (c1 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (c2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return c1.getOrderId().compareToIgnoreCase(c2.getOrderId());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "c1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "c2";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/launcher/ep/Commands$1$1";
                    objectArray[2] = "compare";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            ArrayList<Command> arrayList = commands;
            if (arrayList == null) {
                1.$$$reportNull$$$0(0);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/launcher/ep/Commands$1", "createDefaultValue"));
        }
    };

    @NotNull
    private static List<Command> getCoreCommands() {
        List<Command> list = Arrays.asList(new Configure(), new Start(), new Run(), new Status(), new Stop(), new Restart(), new Rerun(), new Dump(), new Kill(), new Java(), new Usage(), new Pid(), new Attach(), new Get(), new Launcher(), new L1st(), new GetAppLaunchCommand(), new GetLaunchInfo(), new Lock(), new Unlock(), new Do());
        if (list == null) {
            Commands.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public static Command getCommand(@Nullable String commandName, @NotNull Arguments args) {
        if (args == null) {
            Commands.$$$reportNull$$$0(1);
        }
        Command command = Commands.getCommand(null, commandName, Commands.getAllCommands(), args);
        if (command == null) {
            Commands.$$$reportNull$$$0(2);
        }
        return command;
    }

    @NotNull
    public static <T extends Command> T getCommand(@Nullable Command baseCommand, @Nullable String commandName, @NotNull List<T> commands, @NotNull Arguments args) {
        T command;
        if (commands == null) {
            Commands.$$$reportNull$$$0(3);
        }
        if (args == null) {
            Commands.$$$reportNull$$$0(4);
        }
        T t = command = commandName == null ? null : (T)Commands.findCommand(commandName, commands, args);
        if (command != null) {
            T t2 = command;
            if (t2 == null) {
                Commands.$$$reportNull$$$0(5);
            }
            return t2;
        }
        Usage usage = new Usage(baseCommand, commandName, true);
        if (usage == null) {
            Commands.$$$reportNull$$$0(6);
        }
        return (T)usage;
    }

    @Nullable
    public static <T extends Command> T findCommand(@NotNull String commandName, @NotNull List<T> commands, @Nullable Arguments args) {
        if (commandName == null) {
            Commands.$$$reportNull$$$0(7);
        }
        if (commands == null) {
            Commands.$$$reportNull$$$0(8);
        }
        for (Command command : commands) {
            if (!command.getName().equals(commandName) || args != null && !command.isAvailable(args)) continue;
            return (T)command;
        }
        return null;
    }

    @NotNull
    public static List<Command> getAllCommands() {
        List list = (List)ProcessContext.get().getOrCreateValue(COMMANDS_KEY);
        if (list == null) {
            Commands.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public static LauncherArgumentsParser createLauncherArgumentsParser() {
        LauncherArgumentsParser launcherArgumentsParser = new LauncherArgumentsParser(){

            @NotNull
            public LauncherArgumentsParser.State getInitialState() {
                LauncherArgumentsParser.State state = new LauncherArgumentsParser.State(){

                    @Nullable
                    public LauncherArgumentsParser.State next(@NotNull String arg) {
                        if (arg == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return Commands.findCommand(arg, Commands.getAllCommands(), null);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/jetbrains/launcher/ep/Commands$2$1", "next"));
                    }
                };
                if (state == null) {
                    2.$$$reportNull$$$0(0);
                }
                return state;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/launcher/ep/Commands$2", "getInitialState"));
            }
        };
        if (launcherArgumentsParser == null) {
            Commands.$$$reportNull$$$0(10);
        }
        return launcherArgumentsParser;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/ep/Commands";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoreCommands";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/ep/Commands";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCommands";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createLauncherArgumentsParser";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCommand";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findCommand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

