/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.ep.commands;

import com.jetbrains.launcher.Arguments;
import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.LauncherContext;
import com.jetbrains.launcher.LauncherContextEx;
import com.jetbrains.launcher.LauncherExitCode;
import com.jetbrains.launcher.StartKind;
import com.jetbrains.launcher.ep.Command;
import com.jetbrains.launcher.ep.commands.BaseCommand;
import com.jetbrains.launcher.log.ConsoleLogger;
import com.jetbrains.launcher.log.LoggerMode;
import com.jetbrains.launcher.run.JavaAgent;
import com.jetbrains.launcher.util.CmdUtil;
import com.jetbrains.launcher.util.ExceptionUtil;
import com.jetbrains.launcher.util.java.JavaCommandLineBuilder;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class GetAppLaunchCommand
extends BaseCommand {
    @NotNull
    public static final String NAME = "get-app-launch-command";
    @NotNull
    public static final String START_ACTION = "start";
    @NotNull
    public static final String CONFIGURE_ACTION = "configure";
    @NotNull
    public static final String SEPARATOR = "--";
    @NotNull
    private final Logger LOG = Logger.getLogger(GetAppLaunchCommand.class);

    @NotNull
    public String getName() {
        if (NAME == null) {
            GetAppLaunchCommand.$$$reportNull$$$0(0);
        }
        return NAME;
    }

    @Override
    @NotNull
    public String getOrderId() {
        if ("f" == null) {
            GetAppLaunchCommand.$$$reportNull$$$0(1);
        }
        return "f";
    }

    @Override
    @NotNull
    public Command.CommandType getType(@NotNull Arguments args) {
        if (args == null) {
            GetAppLaunchCommand.$$$reportNull$$$0(2);
        }
        Command.CommandType commandType = Command.CommandType.DEV_COMMAND;
        if (commandType == null) {
            GetAppLaunchCommand.$$$reportNull$$$0(3);
        }
        return commandType;
    }

    @Override
    public boolean isAvailable(@NotNull Arguments args) {
        if (args == null) {
            GetAppLaunchCommand.$$$reportNull$$$0(4);
        }
        return args.isJavaApplication();
    }

    @Override
    @NotNull
    protected LoggerMode getLoggerMode(@NotNull Arguments args) {
        if (args == null) {
            GetAppLaunchCommand.$$$reportNull$$$0(5);
        }
        LoggerMode loggerMode = LoggerMode.CONSOLE_ERROR_ONLY;
        if (loggerMode == null) {
            GetAppLaunchCommand.$$$reportNull$$$0(6);
        }
        return loggerMode;
    }

    @Override
    @NotNull
    protected LauncherExitCode doRun(@NotNull LauncherContextEx context) throws InitException {
        List<String> cmdLine;
        if (context == null) {
            GetAppLaunchCommand.$$$reportNull$$$0(7);
        }
        List args = context.getArguments().getApplicationArguments();
        ArrayList<String> jvmOptions = new ArrayList<String>();
        ArrayList<String> programArgs = new ArrayList<String>();
        String action = null;
        boolean isJvmOptions = true;
        for (String arg : args) {
            if (isJvmOptions) {
                if (arg.startsWith("-")) {
                    jvmOptions.add(arg);
                    continue;
                }
                action = arg;
                isJvmOptions = false;
                continue;
            }
            programArgs.add(arg);
        }
        if (action == null) {
            throw new InitException("Action is not specified");
        }
        Arguments fakeArgs = context.getArguments().withCmdLine(new String[0]);
        JavaCommandLineBuilder builder = GetAppLaunchCommand.createCommandLineBuilder((JavaAgent)context.createAgentFacade(), action, fakeArgs);
        builder.addJvmOptions(jvmOptions);
        builder.addProgramArgs(programArgs);
        try {
            cmdLine = builder.build(context.getAppConfig().getAppName(), context.getAppFiles().getAppHome());
        }
        catch (FileNotFoundException e) {
            ExceptionUtil.logError((Logger)this.LOG, (String)"Failed to build application command line", (Throwable)e);
            LauncherExitCode launcherExitCode = LauncherExitCode.ERROR;
            if (launcherExitCode == null) {
                GetAppLaunchCommand.$$$reportNull$$$0(8);
            }
            return launcherExitCode;
        }
        ConsoleLogger.system((String)("JL_JAVA_PROPERTIES=" + CmdUtil.buildSystemPropertiesString(builder.getEnvSystemProperties())));
        ConsoleLogger.system((String)SEPARATOR);
        for (String arg : cmdLine) {
            ConsoleLogger.system((String)arg);
        }
        LauncherExitCode launcherExitCode = LauncherExitCode.OK;
        if (launcherExitCode == null) {
            GetAppLaunchCommand.$$$reportNull$$$0(9);
        }
        return launcherExitCode;
    }

    @NotNull
    private static JavaCommandLineBuilder createCommandLineBuilder(@NotNull JavaAgent javaAgent, @NotNull String action, @NotNull Arguments args) throws InitException {
        block9: {
            block8: {
                JavaCommandLineBuilder javaCommandLineBuilder;
                if (javaAgent == null) {
                    GetAppLaunchCommand.$$$reportNull$$$0(10);
                }
                if (action == null) {
                    GetAppLaunchCommand.$$$reportNull$$$0(11);
                }
                if (args == null) {
                    GetAppLaunchCommand.$$$reportNull$$$0(12);
                }
                try {
                    if (!action.equals(START_ACTION)) break block8;
                    javaCommandLineBuilder = javaAgent.createStartCommandLineBuilder(args, StartKind.FIRST_START);
                }
                catch (Exception e) {
                    throw new InitException("Failed to build the application launch command: " + e.getMessage(), (Throwable)e);
                }
                if (javaCommandLineBuilder == null) {
                    GetAppLaunchCommand.$$$reportNull$$$0(13);
                }
                return javaCommandLineBuilder;
            }
            if (!action.equals(CONFIGURE_ACTION)) break block9;
            JavaCommandLineBuilder javaCommandLineBuilder = javaAgent.createConfigureCommandLineBuilder(args);
            if (javaCommandLineBuilder == null) {
                GetAppLaunchCommand.$$$reportNull$$$0(14);
            }
            return javaCommandLineBuilder;
        }
        throw new InitException("Invalid action: " + action);
    }

    public void printUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            GetAppLaunchCommand.$$$reportNull$$$0(15);
        }
        if (context == null) {
            GetAppLaunchCommand.$$$reportNull$$$0(16);
        }
        printer.print(this.getFullName() + " <additional JVM options> (" + START_ACTION + "|" + CONFIGURE_ACTION + ") <additional program arguments>", "builds the command line to launch the " + context.getAppConfig().getAppName().getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/ep/commands/GetAppLaunchCommand";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaAgent";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderId";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/ep/commands/GetAppLaunchCommand";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoggerMode";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "doRun";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLineBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLoggerMode";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLineBuilder";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "printUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

