/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.ep.commands;

import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.LauncherContext;
import com.jetbrains.launcher.LauncherContextEx;
import com.jetbrains.launcher.LauncherExitCode;
import com.jetbrains.launcher.ep.Command;
import com.jetbrains.launcher.ep.commands.BaseJavaSubCommand;
import com.jetbrains.launcher.util.ExceptionUtil;
import com.jetbrains.launcher.util.LauncherUtil;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class JavaReset
extends BaseJavaSubCommand {
    @NotNull
    private static final String NAME = "reset";
    @NotNull
    private final Logger LOG = Logger.getLogger(JavaReset.class);

    @NotNull
    public String getName() {
        if (NAME == null) {
            JavaReset.$$$reportNull$$$0(0);
        }
        return NAME;
    }

    @Override
    @NotNull
    protected LauncherExitCode doRun(@NotNull LauncherContextEx context) throws InitException {
        LauncherExitCode launcherExitCode;
        File javaHintFile;
        if (context == null) {
            JavaReset.$$$reportNull$$$0(1);
        }
        if (!(javaHintFile = context.getAppFiles().getJavaHintFile()).exists()) {
            LauncherExitCode launcherExitCode2 = LauncherExitCode.ILLEGAL_STATE;
            if (launcherExitCode2 == null) {
                JavaReset.$$$reportNull$$$0(2);
            }
            return launcherExitCode2;
        }
        try {
            LauncherUtil.copy(javaHintFile, new File(javaHintFile.getAbsolutePath() + ".bak"), null);
            LauncherUtil.delete(javaHintFile, null);
            launcherExitCode = LauncherExitCode.OK;
        }
        catch (IOException e) {
            ExceptionUtil.logError((Logger)this.LOG, (String)"Failed to reset Java path", (Throwable)e);
            LauncherExitCode launcherExitCode3 = LauncherExitCode.ERROR;
            if (launcherExitCode3 == null) {
                JavaReset.$$$reportNull$$$0(4);
            }
            return launcherExitCode3;
        }
        if (launcherExitCode == null) {
            JavaReset.$$$reportNull$$$0(3);
        }
        return launcherExitCode;
    }

    public void printUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            JavaReset.$$$reportNull$$$0(5);
        }
        if (context == null) {
            JavaReset.$$$reportNull$$$0(6);
        }
        printer.print(this.getFullName(), "resets the explicitly set Java path for " + context.getAppConfig().getAppName().getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/ep/commands/JavaReset";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/ep/commands/JavaReset";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doRun";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "printUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

