/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.ep.commands;

import com.jetbrains.launcher.AppFiles;
import com.jetbrains.launcher.Arguments;
import com.jetbrains.launcher.LauncherContext;
import com.jetbrains.launcher.LauncherContextEx;
import com.jetbrains.launcher.ep.Command;
import com.jetbrains.launcher.ep.commands.BaseLauncherDumpSubCommand;
import com.jetbrains.launcher.log.ConsoleLogger;
import com.jetbrains.launcher.log.LoggerMode;
import com.jetbrains.launcher.util.JavaUtil;
import com.jetbrains.launcher.util.RuntimeUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LauncherDumpHeap
extends BaseLauncherDumpSubCommand {
    @NotNull
    public static final String NAME = "heap";
    private File myFile;

    @NotNull
    public String getName() {
        if (NAME == null) {
            LauncherDumpHeap.$$$reportNull$$$0(0);
        }
        return NAME;
    }

    @Override
    @NotNull
    protected LoggerMode getLoggerMode(@NotNull Arguments args) {
        if (args == null) {
            LauncherDumpHeap.$$$reportNull$$$0(1);
        }
        LoggerMode loggerMode = LauncherDumpHeap.isShort(args) ? LoggerMode.CONSOLE_ERROR_ONLY : LoggerMode.CONSOLE_ONLY;
        if (loggerMode == null) {
            LauncherDumpHeap.$$$reportNull$$$0(2);
        }
        return loggerMode;
    }

    @Override
    @Nullable
    protected Integer getTimeoutSeconds() {
        return null;
    }

    @Override
    @NotNull
    protected String[] createCmdLine(@NotNull LauncherContextEx context, int launcherPID) throws IOException {
        File jmap;
        if (context == null) {
            LauncherDumpHeap.$$$reportNull$$$0(3);
        }
        if ((jmap = JavaUtil.findJMapTool()) == null) {
            throw new IOException("Failed to find \"jmap\"");
        }
        this.myFile = RuntimeUtil.getLauncherHeapDumpFile((AppFiles)context.getAppFiles());
        String[] stringArray = JavaUtil.getJMapToolCommandLine((File)jmap, (File)this.myFile, (int)launcherPID);
        if (stringArray == null) {
            LauncherDumpHeap.$$$reportNull$$$0(4);
        }
        return stringArray;
    }

    @Override
    protected void processOutput(@NotNull LauncherContextEx context, @NotNull List<String> stdout) throws IOException {
        if (context == null) {
            LauncherDumpHeap.$$$reportNull$$$0(5);
        }
        if (stdout == null) {
            LauncherDumpHeap.$$$reportNull$$$0(6);
        }
        if (LauncherDumpHeap.isShort(context.getArguments())) {
            ConsoleLogger.system((String)this.myFile.getAbsolutePath());
        } else {
            ConsoleLogger.info((String)("Launcher heap was dumped to the file: " + this.myFile.getAbsolutePath()));
        }
    }

    public void printUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            LauncherDumpHeap.$$$reportNull$$$0(7);
        }
        if (context == null) {
            LauncherDumpHeap.$$$reportNull$$$0(8);
        }
        printer.print(this.getFullName(), "dumps launcher heap, " + this.getComplexCommandUsageText());
    }

    @Override
    public void printStandaloneUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            LauncherDumpHeap.$$$reportNull$$$0(9);
        }
        if (context == null) {
            LauncherDumpHeap.$$$reportNull$$$0(10);
        }
        printer.print(this.getFullName(), "dumps launcher heap to the file under the launcher logs directory");
        printer.print(this.getFullName() + " " + "short", "same as \"" + this.getFullName() + "\", but prints to the console nothing but the absolute path of the created file");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/ep/commands/LauncherDumpHeap";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stdout";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/ep/commands/LauncherDumpHeap";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoggerMode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCmdLine";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLoggerMode";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createCmdLine";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processOutput";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "printUsage";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "printStandaloneUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

