/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.ep.commands;

import com.jetbrains.launcher.AppFiles;
import com.jetbrains.launcher.Arguments;
import com.jetbrains.launcher.Destroyer;
import com.jetbrains.launcher.InitAction;
import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.LauncherContext;
import com.jetbrains.launcher.LauncherContextEx;
import com.jetbrains.launcher.LauncherExitCode;
import com.jetbrains.launcher.ep.Command;
import com.jetbrains.launcher.ep.commands.BaseCommand;
import com.jetbrains.launcher.lock.AppLockFactory;
import com.jetbrains.launcher.lock.AppState;
import com.jetbrains.launcher.lock.CannotAcquireAppLockException;
import com.jetbrains.launcher.lock.LauncherAwareAppLock;
import com.jetbrains.launcher.log.LoggerMode;
import com.jetbrains.launcher.util.AsyncWaitFor;
import com.jetbrains.launcher.util.CollectionUtil;
import com.jetbrains.launcher.util.Event;
import com.jetbrains.launcher.util.RuntimeUtil;
import java.io.File;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class Lock
extends BaseCommand {
    @NotNull
    public static final String NAME = "lock";
    @NotNull
    public static final String STOP_ACTION = "stop";
    @NotNull
    public static final String START_ACTION = "start";
    @NotNull
    public static final String CONFIGURE_ACTION = "configure";
    @NotNull
    private final Logger LOG = Logger.getLogger(Lock.class);
    @NotNull
    private final Event.SimpleEvent myDestroyingStepAddedEvent = new Event.SimpleEvent();
    @NotNull
    private final Event.SimpleEvent myDestroyingStartedEvent = new Event.SimpleEvent();
    @NotNull
    private final Event.SimpleEvent myLockReleasedEvent = new Event.SimpleEvent();

    @NotNull
    public String getName() {
        if (NAME == null) {
            Lock.$$$reportNull$$$0(0);
        }
        return NAME;
    }

    @Override
    @NotNull
    public String getOrderId() {
        if ("z" == null) {
            Lock.$$$reportNull$$$0(1);
        }
        return "z";
    }

    @Override
    @NotNull
    public Command.CommandType getType(@NotNull Arguments args) {
        if (args == null) {
            Lock.$$$reportNull$$$0(2);
        }
        Command.CommandType commandType = Command.CommandType.SYSTEM_COMMAND;
        if (commandType == null) {
            Lock.$$$reportNull$$$0(3);
        }
        return commandType;
    }

    @Override
    @NotNull
    protected LoggerMode getLoggerMode(@NotNull Arguments args) {
        if (args == null) {
            Lock.$$$reportNull$$$0(4);
        }
        LoggerMode loggerMode = LoggerMode.LAUNCHER;
        if (loggerMode == null) {
            Lock.$$$reportNull$$$0(5);
        }
        return loggerMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected LauncherExitCode doRun(final @NotNull LauncherContextEx context) throws InitException {
        LauncherExitCode launcherExitCode;
        String action;
        if (context == null) {
            Lock.$$$reportNull$$$0(6);
        }
        if ((action = (String)CollectionUtil.getOrNull((List)context.getArguments().getApplicationArguments(), (int)0)) == null) {
            throw new InitException("Action is not specified");
        }
        AppState state = Lock.getAppState(action);
        final boolean isStop = action.equals(STOP_ACTION);
        LauncherAwareAppLock appLock = AppLockFactory.createLock((AppFiles)context.getAppFiles());
        InitAction initAction = new InitAction(){

            @Override
            @NotNull
            public LauncherExitCode run() {
                if (isStop) {
                    Lock.this.startAgentShutdownWatcher(context);
                }
                LauncherExitCode launcherExitCode = Lock.this.doLock();
                if (launcherExitCode == null) {
                    1.$$$reportNull$$$0(0);
                }
                return launcherExitCode;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/launcher/ep/commands/Lock$1", "run"));
            }
        };
        try {
            LauncherExitCode launcherExitCode2 = isStop ? AppLockFactory.withLock(appLock, state, initAction, 20000L) : AppLockFactory.withLock(appLock, state, initAction);
            launcherExitCode = launcherExitCode2;
        }
        catch (CannotAcquireAppLockException e) {
            this.LOG.error((Object)context.getIllegalAppStateErrorText(state));
            LauncherExitCode launcherExitCode3 = LauncherExitCode.ILLEGAL_STATE;
            LauncherExitCode launcherExitCode4 = launcherExitCode3;
            if (launcherExitCode4 == null) {
                Lock.$$$reportNull$$$0(8);
            }
            return launcherExitCode4;
        }
        finally {
            this.myLockReleasedEvent.fire();
        }
        if (launcherExitCode == null) {
            Lock.$$$reportNull$$$0(7);
        }
        return launcherExitCode;
    }

    @NotNull
    private LauncherExitCode doLock() {
        Destroyer.get().addStep(new Runnable(){

            @Override
            public void run() {
                Lock.this.myDestroyingStartedEvent.fire();
                Lock.this.myLockReleasedEvent.waitFor();
            }
        });
        this.myDestroyingStepAddedEvent.fire();
        this.myDestroyingStartedEvent.waitFor();
        LauncherExitCode launcherExitCode = LauncherExitCode.OK;
        if (launcherExitCode == null) {
            Lock.$$$reportNull$$$0(9);
        }
        return launcherExitCode;
    }

    private void startAgentShutdownWatcher(@NotNull LauncherContextEx context) {
        if (context == null) {
            Lock.$$$reportNull$$$0(10);
        }
        final File exitFlag = RuntimeUtil.getAppExitFlagFile((AppFiles)context.getAppFiles());
        new AsyncWaitFor("Agent Shutdown Watcher"){

            protected boolean condition() {
                return !exitFlag.exists();
            }

            protected void performAction() {
                Lock.this.myDestroyingStepAddedEvent.waitFor();
                Destroyer.get().destroyAll();
            }
        }.start();
    }

    @NotNull
    private static AppState getAppState(@NotNull String action) throws InitException {
        if (action == null) {
            Lock.$$$reportNull$$$0(11);
        }
        if (action.equals(START_ACTION) || action.equals(STOP_ACTION)) {
            AppState appState = AppState.RUN;
            if (appState == null) {
                Lock.$$$reportNull$$$0(12);
            }
            return appState;
        }
        if (action.equals(CONFIGURE_ACTION)) {
            AppState appState = AppState.CONFIGURE;
            if (appState == null) {
                Lock.$$$reportNull$$$0(13);
            }
            return appState;
        }
        throw new InitException("Invalid action: " + action);
    }

    public void printUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            Lock.$$$reportNull$$$0(14);
        }
        if (context == null) {
            Lock.$$$reportNull$$$0(15);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/ep/commands/Lock";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 6: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderId";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/ep/commands/Lock";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoggerMode";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doRun";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "doLock";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLoggerMode";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "startAgentShutdownWatcher";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAppState";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "printUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

