/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.ep.commands;

import com.jetbrains.launcher.AppName;
import com.jetbrains.launcher.Arguments;
import com.jetbrains.launcher.InitAction;
import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.LauncherContext;
import com.jetbrains.launcher.LauncherContextEx;
import com.jetbrains.launcher.LauncherExitCode;
import com.jetbrains.launcher.ep.Command;
import com.jetbrains.launcher.ep.commands.BaseSoftModeSupportingCommand;
import com.jetbrains.launcher.ep.commands.Kill;
import com.jetbrains.launcher.ep.commands.Start;
import com.jetbrains.launcher.lock.AppState;
import com.jetbrains.launcher.log.LoggerMode;
import com.jetbrains.launcher.run.AgentDiagnosticFacade;
import com.jetbrains.launcher.run.AgentFacade;
import com.jetbrains.launcher.run.AgentStartFacade;
import com.jetbrains.launcher.util.ExceptionUtil;
import com.jetbrains.launcher.util.process.ConsoleProcessOutputWriter;
import com.jetbrains.launcher.util.process.ProcessHandler;
import com.jetbrains.launcher.util.process.ProcessOutputListener;
import java.io.IOException;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Stop
extends BaseSoftModeSupportingCommand {
    @NotNull
    public static final String NAME = "stop";
    @NotNull
    private final Logger LOG = Logger.getLogger(Stop.class);

    @NotNull
    public String getName() {
        if (NAME == null) {
            Stop.$$$reportNull$$$0(0);
        }
        return NAME;
    }

    @Override
    @NotNull
    public String getOrderId() {
        if ("f" == null) {
            Stop.$$$reportNull$$$0(1);
        }
        return "f";
    }

    @Override
    protected void collectPossibleArgs(@NotNull Set<String> possibleArgs) {
        if (possibleArgs == null) {
            Stop.$$$reportNull$$$0(2);
        }
        super.collectPossibleArgs(possibleArgs);
        possibleArgs.add("no-launcher");
    }

    @Override
    @NotNull
    protected LoggerMode getLoggerMode(@NotNull Arguments args) {
        if (args == null) {
            Stop.$$$reportNull$$$0(3);
        }
        LoggerMode loggerMode = LoggerMode.LAUNCHER;
        if (loggerMode == null) {
            Stop.$$$reportNull$$$0(4);
        }
        return loggerMode;
    }

    @Override
    @NotNull
    protected LauncherExitCode doRun(final @NotNull LauncherContextEx context) throws InitException {
        AppState appState;
        if (context == null) {
            Stop.$$$reportNull$$$0(5);
        }
        final Arguments args = context.getArguments();
        final AppName appName = context.getAppConfig().getAppName();
        if (!(Kill.isNoLauncher(args) || (appState = context.getAppState()) != null && appState.isRunState())) {
            this.LOG.error((Object)(appName.getCapitalizedName() + " is not running"));
            LauncherExitCode launcherExitCode = LauncherExitCode.ILLEGAL_STATE;
            if (launcherExitCode == null) {
                Stop.$$$reportNull$$$0(6);
            }
            return launcherExitCode;
        }
        final AgentStartFacade agentFacade = context.createAgentFacade();
        LauncherExitCode launcherExitCode = Stop.attachAndRun(agentFacade, appName, this.LOG, new InitAction(){

            @Override
            @NotNull
            public LauncherExitCode run() throws InitException {
                if (agentFacade.stop(BaseSoftModeSupportingCommand.isSoft(args)) && (Kill.isNoLauncher(args) || agentFacade.waitForExit(10))) {
                    Kill.afterRun(context);
                    Stop.this.LOG.info((Object)(appName.getCapitalizedName() + " has shut down"));
                    LauncherExitCode launcherExitCode = LauncherExitCode.OK;
                    if (launcherExitCode == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return launcherExitCode;
                }
                Stop.this.LOG.warn((Object)(appName.getCapitalizedName() + " has failed to shut down"));
                Start.dumpThreadsIfPossible(agentFacade, Stop.this.LOG);
                Stop.this.LOG.warn((Object)("Trying to kill " + appName.getName() + "..."));
                LauncherExitCode launcherExitCode = new Kill().reinitLogsAndDoRun(context);
                if (launcherExitCode == null) {
                    1.$$$reportNull$$$0(1);
                }
                return launcherExitCode;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/launcher/ep/commands/Stop$1", "run"));
            }
        });
        if (launcherExitCode == null) {
            Stop.$$$reportNull$$$0(7);
        }
        return launcherExitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected static LauncherExitCode attachAndRun(@NotNull AgentFacade agentFacade, @NotNull AppName appName, @NotNull Logger log, @NotNull InitAction action) throws InitException {
        ProcessHandler processHandler;
        if (agentFacade == null) {
            Stop.$$$reportNull$$$0(8);
        }
        if (appName == null) {
            Stop.$$$reportNull$$$0(9);
        }
        if (log == null) {
            Stop.$$$reportNull$$$0(10);
        }
        if (action == null) {
            Stop.$$$reportNull$$$0(11);
        }
        if ((processHandler = Stop.tryAttachToApp(agentFacade, appName, log)) != null) {
            processHandler.start();
        }
        LauncherExitCode launcherExitCode = action.run();
        LauncherExitCode launcherExitCode2 = launcherExitCode;
        if (launcherExitCode2 == null) {
            Stop.$$$reportNull$$$0(12);
        }
        return launcherExitCode2;
        finally {
            if (processHandler != null) {
                processHandler.destroy();
                processHandler.finish();
            }
        }
    }

    @Nullable
    private static ProcessHandler tryAttachToApp(@NotNull AgentFacade agentFacade, @NotNull AppName appName, @NotNull Logger log) {
        Process process;
        AgentDiagnosticFacade diagnosticFacade;
        if (agentFacade == null) {
            Stop.$$$reportNull$$$0(13);
        }
        if (appName == null) {
            Stop.$$$reportNull$$$0(14);
        }
        if (log == null) {
            Stop.$$$reportNull$$$0(15);
        }
        if ((diagnosticFacade = agentFacade.getDiagnosticFacade()) == null) {
            return null;
        }
        try {
            process = diagnosticFacade.attach();
        }
        catch (IOException e) {
            ExceptionUtil.logError((Logger)log, (String)("Failed to attach to " + appName.getName()), (Throwable)e);
            return null;
        }
        return ProcessHandler.builder((Process)process).withListener((ProcessOutputListener)new ConsoleProcessOutputWriter()).build();
    }

    public void printUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            Stop.$$$reportNull$$$0(16);
        }
        if (context == null) {
            Stop.$$$reportNull$$$0(17);
        }
        printer.print(NAME, "shuts " + context.getAppConfig().getAppName().getName() + " down, " + this.getComplexCommandUsageText());
    }

    @Override
    public void printStandaloneUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            Stop.$$$reportNull$$$0(18);
        }
        if (context == null) {
            Stop.$$$reportNull$$$0(19);
        }
        String name = context.getAppConfig().getAppName().getName();
        printer.print(NAME, "shuts " + name + " down");
        printer.print("stop soft", "shuts " + name + " down softly (timeout is not applied in this case)");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/ep/commands/Stop";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleArgs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 5: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentFacade";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appName";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderId";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/ep/commands/Stop";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoggerMode";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doRun";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "attachAndRun";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectPossibleArgs";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLoggerMode";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "attachAndRun";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "tryAttachToApp";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "printUsage";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "printStandaloneUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

