/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.lock;

import com.jetbrains.launcher.AppName;
import com.jetbrains.launcher.Static;
import com.jetbrains.launcher.Status;
import com.jetbrains.launcher.StatusDescriptor;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum AppState {
    RUN(new StatusDescriptor(Status.RUNNING, null)),
    CONFIGURE(new StatusDescriptor(Status.CONFIGURING, null)),
    NO_STATE(new StatusDescriptor(Status.ERROR, null));

    @Static
    @NotNull
    private final StatusDescriptor myStatus;

    private AppState(StatusDescriptor status) {
        if (status == null) {
            AppState.$$$reportNull$$$0(0);
        }
        this.myStatus = status;
    }

    public byte getCode() {
        return (byte)(this.ordinal() + 1);
    }

    public boolean isRunState() {
        return this == RUN;
    }

    @NotNull
    public StatusDescriptor getStatus() {
        StatusDescriptor statusDescriptor = this.myStatus;
        if (statusDescriptor == null) {
            AppState.$$$reportNull$$$0(1);
        }
        return statusDescriptor;
    }

    @NotNull
    public String getIllegalAppStateErrorText(@NotNull AppState requestedState, @NotNull AppName appName) {
        if (requestedState == null) {
            AppState.$$$reportNull$$$0(2);
        }
        if (appName == null) {
            AppState.$$$reportNull$$$0(3);
        }
        if (requestedState == this) {
            String string = appName.getCapitalizedName() + " is already " + this.myStatus.getStatus().getText();
            if (string == null) {
                AppState.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = "Cannot " + requestedState.name().toLowerCase() + " " + appName.getCapitalizedName() + " while it is " + this.myStatus.getStatus().getText();
        if (string == null) {
            AppState.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public static AppState findByCode(byte code) throws IOException {
        for (AppState appState : AppState.values()) {
            if (appState.getCode() != code) continue;
            return appState;
        }
        throw new IOException("Unknown state code: " + code);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/lock/AppState";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestedState";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/lock/AppState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIllegalAppStateErrorText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIllegalAppStateErrorText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

