/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.lock;

import com.jetbrains.launcher.Destroyer;
import com.jetbrains.launcher.DestroyerStep;
import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.SystemInfo;
import com.jetbrains.launcher.ThrowableRunnable;
import com.jetbrains.launcher.lock.AppState;
import com.jetbrains.launcher.lock.CannotAcquireAppLockException;
import com.jetbrains.launcher.lock.UpdatableAppLock;
import com.jetbrains.launcher.util.ExceptionUtil;
import com.jetbrains.launcher.util.FileUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileAppLock
implements UpdatableAppLock<File> {
    private static final int STATE_OFFSET = 0;
    private static final int STATE_SIZE = 1;
    private static final int DATA_SIZE = 1;
    @NotNull
    private final Logger LOG;
    @NotNull
    private File myFile;
    @Nullable
    private FileLockData myData;
    @Nullable
    private DestroyerStep myDestroyerStep;

    FileAppLock(@NotNull File file) {
        if (file == null) {
            FileAppLock.$$$reportNull$$$0(0);
        }
        this.LOG = Logger.getLogger(FileAppLock.class);
        this.myFile = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void lock(@NotNull AppState state) throws InitException, CannotAcquireAppLockException {
        FileLockData data;
        if (state == null) {
            FileAppLock.$$$reportNull$$$0(1);
        }
        DestroyerStep destroyerStep = Destroyer.get().addStep(new Runnable(){

            @Override
            public void run() {
                FileAppLock.this.unlock();
            }
        });
        boolean locked = false;
        try {
            data = FileAppLock.tryLock(state, this.myFile, this.LOG);
            locked = true;
        }
        finally {
            if (!locked) {
                destroyerStep.remove();
            }
        }
        this.myData = data;
        this.myDestroyerStep = destroyerStep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void unlock() {
        try {
            FileAppLock.finalizeAll(this.myData, this.myFile, this.LOG);
        }
        finally {
            this.myData = null;
            if (this.myDestroyerStep != null) {
                this.myDestroyerStep.remove();
                this.myDestroyerStep = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isLocked() throws InitException {
        FileLockData data = null;
        try {
            data = FileAppLock.tryLock(null, this.myFile, this.LOG);
            boolean bl = false;
            return bl;
        }
        catch (CannotAcquireAppLockException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            FileAppLock.finalizeAll(data, this.myFile, this.LOG);
        }
    }

    @Override
    @Nullable
    public synchronized AppState getState() throws InitException {
        return this.readLockData(0, 1, new LockDataReader<AppState>(){

            @Override
            @Nullable
            public AppState read(@NotNull ByteBuffer buf) throws IOException {
                if (buf == null) {
                    2.$$$reportNull$$$0(0);
                }
                return AppState.findByCode(buf.get(0));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "com/jetbrains/launcher/lock/FileAppLock$2", "read"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Nullable
    private synchronized <T> T readLockData(int offset, int size, @NotNull LockDataReader<T> reader) throws InitException {
        T t;
        if (reader == null) {
            FileAppLock.$$$reportNull$$$0(2);
        }
        if (!this.isLocked()) {
            return null;
        }
        RandomAccessFile raFile = null;
        try {
            raFile = new RandomAccessFile(this.myFile, "r");
            ByteBuffer buf = ByteBuffer.allocateDirect(size);
            t = raFile.getChannel().read(buf, offset) < size ? null : (T)reader.read(buf);
        }
        catch (FileNotFoundException e) {
            T t2 = null;
            FileUtil.close((Closeable)raFile);
            return t2;
        }
        catch (IOException e2) {
            ExceptionUtil.logWarning((Logger)this.LOG, (String)"Failed to read lock data", (Throwable)e2);
            T t3 = null;
            {
                catch (Throwable throwable) {
                    FileUtil.close(raFile);
                    throw throwable;
                }
            }
            FileUtil.close((Closeable)raFile);
            return t3;
        }
        FileUtil.close((Closeable)raFile);
        return t;
    }

    @Override
    public synchronized void updateLock(@NotNull File newFile, @NotNull ThrowableRunnable<InitException> innerAction) throws InitException {
        FileLockData newData;
        if (newFile == null) {
            FileAppLock.$$$reportNull$$$0(3);
        }
        if (innerAction == null) {
            FileAppLock.$$$reportNull$$$0(4);
        }
        if (newFile.equals(this.myFile)) {
            return;
        }
        if (this.myData == null) {
            innerAction.run();
            this.myFile = newFile;
            return;
        }
        try {
            newData = FileAppLock.tryLock(this.myData.getState(), newFile, this.LOG);
        }
        catch (CannotAcquireAppLockException e) {
            throw new InitException("Failed to change file lock: " + newFile.getAbsolutePath(), (Throwable)e);
        }
        try {
            innerAction.run();
        }
        catch (InitException e) {
            FileAppLock.finalizeAll(newData, newFile, this.LOG);
            throw e;
        }
        FileAppLock.finalizeAll(this.myData, this.myFile, this.LOG);
        this.myData = newData;
        this.myFile = newFile;
    }

    @NotNull
    private static FileLockData tryLock(@Nullable AppState state, @NotNull File file, @NotNull Logger log) throws InitException, CannotAcquireAppLockException {
        FileLock fileLock;
        RandomAccessFile raFile;
        if (file == null) {
            FileAppLock.$$$reportNull$$$0(5);
        }
        if (log == null) {
            FileAppLock.$$$reportNull$$$0(6);
        }
        try {
            File parentDir = file.getParentFile();
            if (parentDir != null) {
                FileUtil.mkdirs((File)parentDir);
            }
            raFile = new RandomAccessFile(file, "rw");
        }
        catch (IOException e) {
            throw new InitException("Failed to create random access file: " + e, (Throwable)e);
        }
        FileChannel channel = raFile.getChannel();
        boolean error = true;
        try {
            fileLock = channel.tryLock(1L, 0x7FFFFFFFFFFFFFFEL, false);
            error = false;
        }
        catch (OverlappingFileLockException e) {
            throw new CannotAcquireAppLockException("File lock is already (incorrectly) acquired by this JVM", e);
        }
        catch (IOException e) {
            throw new InitException("Failed to acquire file lock: " + e, (Throwable)e);
        }
        finally {
            if (error) {
                FileAppLock.finalizeFile(raFile, file);
            }
        }
        if (fileLock == null) {
            FileAppLock.finalizeFile(raFile, file);
            throw new CannotAcquireAppLockException("File lock is already acquired by another process");
        }
        FileLockData data = new FileLockData(raFile, fileLock, state);
        if (state != null) {
            try {
                channel.write(ByteBuffer.allocateDirect(1).put(0, state.getCode()), 0L);
            }
            catch (IOException e) {
                FileAppLock.finalizeAll(data, file, log);
                throw new InitException("Failed to write lock data: " + e, (Throwable)e);
            }
        }
        FileLockData fileLockData = data;
        if (fileLockData == null) {
            FileAppLock.$$$reportNull$$$0(7);
        }
        return fileLockData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void finalizeAll(@Nullable FileLockData data, @NotNull File file, @NotNull Logger log) {
        if (file == null) {
            FileAppLock.$$$reportNull$$$0(8);
        }
        if (log == null) {
            FileAppLock.$$$reportNull$$$0(9);
        }
        if (data == null) {
            return;
        }
        try {
            FileAppLock.finalizeFileLock(data.getFileLock(), file, log);
        }
        finally {
            FileAppLock.finalizeFile(data.getRAFile(), file);
        }
    }

    private static void finalizeFileLock(@Nullable FileLock fileLock, @NotNull File file, @NotNull Logger log) {
        if (file == null) {
            FileAppLock.$$$reportNull$$$0(10);
        }
        if (log == null) {
            FileAppLock.$$$reportNull$$$0(11);
        }
        if (fileLock == null) {
            return;
        }
        if (!SystemInfo.isWindows) {
            FileAppLock.deleteFile(file);
        }
        try {
            fileLock.release();
        }
        catch (IOException e) {
            ExceptionUtil.logError((Logger)log, (String)"Failed to release file lock", (Throwable)e);
        }
    }

    private static void finalizeFile(@Nullable RandomAccessFile raFile, @NotNull File file) {
        if (file == null) {
            FileAppLock.$$$reportNull$$$0(12);
        }
        FileUtil.close((Closeable)raFile);
        if (SystemInfo.isWindows) {
            FileAppLock.deleteFile(file);
        }
    }

    private static void deleteFile(@NotNull File file) {
        if (file == null) {
            FileAppLock.$$$reportNull$$$0(13);
        }
        file.delete();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerAction";
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/lock/FileAppLock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/lock/FileAppLock";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "tryLock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "lock";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readLockData";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateLock";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tryLock";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "finalizeAll";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "finalizeFileLock";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "finalizeFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FileLockData {
        @NotNull
        private RandomAccessFile myRAFile;
        @NotNull
        private FileLock myFileLock;
        @Nullable
        private AppState myState;

        private FileLockData(@NotNull RandomAccessFile raFile, @NotNull FileLock fileLock, @Nullable AppState state) {
            if (raFile == null) {
                FileLockData.$$$reportNull$$$0(0);
            }
            if (fileLock == null) {
                FileLockData.$$$reportNull$$$0(1);
            }
            this.myRAFile = raFile;
            this.myFileLock = fileLock;
            this.myState = state;
        }

        @NotNull
        public RandomAccessFile getRAFile() {
            RandomAccessFile randomAccessFile = this.myRAFile;
            if (randomAccessFile == null) {
                FileLockData.$$$reportNull$$$0(2);
            }
            return randomAccessFile;
        }

        @NotNull
        public FileLock getFileLock() {
            FileLock fileLock = this.myFileLock;
            if (fileLock == null) {
                FileLockData.$$$reportNull$$$0(3);
            }
            return fileLock;
        }

        @Nullable
        public AppState getState() {
            return this.myState;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "raFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileLock";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/launcher/lock/FileAppLock$FileLockData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/launcher/lock/FileAppLock$FileLockData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRAFile";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileLock";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface LockDataReader<T> {
        @Nullable
        public T read(@NotNull ByteBuffer var1) throws IOException;
    }
}

