/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.lock;

import com.jetbrains.launcher.AppFixedFiles;
import com.jetbrains.launcher.Destroyer;
import com.jetbrains.launcher.DestroyerStep;
import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.ThrowableRunnable;
import com.jetbrains.launcher.lock.AppState;
import com.jetbrains.launcher.lock.CannotAcquireAppLockException;
import com.jetbrains.launcher.lock.LauncherAwareAppLock;
import com.jetbrains.launcher.lock.LauncherAwareAppLockCheckerImpl;
import com.jetbrains.launcher.lock.UpdatableAppLock;
import com.jetbrains.launcher.util.ExceptionUtil;
import com.jetbrains.launcher.util.FileUtil;
import com.jetbrains.launcher.util.ProcessUtil;
import com.jetbrains.launcher.util.RuntimeUtil;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LauncherAwareAppLockImpl
extends LauncherAwareAppLockCheckerImpl
implements LauncherAwareAppLock,
UpdatableAppLock<File> {
    @NotNull
    private final Logger LOG;
    @NotNull
    private final AppFixedFiles myAppFixedFiles;
    private boolean myLocked;
    @Nullable
    private DestroyerStep myDestroyerStep;

    LauncherAwareAppLockImpl(@NotNull File launcherLogsFolder, @NotNull AppFixedFiles appFixedFiles) {
        if (launcherLogsFolder == null) {
            LauncherAwareAppLockImpl.$$$reportNull$$$0(0);
        }
        if (appFixedFiles == null) {
            LauncherAwareAppLockImpl.$$$reportNull$$$0(1);
        }
        super(launcherLogsFolder);
        this.LOG = Logger.getLogger(LauncherAwareAppLockImpl.class);
        this.myLocked = false;
        this.myAppFixedFiles = appFixedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock(@NotNull AppState state) throws InitException, CannotAcquireAppLockException {
        if (state == null) {
            LauncherAwareAppLockImpl.$$$reportNull$$$0(2);
        }
        this.myControlLock.lock();
        try {
            DestroyerStep destroyerStep = Destroyer.get().addStep(new Runnable(){

                @Override
                public void run() {
                    LauncherAwareAppLockImpl.this.unlock();
                }
            });
            boolean locked = false;
            boolean initialized = false;
            try {
                this.myBaseLock.lock(state);
                locked = true;
                LauncherAwareAppLockImpl.initLock(this.myLauncherLogsFolder, this.myAppFixedFiles, state);
                initialized = true;
            }
            finally {
                if (!initialized) {
                    if (locked) {
                        this.myBaseLock.unlock();
                    }
                    destroyerStep.remove();
                }
            }
            this.myLocked = true;
            this.myDestroyerStep = destroyerStep;
        }
        finally {
            this.myControlLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock() {
        boolean controlLockLocked = false;
        try {
            this.myControlLock.lock();
            controlLockLocked = true;
        }
        catch (InitException e) {
            ExceptionUtil.logWarning((Logger)this.LOG, (String)"Failed to acquire control lock", (Throwable)e);
        }
        try {
            if (this.myLocked) {
                LauncherAwareAppLockImpl.finalizeLock(this.myLauncherLogsFolder);
            }
        }
        finally {
            this.myLocked = false;
            if (this.myDestroyerStep != null) {
                this.myDestroyerStep.remove();
                this.myDestroyerStep = null;
            }
            if (controlLockLocked) {
                this.myControlLock.unlock();
            }
        }
    }

    private static void initLock(@NotNull File launcherLogsFolder, @NotNull AppFixedFiles appFixedFiles, @Nullable AppState state) throws InitException {
        if (launcherLogsFolder == null) {
            LauncherAwareAppLockImpl.$$$reportNull$$$0(3);
        }
        if (appFixedFiles == null) {
            LauncherAwareAppLockImpl.$$$reportNull$$$0(4);
        }
        try {
            RuntimeUtil.saveLauncherHome((File)launcherLogsFolder, (AppFixedFiles)appFixedFiles);
            RuntimeUtil.saveLauncherPid((File)launcherLogsFolder, (int)ProcessUtil.getCurrentPid());
            if (state != null && state.isRunState()) {
                RuntimeUtil.setStartFlag((File)launcherLogsFolder, (AppFixedFiles)appFixedFiles);
            }
        }
        catch (IOException e) {
            throw new InitException("Failed to save launcher runtime data: " + e.getMessage(), (Throwable)e);
        }
    }

    private static void finalizeLock(@NotNull File launcherLogsFolder) {
        if (launcherLogsFolder == null) {
            LauncherAwareAppLockImpl.$$$reportNull$$$0(5);
        }
        FileUtil.delete((File)RuntimeUtil.getLauncherPidFile((File)launcherLogsFolder));
        FileUtil.delete((File)RuntimeUtil.getLauncherHomeFile((File)launcherLogsFolder));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLock(final @NotNull File newLauncherLogsFolder, final @NotNull ThrowableRunnable<InitException> innerAction) throws InitException {
        if (newLauncherLogsFolder == null) {
            LauncherAwareAppLockImpl.$$$reportNull$$$0(6);
        }
        if (innerAction == null) {
            LauncherAwareAppLockImpl.$$$reportNull$$$0(7);
        }
        this.myControlLock.lock();
        try {
            this.myBaseLock.updateLock(LauncherAwareAppLockImpl.getBaseLockFile(newLauncherLogsFolder), new ThrowableRunnable<InitException>(){

                public void run() throws InitException {
                    LauncherAwareAppLockImpl.this.myControlLock.updateLock(LauncherAwareAppLockCheckerImpl.getControlLockFile(newLauncherLogsFolder), new ThrowableRunnable<InitException>(){

                        public void run() throws InitException {
                            if (newLauncherLogsFolder.equals(LauncherAwareAppLockImpl.this.myLauncherLogsFolder)) {
                                return;
                            }
                            if (!LauncherAwareAppLockImpl.this.myLocked) {
                                innerAction.run();
                                LauncherAwareAppLockImpl.this.myLauncherLogsFolder = newLauncherLogsFolder;
                                return;
                            }
                            try {
                                LauncherAwareAppLockImpl.initLock(newLauncherLogsFolder, LauncherAwareAppLockImpl.this.myAppFixedFiles, null);
                                innerAction.run();
                            }
                            catch (InitException e) {
                                LauncherAwareAppLockImpl.finalizeLock(newLauncherLogsFolder);
                                throw e;
                            }
                            LauncherAwareAppLockImpl.finalizeLock(LauncherAwareAppLockImpl.this.myLauncherLogsFolder);
                            LauncherAwareAppLockImpl.this.myLauncherLogsFolder = newLauncherLogsFolder;
                        }
                    });
                }
            });
        }
        finally {
            this.myControlLock.unlock();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcherLogsFolder";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appFixedFiles";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newLauncherLogsFolder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerAction";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/launcher/lock/LauncherAwareAppLockImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lock";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "initLock";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "finalizeLock";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "updateLock";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

