/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.plugins;

import com.jetbrains.launcher.AppFixedFilesImpl;
import com.jetbrains.launcher.LauncherExtension;
import com.jetbrains.launcher.Static;
import com.jetbrains.launcher.ep.AppHome;
import com.jetbrains.launcher.plugins.ExtensionHandler;
import com.jetbrains.launcher.plugins.Plugin;
import com.jetbrains.launcher.plugins.PluginContext;
import com.jetbrains.launcher.plugins.PluginContextImpl;
import com.jetbrains.launcher.util.ClassLoaderUtil;
import java.io.File;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginManager {
    @NotNull
    private static final PluginManager INSTANCE = new PluginManager();
    @Static
    @NotNull
    private final List<Plugin> myPlugins = Collections.unmodifiableList(PluginManager.loadPlugins());

    @NotNull
    public static PluginManager getInstance() {
        PluginManager pluginManager = INSTANCE;
        if (pluginManager == null) {
            PluginManager.$$$reportNull$$$0(0);
        }
        return pluginManager;
    }

    private PluginManager() {
    }

    @NotNull
    public List<String> getPluginNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Plugin plugin : this.myPlugins) {
            result.add(plugin.getContext().getPluginName());
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            PluginManager.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public <T extends LauncherExtension, E extends Throwable> void handleExtensions(@NotNull Class<T> extensionClass, @NotNull ExtensionHandler<T, E> handler) throws E {
        if (extensionClass == null) {
            PluginManager.$$$reportNull$$$0(2);
        }
        if (handler == null) {
            PluginManager.$$$reportNull$$$0(3);
        }
        for (Plugin plugin : this.myPlugins) {
            PluginContext context = plugin.getContext();
            for (LauncherExtension extension : plugin.loadExtensions(extensionClass)) {
                handler.handle(context, extension);
            }
        }
    }

    @NotNull
    public <T extends LauncherExtension> Collection<T> loadExtensions(@NotNull Class<T> extensionClass) {
        if (extensionClass == null) {
            PluginManager.$$$reportNull$$$0(4);
        }
        final ArrayList result = new ArrayList();
        this.handleExtensions(extensionClass, new ExtensionHandler<T, RuntimeException>(){

            @Override
            public void handle(@NotNull PluginContext context, @NotNull T extension) {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (extension == null) {
                    1.$$$reportNull$$$0(1);
                }
                result.add(extension);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "extension";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/launcher/plugins/PluginManager$1";
                objectArray[2] = "handle";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ArrayList arrayList = result;
        if (arrayList == null) {
            PluginManager.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private static List<Plugin> loadPlugins() {
        File[] pluginDirs = new AppFixedFilesImpl(AppHome.get()).getLauncherPluginsFolder().listFiles();
        if (pluginDirs == null) {
            List<Plugin> list = Collections.emptyList();
            if (list == null) {
                PluginManager.$$$reportNull$$$0(6);
            }
            return list;
        }
        ClassLoader launcherClassLoader = PluginManager.class.getClassLoader();
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        for (File pluginDir : pluginDirs) {
            Plugin plugin = PluginManager.loadPlugin(pluginDir, launcherClassLoader);
            if (plugin == null) continue;
            plugins.add(plugin);
        }
        ArrayList<Plugin> arrayList = plugins;
        if (arrayList == null) {
            PluginManager.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Nullable
    private static Plugin loadPlugin(@NotNull File pluginDir, @NotNull ClassLoader launcherClassLoader) {
        PluginContextImpl context;
        File pluginLibDir;
        if (pluginDir == null) {
            PluginManager.$$$reportNull$$$0(8);
        }
        if (launcherClassLoader == null) {
            PluginManager.$$$reportNull$$$0(9);
        }
        if (!(pluginLibDir = (context = new PluginContextImpl(pluginDir.getName(), pluginDir)).getPluginLibFolder()).isDirectory()) {
            return null;
        }
        URLClassLoader pluginClassLoader = ClassLoaderUtil.getClassLoaderByLibDir(pluginLibDir, launcherClassLoader, new String[0]);
        if (pluginClassLoader == null) {
            return null;
        }
        return new Plugin(context, pluginClassLoader);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/plugins/PluginManager";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDir";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcherClassLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginNames";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/plugins/PluginManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadExtensions";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPlugins";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleExtensions";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadExtensions";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadPlugin";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

