/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.run;

import com.jetbrains.launcher.AppExitCode;
import com.jetbrains.launcher.AppName;
import com.jetbrains.launcher.FatalException;
import com.jetbrains.launcher.StartKind;
import com.jetbrains.launcher.run.AgentRuntimeHelper;
import com.jetbrains.launcher.run.AgentStatusWatcher;
import com.jetbrains.launcher.run.ProcessExecutionInfo;
import com.jetbrains.launcher.run.UpToDateLauncherContext;
import com.jetbrains.launcher.util.ProcessUtil;
import com.jetbrains.launcher.util.process.ProcessHandler;
import com.jetbrains.launcher.util.process.ProcessUtilEx;
import java.io.IOException;
import java.util.Date;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AgentProcess {
    @NotNull
    private final Logger LOG;
    @NotNull
    private final UpToDateLauncherContext myContext;
    private volatile boolean myWasTerminated;

    public AgentProcess(@NotNull UpToDateLauncherContext context) {
        if (context == null) {
            AgentProcess.$$$reportNull$$$0(0);
        }
        this.LOG = Logger.getLogger(AgentProcess.class);
        this.myWasTerminated = false;
        this.myContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ProcessExecutionInfo launch(@NotNull StartKind startKind, @NotNull AgentStatusWatcher statusWatcher) throws IOException, FatalException, InterruptedException {
        boolean hasExitFlag;
        long finished;
        int exitCode;
        if (startKind == null) {
            AgentProcess.$$$reportNull$$$0(1);
        }
        if (statusWatcher == null) {
            AgentProcess.$$$reportNull$$$0(2);
        }
        this.LOG.debug((Object)(new Date().toString() + " ==> Start launch"));
        AgentRuntimeHelper agentRuntimeHelper = new AgentRuntimeHelper(this.myContext);
        agentRuntimeHelper.beforeRun();
        AppName appName = this.myContext.getAppConfig().getAppName();
        long started = System.currentTimeMillis();
        final Process process = this.myContext.createAgentFacade().startProcess(this.myContext.getArguments(), startKind);
        Logger agentProcessOutputLogger = Logger.getLogger((String)"com.jetbrains.launcher.AGENT_PROCESS");
        agentProcessOutputLogger.debug((Object)"================================================================ (start)");
        agentProcessOutputLogger.fatal((Object)"================================================================ (start)");
        final AgentProcessFinalizer agentProcessFinalizer = new AgentProcessFinalizer(agentRuntimeHelper, agentProcessOutputLogger);
        ProcessHandler processHandler = ProcessUtilEx.toLog(ProcessHandler.builder((Process)process), agentProcessOutputLogger).withStderrPrefix("[" + appName.getCapitalizedName() + " Error] ").onDestroy(new Runnable(){

            @Override
            public void run() {
                AgentProcess.this.doDestroy(process, agentProcessFinalizer);
            }
        }).build();
        agentProcessFinalizer.setProcessHandler(processHandler);
        processHandler.start();
        try {
            exitCode = process.waitFor();
            if (this.myWasTerminated) {
                this.LOG.info((Object)("Launcher has terminated " + appName.getName() + " process"));
                ProcessExecutionInfo processExecutionInfo = null;
                return processExecutionInfo;
            }
            if (exitCode != AppExitCode.RESTART.getValue() || statusWatcher.wasRunning()) {
                this.LOG.info((Object)(appName.getCapitalizedName() + " process finished"));
            }
        }
        finally {
            long finished2 = System.currentTimeMillis();
            processHandler.finish();
            boolean hasExitFlag2 = agentProcessFinalizer.finalizeProcess(false);
        }
        return new ProcessExecutionInfo(started, finished, hasExitFlag, exitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDestroy(@NotNull Process process, @NotNull AgentProcessFinalizer agentProcessFinalizer) {
        if (process == null) {
            AgentProcess.$$$reportNull$$$0(3);
        }
        if (agentProcessFinalizer == null) {
            AgentProcess.$$$reportNull$$$0(4);
        }
        try {
            if (!ProcessUtil.isAlive((Process)process)) {
                return;
            }
            this.LOG.info((Object)("Destroying " + this.myContext.getAppConfig().getAppName().getName() + " process..."));
            this.myWasTerminated = true;
            if (!this.myContext.createAgentFacade().stopOrKill()) {
                process.destroy();
            }
        }
        finally {
            agentProcessFinalizer.finalizeProcess(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startKind";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusWatcher";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentProcessFinalizer";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/launcher/run/AgentProcess";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "launch";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doDestroy";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class AgentProcessFinalizer {
        @NotNull
        private final AgentRuntimeHelper myAgentRuntimeHelper;
        @NotNull
        private final Logger myAgentProcessOutputLogger;
        @Nullable
        private volatile ProcessHandler myProcessHandler;
        @Nullable
        private Boolean myHasExitFlag;

        private AgentProcessFinalizer(@NotNull AgentRuntimeHelper agentRuntimeHelper, @NotNull Logger agentProcessOutputLogger) {
            if (agentRuntimeHelper == null) {
                AgentProcessFinalizer.$$$reportNull$$$0(0);
            }
            if (agentProcessOutputLogger == null) {
                AgentProcessFinalizer.$$$reportNull$$$0(1);
            }
            this.myAgentRuntimeHelper = agentRuntimeHelper;
            this.myAgentProcessOutputLogger = agentProcessOutputLogger;
        }

        private void setProcessHandler(@NotNull ProcessHandler processHandler) {
            if (processHandler == null) {
                AgentProcessFinalizer.$$$reportNull$$$0(2);
            }
            this.myProcessHandler = processHandler;
        }

        private synchronized boolean finalizeProcess(boolean cancelProcessHandler) {
            if (this.myHasExitFlag == null) {
                if (cancelProcessHandler) {
                    AgentProcessFinalizer.cancelIfNotNull(this.myProcessHandler);
                }
                this.myHasExitFlag = this.myAgentRuntimeHelper.afterRun();
                this.myAgentProcessOutputLogger.debug((Object)"================================================================ (finish)");
                this.myAgentProcessOutputLogger.fatal((Object)"================================================================ (finish)");
            }
            return this.myHasExitFlag;
        }

        private static void cancelIfNotNull(@Nullable ProcessHandler processHandler) {
            if (processHandler != null) {
                processHandler.cancel();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "agentRuntimeHelper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "agentProcessOutputLogger";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processHandler";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/launcher/run/AgentProcess$AgentProcessFinalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setProcessHandler";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

