/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.run;

import com.jetbrains.launcher.AppExitCode;
import com.jetbrains.launcher.AppName;
import com.jetbrains.launcher.Destroyer;
import com.jetbrains.launcher.FatalException;
import com.jetbrains.launcher.LauncherExitCode;
import com.jetbrains.launcher.StartKind;
import com.jetbrains.launcher.SystemInfo;
import com.jetbrains.launcher.run.AgentProcess;
import com.jetbrains.launcher.run.AgentStatusWatcher;
import com.jetbrains.launcher.run.AgentStatusWatcherImpl;
import com.jetbrains.launcher.run.ExitAction;
import com.jetbrains.launcher.run.ProcessExecutionInfo;
import com.jetbrains.launcher.run.UpToDateLauncherContext;
import com.jetbrains.launcher.util.ExceptionUtil;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AgentRunner {
    @NotNull
    private final Logger LOG;
    @NotNull
    private final UpToDateLauncherContext myContext;
    @NotNull
    private final AgentProcess myAgentProcess;

    public AgentRunner(@NotNull UpToDateLauncherContext context) {
        if (context == null) {
            AgentRunner.$$$reportNull$$$0(0);
        }
        this.LOG = Logger.getLogger(AgentRunner.class);
        this.myContext = context;
        this.myAgentProcess = new AgentProcess(this.myContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public LauncherExitCode run() {
        startKind = StartKind.FIRST_START;
        block13: while (true) lbl-1000:
        // 6 sources

        {
            statusWatcher = this.startWatchingAgentStatus();
            try {
                executionInfo = this.myAgentProcess.launch(startKind, statusWatcher);
                startKind = StartKind.RESTART_AFTER_CRASH;
                exitAction = this.analyzeExecutionInfo(executionInfo);
                switch (1.$SwitchMap$com$jetbrains$launcher$run$ExitAction[exitAction.ordinal()]) {
                    case 1: {
                        this.LOG.info((Object)"Launcher is exiting");
                        var5_7 = LauncherExitCode.OK;
                        v0 = var5_7;
                        break;
                    }
                    case 2: {
                        startKind = StartKind.REQUESTED_RESTART;
                        if (!statusWatcher.wasRunning()) continue block13;
                        this.LOG.info((Object)("Launcher is restarting " + this.myContext.getAppConfig().getAppName().getName() + " process"));
                        ** break;
                    }
                    case 3: {
                        this.LOG.info((Object)("Launcher is restarting " + this.myContext.getAppConfig().getAppName().getName() + " process"));
                        ** break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected state: " + (Object)exitAction);
                    }
                }
            }
            catch (FatalException e) {
                ExceptionUtil.logError((Logger)this.LOG, (String)("Failed to start " + this.myContext.getAppConfig().getAppName().getName()), (Throwable)e);
                var4_6 = LauncherExitCode.ERROR;
                v1 = var4_6;
                if (v1 != null) return v1;
                AgentRunner.$$$reportNull$$$0(2);
                return v1;
            }
            catch (Throwable e) {
                ExceptionUtil.logError((Logger)this.LOG, (String)"Unexpected error", (Throwable)e);
                statusWatcher.cancel();
                continue;
            }
            if (v0 != null) return v0;
            AgentRunner.$$$reportNull$$$0(1);
            return v0;
            finally {
                statusWatcher.cancel();
                continue;
            }
            break;
        }
    }

    @NotNull
    private AgentStatusWatcher startWatchingAgentStatus() {
        AgentStatusWatcherImpl agentStatusWatcherImpl = new AgentStatusWatcherImpl(this.myContext, SystemInfo.isWindows && this.myContext.getArguments().isStartedFromService());
        if (agentStatusWatcherImpl == null) {
            AgentRunner.$$$reportNull$$$0(3);
        }
        return agentStatusWatcherImpl;
    }

    @NotNull
    private ExitAction analyzeExecutionInfo(@Nullable ProcessExecutionInfo info) {
        if (info == null) {
            ExitAction exitAction = ExitAction.EXIT;
            if (exitAction == null) {
                AgentRunner.$$$reportNull$$$0(4);
            }
            return exitAction;
        }
        int exitCode = info.getExitCode();
        AppName appName = this.myContext.getAppConfig().getAppName();
        this.LOG.debug((Object)(appName.getCapitalizedName() + " has exited with code: " + exitCode + " (" + AgentRunner.getExitCodeDescription(exitCode) + ")"));
        if (info.hasExitFlag() || Destroyer.get().isDestroying()) {
            this.LOG.debug((Object)"Exit flag is set, launcher is exiting");
            ExitAction exitAction = ExitAction.EXIT;
            if (exitAction == null) {
                AgentRunner.$$$reportNull$$$0(5);
            }
            return exitAction;
        }
        ExitAction exitAction = this.checkKnownExitCodes(exitCode);
        if (exitAction != null) {
            ExitAction exitAction2 = exitAction;
            if (exitAction2 == null) {
                AgentRunner.$$$reportNull$$$0(6);
            }
            return exitAction2;
        }
        this.LOG.debug((Object)("Unexpected exit code, most likely " + appName.getName() + " has crashed"));
        boolean shouldRestart = info.getFinished() - info.getStarted() > 1000L;
        String executionTime = "" + (double)(info.getFinished() - info.getStarted()) / 1000.0 + " sec.";
        if (shouldRestart) {
            this.LOG.error((Object)("Unexpected exit. Restarting. Run time was: " + executionTime));
            ExitAction exitAction3 = ExitAction.RESTART_BY_LAUNCHER;
            if (exitAction3 == null) {
                AgentRunner.$$$reportNull$$$0(7);
            }
            return exitAction3;
        }
        this.LOG.error((Object)("Too short run time, most likely there is some installation problem: " + executionTime));
        ExitAction exitAction4 = ExitAction.EXIT;
        if (exitAction4 == null) {
            AgentRunner.$$$reportNull$$$0(8);
        }
        return exitAction4;
    }

    @NotNull
    private static String getExitCodeDescription(int exitCode) {
        for (AppExitCode appExitCode : AppExitCode.values()) {
            if (appExitCode.getValue() != exitCode) continue;
            String string = appExitCode.name();
            if (string == null) {
                AgentRunner.$$$reportNull$$$0(9);
            }
            return string;
        }
        if ("unknown" == null) {
            AgentRunner.$$$reportNull$$$0(10);
        }
        return "unknown";
    }

    @Nullable
    private ExitAction checkKnownExitCodes(int exitCode) {
        if (exitCode == AppExitCode.RESTART.getValue()) {
            return ExitAction.RESTART_BY_APPLICATION;
        }
        if (exitCode == AppExitCode.RESTART_ERROR.getValue()) {
            return ExitAction.RESTART_BY_LAUNCHER;
        }
        if (exitCode == AppExitCode.EXIT.getValue()) {
            return ExitAction.EXIT;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/run/AgentRunner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/run/AgentRunner";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "run";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "startWatchingAgentStatus";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "analyzeExecutionInfo";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExitCodeDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$com$jetbrains$launcher$run$ExitAction;

        static {
            $SwitchMap$com$jetbrains$launcher$run$ExitAction = new int[ExitAction.values().length];
            try {
                1.$SwitchMap$com$jetbrains$launcher$run$ExitAction[ExitAction.EXIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$jetbrains$launcher$run$ExitAction[ExitAction.RESTART_BY_APPLICATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$jetbrains$launcher$run$ExitAction[ExitAction.RESTART_BY_LAUNCHER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

