/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.run;

import com.jetbrains.launcher.AppFiles;
import com.jetbrains.launcher.AppFilesEx;
import com.jetbrains.launcher.Arguments;
import com.jetbrains.launcher.LogLevel;
import com.jetbrains.launcher.ProcessEnvironment;
import com.jetbrains.launcher.StartKind;
import com.jetbrains.launcher.StatusDescriptor;
import com.jetbrains.launcher.configs.AppConfig;
import com.jetbrains.launcher.configs.LauncherCmdConfig;
import com.jetbrains.launcher.run.AgentDiagnosticFacade;
import com.jetbrains.launcher.run.AgentRestartFacade;
import com.jetbrains.launcher.run.BaseAgent;
import com.jetbrains.launcher.util.ExceptionUtil;
import com.jetbrains.launcher.util.LauncherUtil;
import com.jetbrains.launcher.util.TimeoutException;
import com.jetbrains.launcher.util.process.ProcessHandler;
import com.jetbrains.launcher.util.process.ProcessOutputLineListener;
import com.jetbrains.launcher.util.process.ProcessOutputListener;
import com.jetbrains.launcher.util.process.ProcessOutputPart;
import com.jetbrains.launcher.util.process.ProcessUtilEx;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CmdAgent
extends BaseAgent {
    @NotNull
    private static final String APP_HOME_ENV = "JL_APP_HOME";
    @NotNull
    private static final String APP_NAME_ENV = "JL_APP_NAME";
    @NotNull
    private static final String BASE_DIR_ENV = "JL_BASE_DIR";
    @NotNull
    private static final String APP_CONF_DIR_ENV = "JL_APP_CONF_DIR";
    @NotNull
    private static final String APP_LOGS_DIR_ENV = "JL_APP_LOGS_DIR";
    @NotNull
    private static final String LAUNCHER_LOGS_DIR_ENV = "JL_LAUNCHER_LOGS_DIR";
    @NotNull
    private static final String APP_FILE_NAME_ENV = "JL_APP_FILE_NAME";
    @NotNull
    private static final String LOG_LEVEL_ENV = "JL_LOG_LEVEL";
    @NotNull
    private static final String JL_IS_SERVICE_ENV = "JL_IS_SERVICE";
    @NotNull
    private static final String JL_START_KIND_ENV = "JL_START_KIND";
    @NotNull
    private final Logger LOG;
    @NotNull
    private final LauncherCmdConfig myLauncherConfig;
    @NotNull
    private final AppConfig myAppConfig;

    public CmdAgent(@NotNull LauncherCmdConfig launcherConfig, @NotNull AppConfig appConfig, @NotNull AppFilesEx appFiles) {
        if (launcherConfig == null) {
            CmdAgent.$$$reportNull$$$0(0);
        }
        if (appConfig == null) {
            CmdAgent.$$$reportNull$$$0(1);
        }
        if (appFiles == null) {
            CmdAgent.$$$reportNull$$$0(2);
        }
        super(appFiles);
        this.LOG = Logger.getLogger(CmdAgent.class);
        this.myLauncherConfig = launcherConfig;
        this.myAppConfig = appConfig;
    }

    @Override
    @Nullable
    public Process startConfigureProcess(@NotNull Arguments args) throws IOException {
        Object[] configureCommand;
        if (args == null) {
            CmdAgent.$$$reportNull$$$0(3);
        }
        if ((configureCommand = this.myLauncherConfig.getConfigureCommand()) == null) {
            this.LOG.error((Object)"Configuration command is not specified");
            return null;
        }
        configureCommand = LauncherUtil.prepareCommand((String[])configureCommand, args.getApplicationArguments());
        File workDir = this.myAppFiles.getAppBinFolder();
        this.LOG.debug((Object)("Launching " + this.myAppConfig.getAppName().getName() + " configuration process with command: " + Arrays.toString(configureCommand) + " (at path: " + workDir.getAbsolutePath() + ")"));
        return this.doExecute((String[])configureCommand, workDir, args.getLogLevel(), args.isStartedFromService(), null, true, true);
    }

    @Override
    @NotNull
    public Process startProcess(@NotNull Arguments args, @NotNull StartKind startKind) throws IOException {
        if (args == null) {
            CmdAgent.$$$reportNull$$$0(4);
        }
        if (startKind == null) {
            CmdAgent.$$$reportNull$$$0(5);
        }
        Object[] startCommand = LauncherUtil.prepareCommand(this.myLauncherConfig.getStartCommand(), args.getApplicationArguments());
        File workDir = this.myAppFiles.getAppBinFolder();
        this.LOG.debug((Object)("Launching " + this.myAppConfig.getAppName().getName() + " process with command: " + Arrays.toString(startCommand) + " (at path: " + workDir.getAbsolutePath() + ")"));
        Process process = this.doExecute((String[])startCommand, workDir, args.getLogLevel(), args.isStartedFromService(), startKind, true, true);
        if (process == null) {
            CmdAgent.$$$reportNull$$$0(6);
        }
        return process;
    }

    @NotNull
    public StatusDescriptor getStatus(boolean isUserAction) {
        StatusDescriptor statusDescriptor;
        final StatusDescriptor[] descriptor = new StatusDescriptor[]{null};
        try {
            this.executeCommand(this.myLauncherConfig.getStatusCommand(), 30, false, isUserAction, new ProcessHandlerConfigurator(){

                @Override
                @NotNull
                public ProcessHandler.ProcessHandlerBuilder configure(@NotNull ProcessHandler.ProcessHandlerPreBuilder builder) {
                    if (builder == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ProcessHandler.ProcessHandlerBuilder processHandlerBuilder = builder.withListener((ProcessOutputListener)new ProcessOutputLineListener(){

                        protected void outputLine(@NotNull ProcessOutputPart outputPart) {
                            if (outputPart == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            descriptor[0] = StatusDescriptor.parse((String)outputPart.getText());
                        }

                        protected void errorLine(@NotNull ProcessOutputPart outputPart) {
                            if (outputPart == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            descriptor[0] = StatusDescriptor.error((String)outputPart.getText());
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            objectArray2[0] = "outputPart";
                            objectArray2[1] = "com/jetbrains/launcher/run/CmdAgent$1$1";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "outputLine";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "errorLine";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                    if (processHandlerBuilder == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return processHandlerBuilder;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "builder";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/launcher/run/CmdAgent$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/launcher/run/CmdAgent$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "configure";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "configure";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
            statusDescriptor = descriptor[0] == null ? StatusDescriptor.ERROR : descriptor[0];
        }
        catch (IOException e) {
            StatusDescriptor statusDescriptor2 = StatusDescriptor.error((String)e.getMessage());
            if (statusDescriptor2 == null) {
                CmdAgent.$$$reportNull$$$0(8);
            }
            return statusDescriptor2;
        }
        if (statusDescriptor == null) {
            CmdAgent.$$$reportNull$$$0(7);
        }
        return statusDescriptor;
    }

    @Nullable
    public AgentDiagnosticFacade getDiagnosticFacade() {
        return null;
    }

    @Nullable
    public AgentRestartFacade getRestartFacade() {
        return null;
    }

    @Override
    protected boolean doStop(boolean soft) {
        final String[] command = soft ? this.myLauncherConfig.getStopSoftCommand() : this.myLauncherConfig.getStopCommand();
        try {
            this.executeCommand(command, soft ? null : Integer.valueOf(this.myAppConfig.getStopTimeoutSeconds()), true, true, new ProcessHandlerConfigurator(){

                @Override
                @NotNull
                public ProcessHandler.ProcessHandlerBuilder configure(@NotNull ProcessHandler.ProcessHandlerPreBuilder builder) {
                    if (builder == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    ProcessHandler.ProcessHandlerBuilder processHandlerBuilder = ProcessUtilEx.toLog(builder, CmdAgent.this.LOG).withPrefix(LauncherUtil.getProcessLogPrefix(Arrays.asList(command)));
                    if (processHandlerBuilder == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return processHandlerBuilder;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "builder";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/launcher/run/CmdAgent$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/launcher/run/CmdAgent$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "configure";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "configure";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void executeCommand(@NotNull String[] command, @Nullable Integer timeoutSeconds, boolean logError, boolean isUserAction, @NotNull ProcessHandlerConfigurator processHandlerConfigurator) throws IOException {
        if (command == null) {
            CmdAgent.$$$reportNull$$$0(9);
        }
        if (processHandlerConfigurator == null) {
            CmdAgent.$$$reportNull$$$0(10);
        }
        Process process = this.doExecute(command, this.myAppFiles.getAppBinFolder(), null, null, null, logError, isUserAction);
        ProcessHandler processHandler = processHandlerConfigurator.configure(ProcessHandler.builder((Process)process)).build();
        processHandler.start();
        try {
            processHandler.waitForProcess(timeoutSeconds);
        }
        catch (InterruptedException e) {
            String message = "Process interrupted";
            this.logError(command, "Process interrupted", e, logError, isUserAction);
            throw new IOException("Process interrupted");
        }
        catch (TimeoutException e) {
            String message = "Process execution timeout (" + timeoutSeconds + " seconds) exceeded";
            this.logError(command, message, null, logError, isUserAction);
            process.destroy();
            throw new IOException(message);
        }
        finally {
            processHandler.finish();
        }
    }

    @NotNull
    private Process doExecute(@NotNull String[] command, @NotNull File workDir, @Nullable LogLevel logLevel, @Nullable Boolean isService, @Nullable StartKind startKind, boolean logError, boolean isUserAction) throws IOException {
        Process process;
        if (command == null) {
            CmdAgent.$$$reportNull$$$0(11);
        }
        if (workDir == null) {
            CmdAgent.$$$reportNull$$$0(12);
        }
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(command).directory(workDir);
            CmdAgent.setupProcessEnvironment(processBuilder.environment(), (AppFiles)this.myAppFiles, this.myAppConfig, logLevel, isService, startKind);
            process = processBuilder.start();
        }
        catch (IOException e) {
            this.logError(command, e.getMessage(), e, logError, isUserAction);
            throw e;
        }
        if (process == null) {
            CmdAgent.$$$reportNull$$$0(13);
        }
        return process;
    }

    private static void setupProcessEnvironment(@NotNull Map<String, String> env, @NotNull AppFiles appFiles, @NotNull AppConfig appConfig, @Nullable LogLevel logLevel, @Nullable Boolean isService, @Nullable StartKind startKind) {
        if (env == null) {
            CmdAgent.$$$reportNull$$$0(14);
        }
        if (appFiles == null) {
            CmdAgent.$$$reportNull$$$0(15);
        }
        if (appConfig == null) {
            CmdAgent.$$$reportNull$$$0(16);
        }
        env.putAll(ProcessEnvironment.getOwn());
        env.put(APP_HOME_ENV, appFiles.getAppHome().getAbsolutePath());
        env.put(APP_NAME_ENV, appConfig.getAppName().getName());
        env.put(BASE_DIR_ENV, appFiles.getBaseFolder().getAbsolutePath());
        env.put(APP_CONF_DIR_ENV, appFiles.getAppConfFolder().getAbsolutePath());
        env.put(APP_LOGS_DIR_ENV, appFiles.getAppLogsFolder().getAbsolutePath());
        env.put(LAUNCHER_LOGS_DIR_ENV, appFiles.getLauncherLogsFolder().getAbsolutePath());
        env.put(APP_FILE_NAME_ENV, appFiles.getAppFileName());
        if (logLevel != null) {
            env.put(LOG_LEVEL_ENV, logLevel.name());
        }
        if (isService != null) {
            env.put(JL_IS_SERVICE_ENV, isService != false ? "1" : "");
        }
        if (startKind != null) {
            env.put(JL_START_KIND_ENV, String.valueOf(startKind.ordinal()));
        }
    }

    private void logError(@NotNull String[] command, @Nullable String message, @Nullable Throwable e, boolean logError, boolean isUserAction) {
        if (command == null) {
            CmdAgent.$$$reportNull$$$0(17);
        }
        ExceptionUtil.logCommandFailure((Logger)this.LOG, (String)("Failed to execute command \"" + Arrays.toString(command) + "\": " + message), (Throwable)e, (boolean)logError, (boolean)isUserAction);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcherConfig";
                break;
            }
            case 1: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appConfig";
                break;
            }
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appFiles";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startKind";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/run/CmdAgent";
                break;
            }
            case 9: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandlerConfigurator";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workDir";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/run/CmdAgent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "doExecute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "startConfigureProcess";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "startProcess";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "executeCommand";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setupProcessEnvironment";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "logError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface ProcessHandlerConfigurator {
        @NotNull
        public ProcessHandler.ProcessHandlerBuilder configure(@NotNull ProcessHandler.ProcessHandlerPreBuilder var1);
    }
}

