/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.run;

import com.jetbrains.launcher.AppFiles;
import com.jetbrains.launcher.AppFilesEx;
import com.jetbrains.launcher.AppName;
import com.jetbrains.launcher.Arguments;
import com.jetbrains.launcher.LogLevel;
import com.jetbrains.launcher.StartKind;
import com.jetbrains.launcher.Status;
import com.jetbrains.launcher.StatusDescriptor;
import com.jetbrains.launcher.SystemInfo;
import com.jetbrains.launcher.configs.AppConfig;
import com.jetbrains.launcher.configs.JvmOptions;
import com.jetbrains.launcher.configs.JvmOptionsReader;
import com.jetbrains.launcher.configs.LauncherJavaConfig;
import com.jetbrains.launcher.run.AgentDiagnosticFacade;
import com.jetbrains.launcher.run.AgentRestartFacade;
import com.jetbrains.launcher.run.BaseAgent;
import com.jetbrains.launcher.transport.AttachedProcess;
import com.jetbrains.launcher.transport.Client;
import com.jetbrains.launcher.transport.ConnectionData;
import com.jetbrains.launcher.transport.NoResponseException;
import com.jetbrains.launcher.transport.Request;
import com.jetbrains.launcher.transport.Response;
import com.jetbrains.launcher.transport.StateAwareSocketInputStream;
import com.jetbrains.launcher.transport.TransportConstants;
import com.jetbrains.launcher.util.CmdUtil;
import com.jetbrains.launcher.util.ExceptionUtil;
import com.jetbrains.launcher.util.FileUtil;
import com.jetbrains.launcher.util.JavaUtil;
import com.jetbrains.launcher.util.ProcessUtil;
import com.jetbrains.launcher.util.RuntimeUtil;
import com.jetbrains.launcher.util.StringUtil;
import com.jetbrains.launcher.util.TimeoutException;
import com.jetbrains.launcher.util.java.InvalidJvmOptionException;
import com.jetbrains.launcher.util.java.JavaCommandLineBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaAgent
extends BaseAgent
implements AgentDiagnosticFacade,
AgentRestartFacade {
    @NotNull
    public static final String APP_CONFIGURATOR_CLASS_SIMPLE_NAME = "AppConfigurator";
    @NotNull
    public static final String APP_STARTER_CLASS_SIMPLE_NAME = "AppStarter";
    @NotNull
    private final Logger LOG;
    @NotNull
    private final LauncherJavaConfig myLauncherConfig;
    @NotNull
    private final AppConfig myAppConfig;

    public JavaAgent(@NotNull LauncherJavaConfig launcherConfig, @NotNull AppConfig appConfig, @NotNull AppFilesEx appFiles) {
        if (launcherConfig == null) {
            JavaAgent.$$$reportNull$$$0(0);
        }
        if (appConfig == null) {
            JavaAgent.$$$reportNull$$$0(1);
        }
        if (appFiles == null) {
            JavaAgent.$$$reportNull$$$0(2);
        }
        super(appFiles);
        this.LOG = Logger.getLogger(JavaAgent.class);
        this.myLauncherConfig = launcherConfig;
        this.myAppConfig = appConfig;
    }

    @Override
    @Nullable
    public Process startConfigureProcess(@NotNull Arguments args) throws IOException, InvalidJvmOptionException {
        if (args == null) {
            JavaAgent.$$$reportNull$$$0(3);
        }
        JavaCommandLineBuilder builder = this.createConfigureCommandLineBuilder(args);
        return this.doStartProcess(builder, " configuration");
    }

    @NotNull
    public JavaCommandLineBuilder createConfigureCommandLineBuilder(@NotNull Arguments args) throws IOException, InvalidJvmOptionException {
        if (args == null) {
            JavaAgent.$$$reportNull$$$0(4);
        }
        JavaCommandLineBuilder builder = this.createCommonCommandLineBuilder(args, APP_CONFIGURATOR_CLASS_SIMPLE_NAME, null);
        builder.setUseJavaw(true);
        JavaCommandLineBuilder javaCommandLineBuilder = builder;
        if (javaCommandLineBuilder == null) {
            JavaAgent.$$$reportNull$$$0(5);
        }
        return javaCommandLineBuilder;
    }

    @Override
    @NotNull
    public Process startProcess(@NotNull Arguments args, @NotNull StartKind startKind) throws IOException, InvalidJvmOptionException {
        if (args == null) {
            JavaAgent.$$$reportNull$$$0(6);
        }
        if (startKind == null) {
            JavaAgent.$$$reportNull$$$0(7);
        }
        JavaCommandLineBuilder builder = this.createStartCommandLineBuilder(args, startKind);
        Process process = this.doStartProcess(builder, "");
        if (process == null) {
            JavaAgent.$$$reportNull$$$0(8);
        }
        return process;
    }

    @NotNull
    public JavaCommandLineBuilder createStartCommandLineBuilder(@NotNull Arguments args, @NotNull StartKind startKind) throws IOException, InvalidJvmOptionException {
        if (args == null) {
            JavaAgent.$$$reportNull$$$0(9);
        }
        if (startKind == null) {
            JavaAgent.$$$reportNull$$$0(10);
        }
        JavaCommandLineBuilder builder = this.createCommonCommandLineBuilder(args, APP_STARTER_CLASS_SIMPLE_NAME, startKind);
        builder.setUseJavaw(args.isSyncRun());
        JavaCommandLineBuilder javaCommandLineBuilder = builder;
        if (javaCommandLineBuilder == null) {
            JavaAgent.$$$reportNull$$$0(11);
        }
        return javaCommandLineBuilder;
    }

    @NotNull
    private JavaCommandLineBuilder createCommonCommandLineBuilder(@NotNull Arguments args, @NotNull String entryPointKey, @Nullable StartKind startKind) throws IOException, InvalidJvmOptionException {
        if (args == null) {
            JavaAgent.$$$reportNull$$$0(12);
        }
        if (entryPointKey == null) {
            JavaAgent.$$$reportNull$$$0(13);
        }
        JavaCommandLineBuilder builder = new JavaCommandLineBuilder(this.myAppFiles.getAppHome(), this.myAppFiles.getAppWrapperLibFolder(), entryPointKey);
        JvmOptions appJvmOptions = this.readAppJvmOptions(args);
        builder.addJvmOptions(appJvmOptions.getJvmOptions());
        builder.setDebugOptionsIfSpecified();
        builder.passAgentSystemPropertiesThrough();
        builder.passLauncherSystemPropertiesThrough();
        builder.addEnvSystemProperty("launcher.app.home", this.myAppFiles.getAppHome().getAbsolutePath());
        builder.addEnvSystemPropertyIfNotNull("launcher.app.name", JavaAgent.nonDefaultOrNull(this.myAppConfig.getAppName().getName(), "application"));
        builder.addEnvSystemPropertyIfNotNull("launcher.base.dir", JavaAgent.nonDefaultOrNull(this.myAppConfig.getBaseDirPath(), "."));
        builder.addEnvSystemPropertyIfNotNull("launcher.app.conf.dir", JavaAgent.nonDefaultOrNull(this.myAppFiles.getAppConfigRawPath(), "conf"));
        builder.addEnvSystemPropertyIfNotNull("launcher.app.lib.dir", JavaAgent.nonDefaultOrNull(this.myAppConfig.getAppLibDirPath(), "lib"));
        builder.addEnvSystemPropertyIfNotNull("launcher.app.logs.dir", JavaAgent.nonDefaultOrNull(this.myAppConfig.getAppLogsDirPath(), "logs"));
        builder.addEnvSystemPropertyIfNotNull("launcher.logs.dir", JavaAgent.nonDefaultOrNull(this.myAppConfig.getLauncherLogsDirPath(), "."));
        builder.addEnvSystemPropertyIfNotNull("launcher.log.level", JavaAgent.getLogLevelName(args));
        builder.addEnvSystemPropertyIfNotNull("launcher.is.service", JavaAgent.getTrueOrNull(args.isStartedFromService()));
        builder.addEnvSystemPropertyIfNotNull("launcher.start.kind", JavaAgent.getStartKindOrdinal(startKind));
        builder.addEnvSystemProperties(appJvmOptions.getEnvSystemProperties());
        builder.addProgramArg(this.myLauncherConfig.getAppWrapperClassName());
        builder.addProgramArgs(this.myLauncherConfig.getAppWrapperArgs());
        builder.addProgramArgs(args.getApplicationArguments());
        JavaCommandLineBuilder javaCommandLineBuilder = builder;
        if (javaCommandLineBuilder == null) {
            JavaAgent.$$$reportNull$$$0(14);
        }
        return javaCommandLineBuilder;
    }

    @NotNull
    public JvmOptions readAppJvmOptions(@NotNull Arguments args) throws IOException, InvalidJvmOptionException {
        if (args == null) {
            JavaAgent.$$$reportNull$$$0(15);
        }
        JvmOptions jvmOptions = new JvmOptionsReader(this.myAppFiles, this.myAppConfig).readAppJvmOptions(args);
        if (jvmOptions == null) {
            JavaAgent.$$$reportNull$$$0(16);
        }
        return jvmOptions;
    }

    @Nullable
    private static String nonDefaultOrNull(@Nullable String value, @NotNull String defaultValue) {
        if (defaultValue == null) {
            JavaAgent.$$$reportNull$$$0(17);
        }
        return defaultValue.equals(value) ? null : value;
    }

    @Nullable
    private static String getLogLevelName(@NotNull Arguments args) {
        LogLevel logLevel;
        if (args == null) {
            JavaAgent.$$$reportNull$$$0(18);
        }
        return (logLevel = args.getLogLevel()) == TransportConstants.DEFAULT_LOG_LEVEL ? null : logLevel.name();
    }

    @Nullable
    private static String getStartKindOrdinal(@Nullable StartKind startKind) {
        return startKind == null || startKind == TransportConstants.DEFAULT_START_KIND ? null : String.valueOf(startKind.ordinal());
    }

    @Nullable
    private static String getTrueOrNull(boolean value) {
        return value ? String.valueOf(true) : null;
    }

    @NotNull
    private Process doStartProcess(@NotNull JavaCommandLineBuilder builder, @NotNull String processType) throws IOException {
        if (builder == null) {
            JavaAgent.$$$reportNull$$$0(19);
        }
        if (processType == null) {
            JavaAgent.$$$reportNull$$$0(20);
        }
        AppName appName = this.myAppConfig.getAppName();
        File appHome = this.myAppFiles.getAppHome();
        List<String> cmdLine = builder.build(appName, appHome);
        Map<String, String> envSystemProperties = builder.getEnvSystemProperties();
        this.LOG.debug((Object)("Launching " + appName.getName() + processType + " process with command: " + cmdLine + " (at path: \"" + appHome.getAbsolutePath() + "\", system properties: " + envSystemProperties + ")"));
        Process process = CmdUtil.executeJava((File)appHome, cmdLine, envSystemProperties);
        if (process == null) {
            JavaAgent.$$$reportNull$$$0(21);
        }
        return process;
    }

    @NotNull
    public StatusDescriptor getStatus(boolean isUserAction) {
        if (!RuntimeUtil.hasConnectionData((AppFiles)this.myAppFiles)) {
            StatusDescriptor statusDescriptor = new StatusDescriptor(RuntimeUtil.isStartFlagSet((AppFiles)this.myAppFiles) ? Status.STARTING : Status.SHUTTING_DOWN, null);
            if (statusDescriptor == null) {
                JavaAgent.$$$reportNull$$$0(22);
            }
            return statusDescriptor;
        }
        if (RuntimeUtil.isExitFlagSet((AppFiles)this.myAppFiles)) {
            StatusDescriptor statusDescriptor = new StatusDescriptor(Status.SHUTTING_DOWN, null);
            if (statusDescriptor == null) {
                JavaAgent.$$$reportNull$$$0(23);
            }
            return statusDescriptor;
        }
        Request request = new Request("/status", null);
        Response response = this.sendCommand(request, 30, false, isUserAction, true);
        StatusDescriptor statusDescriptor = response.getCode() == 204 ? StatusDescriptor.parse((String)response.getText()) : StatusDescriptor.error((String)("Failed to request status: " + response.getCode() + " " + response.getText()));
        if (statusDescriptor == null) {
            JavaAgent.$$$reportNull$$$0(24);
        }
        return statusDescriptor;
    }

    @NotNull
    public AgentDiagnosticFacade getDiagnosticFacade() {
        JavaAgent javaAgent = this;
        if (javaAgent == null) {
            JavaAgent.$$$reportNull$$$0(25);
        }
        return javaAgent;
    }

    @NotNull
    public AgentRestartFacade getRestartFacade() {
        JavaAgent javaAgent = this;
        if (javaAgent == null) {
            JavaAgent.$$$reportNull$$$0(26);
        }
        return javaAgent;
    }

    @NotNull
    public String dumpThreads() throws IOException {
        String string = this.doDumpThreads();
        if (string == null) {
            JavaAgent.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    private String doDumpThreads() throws IOException {
        File jstack = JavaUtil.findJStackTool();
        if (jstack != null) {
            String string;
            try {
                string = this.exec(15, JavaUtil.getJStackToolCommandLine((File)jstack, (int)RuntimeUtil.loadAppPid((AppFiles)this.myAppFiles))).trim();
            }
            catch (IOException e) {
                ExceptionUtil.logStackTrace((Logger)this.LOG, (String)"Failed to call \"jstack\" tool", (Throwable)e);
            }
            if (string == null) {
                JavaAgent.$$$reportNull$$$0(28);
            }
            return string;
        }
        String string = this.performDumpRequest("/dumpThreads");
        if (string == null) {
            JavaAgent.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    public File dumpThreadsToFile() throws IOException {
        StringWriter buf = new StringWriter();
        PrintWriter pw = new PrintWriter(buf);
        pw.println(this.doDumpThreads());
        pw.flush();
        File file = RuntimeUtil.getAppThreadDumpFile((AppFiles)this.myAppFiles);
        FileUtil.saveText((File)file, (String)buf.toString());
        File file2 = file;
        if (file2 == null) {
            JavaAgent.$$$reportNull$$$0(30);
        }
        return file2;
    }

    @NotNull
    public File dumpHeapToFile() throws IOException {
        File jmap = JavaUtil.findJMapTool();
        if (jmap != null) {
            File file;
            try {
                File file2 = RuntimeUtil.getAppHeapDumpFile((AppFiles)this.myAppFiles);
                this.exec(null, JavaUtil.getJMapToolCommandLine((File)jmap, (File)file2, (int)RuntimeUtil.loadAppPid((AppFiles)this.myAppFiles)));
                file = file2;
            }
            catch (IOException e) {
                ExceptionUtil.logStackTrace((Logger)this.LOG, (String)"Failed to call \"jmap\" tool", (Throwable)e);
            }
            if (file == null) {
                JavaAgent.$$$reportNull$$$0(31);
            }
            return file;
        }
        File file = new File(this.performDumpRequest("/dumpHeap"));
        if (file == null) {
            JavaAgent.$$$reportNull$$$0(32);
        }
        return file;
    }

    @NotNull
    private String exec(@Nullable Integer timeoutSeconds, String ... command) throws IOException {
        String string;
        if (command == null) {
            JavaAgent.$$$reportNull$$$0(33);
        }
        try {
            ProcessUtil.ExecutionResult executionResult = ProcessUtil.runCommand((Integer)timeoutSeconds, (String[])command);
            for (String line : executionResult.getStderr()) {
                this.LOG.error((Object)line);
            }
            string = StringUtil.join((Collection)executionResult.getStdout(), (String)SystemInfo.EOL);
        }
        catch (TimeoutException e) {
            throw new IOException(e.getMessage(), e);
        }
        if (string == null) {
            JavaAgent.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    private String performDumpRequest(@NotNull String url) throws IOException {
        if (url == null) {
            JavaAgent.$$$reportNull$$$0(35);
        }
        Request request = new Request(url, null);
        Response response = this.sendCommand(request, 30, false, true, true);
        String text = response.getText();
        if (response.getCode() == 204) {
            if (text == null) {
                throw new IOException("Response text is null");
            }
            String string = text;
            if (string == null) {
                JavaAgent.$$$reportNull$$$0(36);
            }
            return string;
        }
        throw new IOException(text);
    }

    @NotNull
    public Process attach() throws IOException {
        AttachedProcess attachedProcess;
        block2: {
            ConnectionData data = RuntimeUtil.loadConnectionData((AppFiles)this.myAppFiles);
            int port = data.getPort();
            final Client stdoutClient = new Client(port);
            final Client stderrClient = new Client(port);
            try {
                final StateAwareSocketInputStream stdoutStream = stdoutClient.openStream(JavaAgent.createAttachRequest(data, false), 30);
                final StateAwareSocketInputStream stderrStream = stderrClient.openStream(JavaAgent.createAttachRequest(data, true), 30);
                attachedProcess = new AttachedProcess(stdoutStream, stderrStream){

                    @Override
                    protected void doDestroy() {
                        stdoutStream.finish();
                        stderrStream.finish();
                        FileUtil.close((Closeable)stdoutClient);
                        FileUtil.close((Closeable)stderrClient);
                    }
                };
                if (attachedProcess != null) break block2;
            }
            catch (NoResponseException e) {
                throw new IOException(e.getMessage(), e);
            }
            JavaAgent.$$$reportNull$$$0(37);
        }
        return attachedProcess;
    }

    @NotNull
    private static Request createAttachRequest(@NotNull ConnectionData data, boolean stderr) throws IOException {
        if (data == null) {
            JavaAgent.$$$reportNull$$$0(38);
        }
        Request request = new Request("/attach", Collections.singletonMap("stderr", String.valueOf(stderr)));
        request.setAuthToken(data.getAuthToken());
        Request request2 = request;
        if (request2 == null) {
            JavaAgent.$$$reportNull$$$0(39);
        }
        return request2;
    }

    public boolean requestRestart(boolean soft) {
        Request request = new Request("/restart", Collections.singletonMap("soft", String.valueOf(soft)));
        Response response = this.sendCommand(request, soft ? null : Integer.valueOf(this.myAppConfig.getStopTimeoutSeconds()), true, true, false);
        return response.getCode() == 204;
    }

    public boolean killForRestart() {
        return this.doKill();
    }

    @Override
    protected boolean doStop(boolean soft) {
        Request request = new Request("/stop", Collections.singletonMap("soft", String.valueOf(soft)));
        Response response = this.sendCommand(request, soft ? null : Integer.valueOf(this.myAppConfig.getStopTimeoutSeconds()), true, true, false);
        return response.getCode() == 204;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    private Response sendCommand(@NotNull Request request, @Nullable Integer timeoutSeconds, boolean logError, boolean isUserAction, boolean isResponseRequired) {
        Response response;
        if (request == null) {
            JavaAgent.$$$reportNull$$$0(40);
        }
        ConnectionData data = null;
        Client client = null;
        try {
            data = RuntimeUtil.loadConnectionData((AppFiles)this.myAppFiles);
            request.setAuthToken(data.getAuthToken());
            client = new Client(data.getPort());
            response = client.send(request, timeoutSeconds);
        }
        catch (NoResponseException e) {
            block12: {
                if (!isResponseRequired) break block12;
                this.logFailure(request, data, logError, isUserAction, e);
                Response response2 = new Response(500, e.getMessage());
                FileUtil.close((Closeable)client);
                Response response3 = response2;
                if (response3 == null) {
                    JavaAgent.$$$reportNull$$$0(42);
                }
                return response3;
            }
            Response response4 = new Response(204, null);
            FileUtil.close((Closeable)client);
            Response response5 = response4;
            if (response5 == null) {
                JavaAgent.$$$reportNull$$$0(43);
            }
            return response5;
        }
        catch (Exception e2) {
            this.logFailure(request, data, logError, isUserAction, e2);
            Response response6 = new Response(500, e2.getMessage());
            {
                catch (Throwable throwable) {
                    FileUtil.close(client);
                    throw throwable;
                }
            }
            FileUtil.close((Closeable)client);
            Response response7 = response6;
            if (response7 == null) {
                JavaAgent.$$$reportNull$$$0(44);
            }
            return response7;
        }
        FileUtil.close((Closeable)client);
        Response response8 = response;
        if (response8 == null) {
            JavaAgent.$$$reportNull$$$0(41);
        }
        return response8;
    }

    private void logFailure(@NotNull Request request, @Nullable ConnectionData data, boolean logError, boolean isUserAction, @NotNull Exception e) {
        if (request == null) {
            JavaAgent.$$$reportNull$$$0(45);
        }
        if (e == null) {
            JavaAgent.$$$reportNull$$$0(46);
        }
        ExceptionUtil.logCommandFailure((Logger)this.LOG, (String)("Failed to send command \"" + request.getURL() + "\"" + (data == null ? "" : " to 127.0.0.1:" + data.getPort()) + " (params: " + request.getParams() + "): " + e.getMessage()), (Throwable)e, (boolean)logError, (boolean)isUserAction);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcherConfig";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appConfig";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appFiles";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/run/JavaAgent";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startKind";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryPointKey";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processType";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 40: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/run/JavaAgent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigureCommandLineBuilder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createStartCommandLineBuilder";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommonCommandLineBuilder";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "readAppJvmOptions";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "doStartProcess";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiagnosticFacade";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getRestartFacade";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpThreads";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "doDumpThreads";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpThreadsToFile";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpHeapToFile";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "exec";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "performDumpRequest";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "attach";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttachRequest";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "sendCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "startConfigureProcess";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createConfigureCommandLineBuilder";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "startProcess";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createStartCommandLineBuilder";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createCommonCommandLineBuilder";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "readAppJvmOptions";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "nonDefaultOrNull";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getLogLevelName";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doStartProcess";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "exec";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "performDumpRequest";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createAttachRequest";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "sendCommand";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "logFailure";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

