/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.run;

import com.jetbrains.launcher.AppConfigFilesEx;
import com.jetbrains.launcher.AppFilesEx;
import com.jetbrains.launcher.Arguments;
import com.jetbrains.launcher.Destroyer;
import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.LauncherConfigFilesAwareContext;
import com.jetbrains.launcher.LauncherContextEx;
import com.jetbrains.launcher.LauncherContextFactory;
import com.jetbrains.launcher.StatusDescriptor;
import com.jetbrains.launcher.configs.AppConfig;
import com.jetbrains.launcher.configs.LauncherConfig;
import com.jetbrains.launcher.lock.AppState;
import com.jetbrains.launcher.log.LogInitializer;
import com.jetbrains.launcher.run.AgentStartFacade;
import com.jetbrains.launcher.run.LauncherContextListener;
import com.jetbrains.launcher.util.ExceptionUtil;
import com.jetbrains.launcher.util.ThreadUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpToDateLauncherContext
implements LauncherContextEx {
    @NotNull
    private final Logger LOG;
    @NotNull
    private final List<LauncherContextListener> myListeners;
    @NotNull
    private LauncherContextEx myContext;

    public UpToDateLauncherContext(@NotNull LauncherContextEx context) {
        if (context == null) {
            UpToDateLauncherContext.$$$reportNull$$$0(0);
        }
        this.LOG = Logger.getLogger(UpToDateLauncherContext.class);
        this.myListeners = new ArrayList<LauncherContextListener>();
        this.myContext = context;
    }

    @NotNull
    public Arguments getArguments() {
        Arguments arguments = this.getContext().getArguments();
        if (arguments == null) {
            UpToDateLauncherContext.$$$reportNull$$$0(1);
        }
        return arguments;
    }

    @NotNull
    public AppConfig getAppConfig() {
        AppConfig appConfig = this.getContext().getAppConfig();
        if (appConfig == null) {
            UpToDateLauncherContext.$$$reportNull$$$0(2);
        }
        return appConfig;
    }

    @NotNull
    public AppFilesEx getAppFiles() {
        AppFilesEx appFilesEx = this.getContext().getAppFiles();
        if (appFilesEx == null) {
            UpToDateLauncherContext.$$$reportNull$$$0(3);
        }
        return appFilesEx;
    }

    @NotNull
    public AppConfigFilesEx getAppConfigFiles() {
        AppConfigFilesEx appConfigFilesEx = this.getContext().getAppConfigFiles();
        if (appConfigFilesEx == null) {
            UpToDateLauncherContext.$$$reportNull$$$0(4);
        }
        return appConfigFilesEx;
    }

    @NotNull
    public LauncherConfig getLauncherConfig() {
        LauncherConfig launcherConfig = this.getContext().getLauncherConfig();
        if (launcherConfig == null) {
            UpToDateLauncherContext.$$$reportNull$$$0(5);
        }
        return launcherConfig;
    }

    @Override
    @NotNull
    public AgentStartFacade createAgentFacade() {
        AgentStartFacade agentStartFacade = this.getContext().createAgentFacade();
        if (agentStartFacade == null) {
            UpToDateLauncherContext.$$$reportNull$$$0(6);
        }
        return agentStartFacade;
    }

    @Override
    @Nullable
    public AppState getAppState() throws InitException {
        return this.getContext().getAppState();
    }

    @Override
    @NotNull
    public StatusDescriptor getStatus(boolean isUserAction) throws InitException {
        StatusDescriptor statusDescriptor = this.getContext().getStatus(isUserAction);
        if (statusDescriptor == null) {
            UpToDateLauncherContext.$$$reportNull$$$0(7);
        }
        return statusDescriptor;
    }

    @Override
    @NotNull
    public String getIllegalAppStateErrorText(@NotNull AppState requestedState) {
        if (requestedState == null) {
            UpToDateLauncherContext.$$$reportNull$$$0(8);
        }
        String string = this.getContext().getIllegalAppStateErrorText(requestedState);
        if (string == null) {
            UpToDateLauncherContext.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public boolean isObsolete() {
        return false;
    }

    @Override
    @NotNull
    public UpToDateLauncherContext withArguments(@NotNull Arguments args) {
        if (args == null) {
            UpToDateLauncherContext.$$$reportNull$$$0(10);
        }
        UpToDateLauncherContext upToDateLauncherContext = new UpToDateLauncherContext(this.myContext.withArguments(args));
        if (upToDateLauncherContext == null) {
            UpToDateLauncherContext.$$$reportNull$$$0(11);
        }
        return upToDateLauncherContext;
    }

    public void addListener(@NotNull LauncherContextListener listener) {
        if (listener == null) {
            UpToDateLauncherContext.$$$reportNull$$$0(12);
        }
        this.myListeners.add(listener);
    }

    @NotNull
    private LauncherContextEx getContext() {
        if (this.myContext.isObsolete()) {
            this.LOG.debug((Object)(this.myContext.getAppConfig().getAppName().getCapitalizedName() + " config files were changed, reinitializing..."));
            try {
                AppConfigFilesEx appConfigFiles = this.myContext.getAppConfigFiles();
                int appConfigHash = appConfigFiles.getAppConfigHash();
                ThreadUtil.sleep((long)2000L);
                this.myContext = LauncherContextFactory.createContext((LauncherConfigFilesAwareContext)this.myContext, appConfigFiles, appConfigHash);
                if (!Destroyer.get().isDestroying()) {
                    LogInitializer.reinit((File)this.myContext.getAppFiles().getLauncherLogsFolder());
                    this.notifyListeners();
                }
            }
            catch (Exception e) {
                ExceptionUtil.logError((Logger)this.LOG, (String)("Failed to reinitialize " + this.myContext.getAppConfig().getAppName().getName()), (Throwable)e);
            }
        }
        LauncherContextEx launcherContextEx = this.myContext;
        if (launcherContextEx == null) {
            UpToDateLauncherContext.$$$reportNull$$$0(13);
        }
        return launcherContextEx;
    }

    private void notifyListeners() throws InitException {
        for (LauncherContextListener listener : new ArrayList<LauncherContextListener>(this.myListeners)) {
            listener.launcherContextChanged(this.myContext);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/run/UpToDateLauncherContext";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestedState";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/run/UpToDateLauncherContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppConfig";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppFiles";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppConfigFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLauncherConfig";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createAgentFacade";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getIllegalAppStateErrorText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "withArguments";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getIllegalAppStateErrorText";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "withArguments";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

