/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.transport;

import com.jetbrains.launcher.Destroyer;
import com.jetbrains.launcher.DestroyerStep;
import com.jetbrains.launcher.transport.NoResponseException;
import com.jetbrains.launcher.transport.Request;
import com.jetbrains.launcher.transport.Response;
import com.jetbrains.launcher.transport.StateAwareSocketInputStream;
import com.jetbrains.launcher.transport.TimeoutAwareSocketInputStream;
import com.jetbrains.launcher.util.FileUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Client
implements Closeable {
    @NotNull
    private final Socket mySocket;
    @NotNull
    private final DestroyerStep myDestroyerStep;

    public Client(int port) throws IOException {
        this.mySocket = new Socket("127.0.0.1", port);
        this.myDestroyerStep = Destroyer.get().addStep(new Runnable(){

            @Override
            public void run() {
                FileUtil.close((Closeable)new Closeable(){

                    @Override
                    public void close() throws IOException {
                        Client.this.doClose();
                    }
                });
            }
        });
    }

    @NotNull
    public Response send(@NotNull Request request, @Nullable Integer timeoutSeconds) throws IOException, NoResponseException {
        Response response;
        if (request == null) {
            Client.$$$reportNull$$$0(0);
        }
        ObjectOutputStream outputStream = new ObjectOutputStream(this.mySocket.getOutputStream());
        outputStream.writeObject(request);
        outputStream.flush();
        TimeoutAwareSocketInputStream inputStream = new TimeoutAwareSocketInputStream(this.mySocket, timeoutSeconds);
        try {
            Object response2 = new ObjectInputStream(inputStream).readObject();
            if (!(response2 instanceof Response)) {
                throw new ClassCastException("Failed to cast \"" + response2.getClass().getName() + "\" to \"" + Response.class.getName() + "\"");
            }
            response = (Response)response2;
        }
        catch (SocketTimeoutException e) {
            throw new IOException("Request execution timeout (" + timeoutSeconds + " seconds) exceeded", e);
        }
        catch (IOException e) {
            throw new NoResponseException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
        if (response == null) {
            Client.$$$reportNull$$$0(1);
        }
        return response;
    }

    @NotNull
    public StateAwareSocketInputStream openStream(@NotNull Request request, @Nullable Integer timeoutSeconds) throws IOException, NoResponseException {
        Response response;
        if (request == null) {
            Client.$$$reportNull$$$0(2);
        }
        if ((response = this.send(request, timeoutSeconds)).getCode() != 200) {
            throw new IOException("No stream in response: \"" + response.describe() + "\"");
        }
        this.mySocket.setSoTimeout(0);
        StateAwareSocketInputStream stateAwareSocketInputStream = new StateAwareSocketInputStream(this.mySocket, "Request: " + request.describe());
        if (stateAwareSocketInputStream == null) {
            Client.$$$reportNull$$$0(3);
        }
        return stateAwareSocketInputStream;
    }

    @Override
    public void close() throws IOException {
        this.myDestroyerStep.remove();
        this.doClose();
    }

    private void doClose() throws IOException {
        this.mySocket.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/transport/Client";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/transport/Client";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "send";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "openStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "send";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "openStream";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

