/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.transport;

import com.jetbrains.launcher.JLThread;
import com.jetbrains.launcher.util.ThreadUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.jetbrains.annotations.NotNull;

public class StateAwareSocketInputStream {
    @NotNull
    private final InputStream myInputStream;
    @NotNull
    private final OutputStream myOutputStream;
    private volatile boolean myClosed;

    public StateAwareSocketInputStream(@NotNull Socket socket, @NotNull String description) throws IOException {
        if (socket == null) {
            StateAwareSocketInputStream.$$$reportNull$$$0(0);
        }
        if (description == null) {
            StateAwareSocketInputStream.$$$reportNull$$$0(1);
        }
        this.myClosed = false;
        this.myInputStream = socket.getInputStream();
        this.myOutputStream = socket.getOutputStream();
        new JLThread("Socket Observer (" + description + ")"){
            {
                this.setDaemon(true);
            }

            public void run() {
                try {
                    while (!StateAwareSocketInputStream.this.myClosed) {
                        StateAwareSocketInputStream.this.writeAndFlush(0);
                        ThreadUtil.sleep((long)1000L);
                    }
                }
                catch (IOException e) {
                    StateAwareSocketInputStream.this.myClosed = true;
                }
            }
        }.start();
    }

    @NotNull
    public InputStream getInputStream() {
        InputStream inputStream = this.myInputStream;
        if (inputStream == null) {
            StateAwareSocketInputStream.$$$reportNull$$$0(2);
        }
        return inputStream;
    }

    public boolean isClosed() {
        return this.myClosed;
    }

    public void finish() {
        try {
            this.writeAndFlush(1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeAndFlush(int b) throws IOException {
        this.myOutputStream.write(b);
        this.myOutputStream.flush();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "socket";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/transport/StateAwareSocketInputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/transport/StateAwareSocketInputStream";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

