/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.util;

import com.jetbrains.launcher.util.JarFilter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassLoaderUtil {
    @Nullable
    public static URLClassLoader getClassLoaderByLibDir(@NotNull File libDir, @Nullable ClassLoader parent, String ... apiJarSuffixes) {
        if (libDir == null) {
            ClassLoaderUtil.$$$reportNull$$$0(0);
        }
        if (apiJarSuffixes == null) {
            ClassLoaderUtil.$$$reportNull$$$0(1);
        }
        return ClassLoaderUtil.getClassLoaderByLibDirs(Collections.singletonList(libDir), parent, apiJarSuffixes);
    }

    @Nullable
    public static URLClassLoader getClassLoaderByLibDirs(@NotNull List<File> libDirs, @Nullable ClassLoader parent, String ... apiJarSuffixes) {
        if (libDirs == null) {
            ClassLoaderUtil.$$$reportNull$$$0(2);
        }
        if (apiJarSuffixes == null) {
            ClassLoaderUtil.$$$reportNull$$$0(3);
        }
        ArrayList<URL> apiUrls = new ArrayList<URL>();
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File libDir : libDirs) {
            File[] files = libDir.listFiles(new JarFilter());
            if (files == null) continue;
            for (File file : files) {
                ArrayList<URL> listToAddTo = ClassLoaderUtil.isApiJar(file.getName(), apiJarSuffixes) ? apiUrls : urls;
                try {
                    listToAddTo.add(file.toURI().toURL());
                }
                catch (MalformedURLException ignore) {
                    // empty catch block
                }
            }
        }
        if (apiUrls.isEmpty() && urls.isEmpty()) {
            return null;
        }
        return apiUrls.isEmpty() ? new URLClassLoader(ClassLoaderUtil.toArray(urls), parent) : new URLClassLoader(ClassLoaderUtil.toArray(urls), (ClassLoader)new URLClassLoader(ClassLoaderUtil.toArray(apiUrls), parent));
    }

    private static boolean isApiJar(@NotNull String fileName, @NotNull String[] apiJarSuffixes) {
        if (fileName == null) {
            ClassLoaderUtil.$$$reportNull$$$0(4);
        }
        if (apiJarSuffixes == null) {
            ClassLoaderUtil.$$$reportNull$$$0(5);
        }
        for (String apiJarSuffix : apiJarSuffixes) {
            if (!fileName.endsWith(apiJarSuffix + ".jar")) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static URL[] toArray(@NotNull List<URL> urls) {
        if (urls == null) {
            ClassLoaderUtil.$$$reportNull$$$0(6);
        }
        URL[] uRLArray = urls.toArray(new URL[urls.size()]);
        if (uRLArray == null) {
            ClassLoaderUtil.$$$reportNull$$$0(7);
        }
        return uRLArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libDir";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apiJarSuffixes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libDirs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/util/ClassLoaderUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/util/ClassLoaderUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getClassLoaderByLibDir";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getClassLoaderByLibDirs";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isApiJar";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

