/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.util;

import com.jetbrains.launcher.util.BootstrapUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import org.jetbrains.annotations.NotNull;

public class ClasspathUtil {
    @NotNull
    public static File getBootClasspathEntry() throws IOException {
        File file = ClasspathUtil.getClasspathEntry(BootstrapUtil.class);
        if (file == null) {
            ClasspathUtil.$$$reportNull$$$0(0);
        }
        return file;
    }

    @NotNull
    private static File getClasspathEntry(@NotNull Class aClass) throws IOException {
        String path;
        URL resource;
        if (aClass == null) {
            ClasspathUtil.$$$reportNull$$$0(1);
        }
        if ((resource = aClass.getResource(path = ClasspathUtil.classNameToResourcePath(aClass.getName()))) == null) {
            throw new IOException("Failed to find resource path for class: " + aClass);
        }
        File file = ClasspathUtil.resourceUrlToClasspathEntry(aClass.getName(), resource);
        if (file == null) {
            ClasspathUtil.$$$reportNull$$$0(2);
        }
        return file;
    }

    @NotNull
    public static File resourceUrlToClasspathEntry(@NotNull String className, @NotNull URL resUrl) throws UnsupportedEncodingException {
        if (className == null) {
            ClasspathUtil.$$$reportNull$$$0(3);
        }
        if (resUrl == null) {
            ClasspathUtil.$$$reportNull$$$0(4);
        }
        String path = ClasspathUtil.classNameToResourcePath(className);
        String urlStr = URLDecoder.decode(ClasspathUtil.encodePlusCharacter(resUrl.toExternalForm()), "UTF-8");
        if (resUrl.getProtocol() != null) {
            int jarSeparatorIndex;
            if ("jar".equals(resUrl.getProtocol()) && (jarSeparatorIndex = urlStr.lastIndexOf("!/")) >= 0) {
                urlStr = urlStr.substring(0, jarSeparatorIndex);
            }
            int startIndex = urlStr.indexOf(58);
            while (startIndex >= 0 && urlStr.charAt(startIndex + 1) != '/') {
                startIndex = urlStr.indexOf(58, startIndex + 1);
            }
            if (startIndex >= 0) {
                urlStr = urlStr.substring(startIndex + 1);
            }
        }
        if (ClasspathUtil.endsWith(urlStr, path)) {
            urlStr = urlStr.substring(0, urlStr.length() - path.length());
        }
        if (urlStr.startsWith("/") && urlStr.indexOf(":") == 2) {
            urlStr = urlStr.substring(1);
        }
        File file = new File(urlStr);
        if (file == null) {
            ClasspathUtil.$$$reportNull$$$0(5);
        }
        return file;
    }

    @NotNull
    private static String classNameToResourcePath(@NotNull String className) {
        if (className == null) {
            ClasspathUtil.$$$reportNull$$$0(6);
        }
        String string = "/" + className.replace('.', '/') + ".class";
        if (string == null) {
            ClasspathUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static String encodePlusCharacter(@NotNull String orig) {
        if (orig == null) {
            ClasspathUtil.$$$reportNull$$$0(8);
        }
        String string = orig.replace("+", "%2B");
        if (string == null) {
            ClasspathUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static boolean endsWith(@NotNull String str, @NotNull String suffix) {
        if (str == null) {
            ClasspathUtil.$$$reportNull$$$0(10);
        }
        if (suffix == null) {
            ClasspathUtil.$$$reportNull$$$0(11);
        }
        return suffix.length() <= str.length() && str.regionMatches(true, str.length() - suffix.length(), suffix, 0, suffix.length());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/util/ClasspathUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resUrl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orig";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBootClasspathEntry";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/util/ClasspathUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasspathEntry";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resourceUrlToClasspathEntry";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "classNameToResourcePath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "encodePlusCharacter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getClasspathEntry";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resourceUrlToClasspathEntry";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "classNameToResourcePath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "encodePlusCharacter";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "endsWith";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

