/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.util;

import com.jetbrains.launcher.AppFilesEx;
import com.jetbrains.launcher.LauncherContext;
import com.jetbrains.launcher.log.SafeLogger;
import com.jetbrains.launcher.util.CmdUtil;
import com.jetbrains.launcher.util.java.InvalidJvmOptionException;
import com.jetbrains.launcher.util.java.JavaCommandLineBuilder;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class LauncherExecutor {
    @NotNull
    private final SafeLogger LOG;
    @NotNull
    private final LauncherContext myContext;

    public LauncherExecutor(@NotNull LauncherContext context) {
        if (context == null) {
            LauncherExecutor.$$$reportNull$$$0(0);
        }
        this.LOG = new SafeLogger(Logger.getLogger(LauncherExecutor.class));
        this.myContext = context;
    }

    @NotNull
    public Process startLauncher(String ... command) throws IOException, InvalidJvmOptionException {
        if (command == null) {
            LauncherExecutor.$$$reportNull$$$0(1);
        }
        AppFilesEx appFiles = this.myContext.getAppFiles();
        File appHome = appFiles.getAppHome();
        JavaCommandLineBuilder builder = LauncherExecutor.getCommandLineBuilder(appHome, appFiles.getLauncherLibFolder(), command);
        List<String> cmdLine = builder.build(this.myContext.getAppConfig().getAppName().withSuffix(" Launcher"), appHome);
        Map<String, String> envSystemProperties = builder.getEnvSystemProperties();
        this.LOG.safeDebug("Starting launcher process with command: " + cmdLine + " (at path: \"" + appHome.getAbsolutePath() + "\", system properties: " + envSystemProperties + ")");
        Process process = CmdUtil.executeJava((File)appHome, cmdLine, envSystemProperties);
        if (process == null) {
            LauncherExecutor.$$$reportNull$$$0(2);
        }
        return process;
    }

    @NotNull
    private static JavaCommandLineBuilder getCommandLineBuilder(@NotNull File workDir, @NotNull File libDir, @NotNull String[] command) throws InvalidJvmOptionException {
        if (workDir == null) {
            LauncherExecutor.$$$reportNull$$$0(3);
        }
        if (libDir == null) {
            LauncherExecutor.$$$reportNull$$$0(4);
        }
        if (command == null) {
            LauncherExecutor.$$$reportNull$$$0(5);
        }
        JavaCommandLineBuilder builder = new JavaCommandLineBuilder(workDir, libDir, null);
        builder.setUseJavaw(true);
        builder.addJvmOptionsFromEnvVariable("JL_LAUNCHER_OPTS", new String[0]);
        builder.addEnvSystemProperties(CmdUtil.getSpecifiedEnvSystemProperties());
        builder.passAgentSystemPropertiesThrough();
        builder.passLauncherSystemPropertiesThrough();
        builder.addProgramArgs(Arrays.asList(command));
        JavaCommandLineBuilder javaCommandLineBuilder = builder;
        if (javaCommandLineBuilder == null) {
            LauncherExecutor.$$$reportNull$$$0(6);
        }
        return javaCommandLineBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/util/LauncherExecutor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workDir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/util/LauncherExecutor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "startLauncher";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandLineBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "startLauncher";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCommandLineBuilder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

