/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.util;

import com.jetbrains.launcher.LauncherExitCode;
import com.jetbrains.launcher.SystemInfo;
import com.jetbrains.launcher.UserMessageTransformer;
import com.jetbrains.launcher.util.ExceptionUtil;
import com.jetbrains.launcher.util.FileUtil;
import com.jetbrains.launcher.util.JarUtil;
import com.jetbrains.launcher.util.ProcessUtil;
import com.jetbrains.launcher.util.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LauncherUtil {
    @NotNull
    private static final String DOT_CMD = ".cmd";
    @NotNull
    private static final String DOT_BAT = ".bat";
    @NotNull
    private static final String DOT_SH = ".sh";

    private LauncherUtil() {
    }

    @NotNull
    public static LauncherExitCode getLauncherErrorExitCode(int exitCode) {
        LauncherExitCode launcherExitCode = exitCode == LauncherExitCode.OK.getValue() ? LauncherExitCode.ERROR : LauncherUtil.getLauncherExitCode(exitCode);
        if (launcherExitCode == null) {
            LauncherUtil.$$$reportNull$$$0(0);
        }
        return launcherExitCode;
    }

    @NotNull
    public static LauncherExitCode getLauncherExitCode(int exitCode) {
        for (LauncherExitCode launcherExitCode : LauncherExitCode.values()) {
            if (launcherExitCode.getValue() != exitCode) continue;
            LauncherExitCode launcherExitCode2 = launcherExitCode;
            if (launcherExitCode2 == null) {
                LauncherUtil.$$$reportNull$$$0(1);
            }
            return launcherExitCode2;
        }
        LauncherExitCode launcherExitCode = LauncherExitCode.ERROR;
        if (launcherExitCode == null) {
            LauncherUtil.$$$reportNull$$$0(2);
        }
        return launcherExitCode;
    }

    @Nullable
    public static List<String> findCommand(@NotNull File originalProgram) {
        if (originalProgram == null) {
            LauncherUtil.$$$reportNull$$$0(3);
        }
        ArrayList<String> cmdLine = new ArrayList<String>();
        File program = LauncherUtil.findProgram(originalProgram);
        if (program == null) {
            return null;
        }
        cmdLine.add(program.getAbsolutePath());
        String programName = program.getName();
        if (SystemInfo.isWindows) {
            if (programName.endsWith(DOT_CMD) || programName.endsWith(DOT_BAT)) {
                cmdLine.add(0, "/c");
                cmdLine.add(0, "cmd.exe");
            }
        } else if (programName.endsWith(DOT_SH)) {
            cmdLine.add(0, "/bin/sh");
        }
        return cmdLine;
    }

    @Nullable
    public static File findProgram(@NotNull File originalProgram) {
        File program;
        if (originalProgram == null) {
            LauncherUtil.$$$reportNull$$$0(4);
        }
        if (!(program = originalProgram).isFile()) {
            if (SystemInfo.isWindows) {
                program = LauncherUtil.doFindProgram(originalProgram, DOT_CMD);
                if (program == null) {
                    program = LauncherUtil.doFindProgram(originalProgram, DOT_BAT);
                }
            } else {
                program = LauncherUtil.doFindProgram(originalProgram, DOT_SH);
            }
        }
        return program;
    }

    @Nullable
    private static File doFindProgram(@NotNull File program, @NotNull String ext) {
        File newProgram;
        int lastDotPos;
        String programPath;
        File programWithExt;
        if (program == null) {
            LauncherUtil.$$$reportNull$$$0(5);
        }
        if (ext == null) {
            LauncherUtil.$$$reportNull$$$0(6);
        }
        if ((programWithExt = new File((programPath = program.getAbsolutePath()) + ext)).isFile()) {
            return programWithExt;
        }
        if (program.getName().contains(".") && (lastDotPos = programPath.lastIndexOf(46)) != -1 && (newProgram = new File(programPath.substring(0, lastDotPos) + ext)).isFile()) {
            return newProgram;
        }
        return null;
    }

    private static void copyFile(@NotNull File fromFile, @NotNull File toFile, boolean preserveTimestamp) throws IOException {
        if (fromFile == null) {
            LauncherUtil.$$$reportNull$$$0(7);
        }
        if (toFile == null) {
            LauncherUtil.$$$reportNull$$$0(8);
        }
        try {
            if (!toFile.exists()) {
                File parentFile = toFile.getParentFile();
                if (parentFile == null) {
                    return;
                }
                FileUtil.mkdirs((File)parentFile);
                toFile.createNewFile();
            }
            FileUtil.copy((File)fromFile, (File)toFile);
            if (toFile.getName().endsWith(DOT_SH)) {
                LauncherUtil.makeExecutable(toFile);
            }
            if (preserveTimestamp) {
                toFile.setLastModified(fromFile.lastModified());
            }
        }
        catch (IOException e) {
            throw new IOException(UserMessageTransformer.transform((String)("Failed to copy " + fromFile + " to " + toFile + ". " + e.getMessage())));
        }
    }

    @NotNull
    public static String getProcessLogPrefix(@NotNull List<String> cmdLine) {
        if (cmdLine == null) {
            LauncherUtil.$$$reportNull$$$0(9);
        }
        String string = cmdLine.isEmpty() ? "[process] " : "[" + new File(cmdLine.get(0)).getName() + "] ";
        if (string == null) {
            LauncherUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static String[] prepareCommand(@NotNull String[] program, @NotNull List<String> args) {
        if (program == null) {
            LauncherUtil.$$$reportNull$$$0(11);
        }
        if (args == null) {
            LauncherUtil.$$$reportNull$$$0(12);
        }
        String[] stringArray = LauncherUtil.prepareCommand(program, StringUtil.toStringArray(args));
        if (stringArray == null) {
            LauncherUtil.$$$reportNull$$$0(13);
        }
        return stringArray;
    }

    @NotNull
    public static String[] prepareCommand(@NotNull String program, String ... args) {
        if (program == null) {
            LauncherUtil.$$$reportNull$$$0(14);
        }
        if (args == null) {
            LauncherUtil.$$$reportNull$$$0(15);
        }
        String[] stringArray = LauncherUtil.prepareCommand(new String[]{program}, args);
        if (stringArray == null) {
            LauncherUtil.$$$reportNull$$$0(16);
        }
        return stringArray;
    }

    @NotNull
    public static String[] prepareCommand(@NotNull String[] program, String ... args) {
        if (program == null) {
            LauncherUtil.$$$reportNull$$$0(17);
        }
        if (args == null) {
            LauncherUtil.$$$reportNull$$$0(18);
        }
        if (args.length == 0) {
            if (program == null) {
                LauncherUtil.$$$reportNull$$$0(19);
            }
            return program;
        }
        String[] result = new String[program.length + args.length];
        System.arraycopy(program, 0, result, 0, program.length);
        System.arraycopy(args, 0, result, program.length, args.length);
        if (result == null) {
            LauncherUtil.$$$reportNull$$$0(20);
        }
        return result;
    }

    public static void makeExecutable(@NotNull File file) {
        if (file == null) {
            LauncherUtil.$$$reportNull$$$0(21);
        }
        if (SystemInfo.isWindows) {
            return;
        }
        try {
            LauncherUtil.debug("Set executable bit for " + file.getAbsolutePath());
            if (ProcessUtil.runSimpleCommand((String[])new String[]{"chmod", "+x", file.getAbsolutePath()}) != 0) {
                LauncherUtil.warn("chmod failed for: " + file);
            }
        }
        catch (Exception e) {
            ExceptionUtil.logWarning((Logger)LauncherUtil.getLog(), (String)("Failed to make executable: " + file), (Throwable)e);
        }
    }

    public static boolean hasClassInJars(@NotNull File libDir, @NotNull String className) {
        if (libDir == null) {
            LauncherUtil.$$$reportNull$$$0(22);
        }
        if (className == null) {
            LauncherUtil.$$$reportNull$$$0(23);
        }
        try {
            LauncherUtil.findJarByClass(libDir, className);
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    @NotNull
    public static File findJarByClass(@NotNull File libDir, @NotNull String className) throws FileNotFoundException {
        block5: {
            File file;
            if (libDir == null) {
                LauncherUtil.$$$reportNull$$$0(24);
            }
            if (className == null) {
                LauncherUtil.$$$reportNull$$$0(25);
            }
            try {
                File jar = JarUtil.findJarWithEntry((File)libDir, (String)(className.replace('.', '/') + ".class"));
                if (jar == null) break block5;
                file = jar;
            }
            catch (IOException e) {
                ExceptionUtil.logError((Logger)LauncherUtil.getLog(), (String)"Failed to open jar file", (Throwable)e);
            }
            if (file == null) {
                LauncherUtil.$$$reportNull$$$0(26);
            }
            return file;
        }
        throw new FileNotFoundException(UserMessageTransformer.transform((String)("Failed to find jar with class \"" + className + "\" in directory: " + libDir.getAbsolutePath())));
    }

    public static void copy(@NotNull File from, @NotNull File to, @Nullable FileFilterCopy filter) throws IOException {
        if (from == null) {
            LauncherUtil.$$$reportNull$$$0(27);
        }
        if (to == null) {
            LauncherUtil.$$$reportNull$$$0(28);
        }
        LauncherUtil.copy(from, to, filter, true);
    }

    public static void copy(@NotNull File from, @NotNull File to, @Nullable FileFilterCopy filter, boolean preserveTimestamps) throws IOException {
        if (from == null) {
            LauncherUtil.$$$reportNull$$$0(29);
        }
        if (to == null) {
            LauncherUtil.$$$reportNull$$$0(30);
        }
        StringBuilder sb = new StringBuilder();
        LauncherUtil.copyInternal(from, to, filter, preserveTimestamps, sb);
        if (sb.length() > 0) {
            throw new IOException(UserMessageTransformer.transform((String)sb.toString()));
        }
    }

    private static void copyInternal(@NotNull File from, @NotNull File to, @Nullable FileFilterCopy filter, boolean preserveTimestamps, @NotNull StringBuilder errors) {
        boolean notSkipped;
        if (from == null) {
            LauncherUtil.$$$reportNull$$$0(31);
        }
        if (to == null) {
            LauncherUtil.$$$reportNull$$$0(32);
        }
        if (errors == null) {
            LauncherUtil.$$$reportNull$$$0(33);
        }
        LauncherUtil.logCopy(from, to);
        boolean bl = notSkipped = filter == null || filter.acceptCopy(from, to);
        if (!from.exists()) {
            if (notSkipped && to.exists()) {
                LauncherUtil.delete(to, null);
            }
            return;
        }
        if (notSkipped) {
            if (from.isDirectory()) {
                try {
                    FileUtil.mkdirs((File)to);
                }
                catch (IOException e) {
                    LauncherUtil.printCannotCreateDirectory(to);
                }
                File[] files = from.listFiles();
                if (files != null) {
                    for (File fromFile : files) {
                        LauncherUtil.copyInternal(fromFile, new File(to, fromFile.getName()), filter, preserveTimestamps, errors);
                    }
                }
            } else {
                try {
                    LauncherUtil.copyFile(from, to, preserveTimestamps);
                }
                catch (IOException e) {
                    String message = MessageFormat.format("Failed to copy ''{0}'' to ''{1}''. {2}\n", from, to, e.toString());
                    LauncherUtil.warn(message);
                    errors.append(message);
                }
            }
        } else {
            LauncherUtil.logCopySkipped(from, to);
        }
    }

    public static boolean delete(@NotNull File file, @Nullable FileFilterDelete filter) {
        DeleteDecision decision;
        if (file == null) {
            LauncherUtil.$$$reportNull$$$0(34);
        }
        LauncherUtil.logDelete(file);
        if (!file.exists()) {
            return true;
        }
        DeleteDecision deleteDecision = decision = filter == null ? DeleteDecision.Delete : filter.acceptDelete(file);
        if (decision == DeleteDecision.SkipSubtree) {
            LauncherUtil.logDeleteSkipped(file);
            return true;
        }
        if (file.isFile()) {
            if (decision == DeleteDecision.DoNotDeleteThis) {
                LauncherUtil.logDeleteSkipped(file);
                return true;
            }
            return LauncherUtil.deleteInternal(file);
        }
        boolean allDeletedOk = true;
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                allDeletedOk &= LauncherUtil.delete(f, decision == DeleteDecision.Delete ? null : filter);
            }
        }
        if (decision == DeleteDecision.Delete) {
            allDeletedOk &= LauncherUtil.deleteInternal(file);
        }
        return allDeletedOk;
    }

    private static boolean deleteInternal(final @NotNull File file) {
        if (file == null) {
            LauncherUtil.$$$reportNull$$$0(35);
        }
        return !file.exists() || FileUtil.runFSActionWithRetry((FileUtil.FSAction)new FileUtil.FSAction(){

            public boolean run() {
                file.delete();
                return !file.exists();
            }

            public boolean onFailed() {
                LauncherUtil.printCannotDelete(file);
                return false;
            }
        });
    }

    private static void printCannotDelete(@NotNull File file) {
        if (file == null) {
            LauncherUtil.$$$reportNull$$$0(36);
        }
        LauncherUtil.error("Error deleting file: " + file.getAbsolutePath());
    }

    private static void printCannotCreateDirectory(@NotNull File file) {
        if (file == null) {
            LauncherUtil.$$$reportNull$$$0(37);
        }
        LauncherUtil.error("Error creating directory: " + file.getAbsolutePath());
    }

    private static void logCopySkipped(@NotNull File backupDir, @NotNull File targetLibDir) {
        if (backupDir == null) {
            LauncherUtil.$$$reportNull$$$0(38);
        }
        if (targetLibDir == null) {
            LauncherUtil.$$$reportNull$$$0(39);
        }
        LauncherUtil.debug("Skipped copy from " + backupDir.getAbsolutePath() + " to " + targetLibDir.getAbsolutePath());
    }

    private static void logCopy(@NotNull File backupDir, @NotNull File targetLibDir) {
        if (backupDir == null) {
            LauncherUtil.$$$reportNull$$$0(40);
        }
        if (targetLibDir == null) {
            LauncherUtil.$$$reportNull$$$0(41);
        }
        LauncherUtil.debug("Copy from " + backupDir.getAbsolutePath() + " to " + targetLibDir.getAbsolutePath());
    }

    private static void debug(@NotNull String s) {
        if (s == null) {
            LauncherUtil.$$$reportNull$$$0(42);
        }
        LauncherUtil.getLog().debug((Object)UserMessageTransformer.transform((String)s));
    }

    private static void warn(@NotNull String s) {
        if (s == null) {
            LauncherUtil.$$$reportNull$$$0(43);
        }
        LauncherUtil.getLog().warn((Object)UserMessageTransformer.transform((String)s));
    }

    private static void error(@NotNull String s) {
        if (s == null) {
            LauncherUtil.$$$reportNull$$$0(44);
        }
        LauncherUtil.getLog().error((Object)UserMessageTransformer.transform((String)s));
    }

    private static void logDelete(@NotNull File targetLibDir) {
        if (targetLibDir == null) {
            LauncherUtil.$$$reportNull$$$0(45);
        }
        LauncherUtil.debug("Deleting " + targetLibDir.getAbsolutePath());
    }

    private static void logDeleteSkipped(@NotNull File targetLibDir) {
        if (targetLibDir == null) {
            LauncherUtil.$$$reportNull$$$0(46);
        }
        LauncherUtil.debug("Skipped delete " + targetLibDir.getAbsolutePath());
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getLogger(LauncherUtil.class);
        if (logger == null) {
            LauncherUtil.$$$reportNull$$$0(47);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/util/LauncherUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalProgram";
                break;
            }
            case 5: 
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "program";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ext";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 21: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libDir";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 28: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backupDir";
                break;
            }
            case 39: 
            case 41: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetLibDir";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLauncherErrorExitCode";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLauncherExitCode";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/util/LauncherUtil";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessLogPrefix";
                break;
            }
            case 13: 
            case 16: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareCommand";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "findJarByClass";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findCommand";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findProgram";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doFindProgram";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getProcessLogPrefix";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "prepareCommand";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "makeExecutable";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "hasClassInJars";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findJarByClass";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "copyInternal";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "deleteInternal";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "printCannotDelete";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "printCannotCreateDirectory";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "logCopySkipped";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "logCopy";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "debug";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "warn";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "logDelete";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "logDeleteSkipped";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum DeleteDecision {
        DoNotDeleteThis,
        SkipSubtree,
        Delete;

    }

    public static interface FileFilterDelete {
        @NotNull
        public DeleteDecision acceptDelete(@NotNull File var1);
    }

    public static interface FileFilterCopy {
        public boolean acceptCopy(@NotNull File var1, @NotNull File var2);
    }
}

