/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.util;

import com.jetbrains.launcher.LauncherContextEx;
import com.jetbrains.launcher.LauncherExitCode;
import com.jetbrains.launcher.ProcessContext;
import com.jetbrains.launcher.run.AgentRuntimeHelper;
import com.jetbrains.launcher.run.UpToDateLauncherContext;
import com.jetbrains.launcher.util.ExceptionUtil;
import com.jetbrains.launcher.util.FileUtil;
import com.jetbrains.launcher.util.LauncherExecutor;
import com.jetbrains.launcher.util.SystemUtil;
import com.jetbrains.launcher.util.process.ProcessUtilEx;
import java.io.Closeable;
import java.io.File;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class WindowsConsoleHandler {
    @NotNull
    private final Logger LOG;
    @NotNull
    private final LauncherExecutor myLauncherExecutor;
    @NotNull
    private final AgentRuntimeHelper myAgentRuntimeHelper;
    @NotNull
    private final ProcessContext myProcessContext;

    public WindowsConsoleHandler(@NotNull LauncherContextEx context) {
        if (context == null) {
            WindowsConsoleHandler.$$$reportNull$$$0(0);
        }
        this.LOG = Logger.getLogger(WindowsConsoleHandler.class);
        SystemUtil.loadDll((File)context.getAppFiles().getLauncherBinFolder(), (String)"JetBrains.ConsoleHandler");
        UpToDateLauncherContext upToDateContext = new UpToDateLauncherContext(context);
        this.myLauncherExecutor = new LauncherExecutor(upToDateContext);
        this.myAgentRuntimeHelper = new AgentRuntimeHelper(upToDateContext);
        this.myProcessContext = ProcessContext.get();
    }

    public void setup() {
        WindowsConsoleHandler.setCtrlCloseHandler(new Runnable(){

            @Override
            public void run() {
                WindowsConsoleHandler.this.myProcessContext.runInContext(new Runnable(){

                    @Override
                    public void run() {
                        WindowsConsoleHandler.this.onCtrlClose();
                    }
                });
            }
        });
    }

    private static native void setCtrlCloseHandler(@NotNull Runnable var0);

    private void onCtrlClose() {
        this.LOG.info((Object)"Starting shutdown process in background...");
        try {
            this.myAgentRuntimeHelper.beforeStop();
            SystemUtil.setExitDelay((long)1000L);
            WindowsConsoleHandler.checkProcess(this.LOG, this.myLauncherExecutor.startLauncher("lock", "stop"), "lock");
            WindowsConsoleHandler.checkProcess(this.LOG, this.myLauncherExecutor.startLauncher("stop", "no-launcher"), "shutdown");
            this.LOG.info((Object)"Exiting...");
            SystemUtil.exit((int)LauncherExitCode.OK.getValue());
        }
        catch (Exception e) {
            ExceptionUtil.logError((Logger)this.LOG, (String)"Failed to start shutdown process", (Throwable)e);
            SystemUtil.exit((int)LauncherExitCode.ERROR.getValue());
        }
    }

    private static void checkProcess(@NotNull Logger LOG, @NotNull Process process, @NotNull String processName) {
        if (LOG == null) {
            WindowsConsoleHandler.$$$reportNull$$$0(1);
        }
        if (process == null) {
            WindowsConsoleHandler.$$$reportNull$$$0(2);
        }
        if (processName == null) {
            WindowsConsoleHandler.$$$reportNull$$$0(3);
        }
        FileUtil.close((Closeable)process.getOutputStream());
        FileUtil.close((Closeable)process.getInputStream());
        FileUtil.close((Closeable)process.getErrorStream());
        if (!ProcessUtilEx.checkHasNotFailedImmediately(process, LOG, "[ctrl-close-stop] ", "Failed to start " + processName + " process")) {
            SystemUtil.exit((int)LauncherExitCode.ERROR.getValue());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "LOG";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processName";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/launcher/util/WindowsConsoleHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkProcess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

