/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;

public class UrlUtil {
    public static final int DEFAULT_HTTP_PORT = 80;
    public static final int DEFAULT_HTTPS_PORT = 443;

    public static String combineContexts(String c1, String c2) {
        String combinedContext = UrlUtil.ensureStartsWithoutSlash(UrlUtil.trimSlashes(c1) + "/" + UrlUtil.cutLeadingSlashes(c2));
        return "/" + UrlUtil.cutTrailingSlashes(combinedContext);
    }

    public static String combineContexts(String c1, String ... tail) {
        String result = c1;
        if (tail != null && tail.length > 0) {
            for (String str : tail) {
                result = UrlUtil.combineContexts(result, str);
            }
        }
        return "/" + UrlUtil.cutLeadingSlashes(result);
    }

    public static String ensureEndsWithSlash(String s) {
        return s.endsWith("/") ? s : s + "/";
    }

    public static String ensureStartsWithoutSlash(String s) {
        return UrlUtil.cutLeadingSlashes(s);
    }

    public static String addParameterToUrl(String name, String value, String urlAsString) throws MalformedURLException {
        URL sourceUrl = new URL(urlAsString);
        return UrlUtil.addParameterToUrl(name, value, sourceUrl);
    }

    public static String addParameterToUrl(String name, String value, URL url) {
        return url.toString().concat(url.getQuery() != null ? "&" : "?").concat(name).concat("=").concat(value);
    }

    public static String trimSlashes(String s) {
        return UrlUtil.cutLeadingSlashes(UrlUtil.cutTrailingSlashes(s));
    }

    @NotNull
    public static String constructUrl(@NotNull String scheme, @NotNull String hostname, int listenPort, @NotNull String context) {
        String portInUrl = listenPort == 80 && "http".equalsIgnoreCase(scheme) || listenPort == 443 && "https".equalsIgnoreCase(scheme) ? "" : ":" + listenPort;
        return UrlUtil.combineUrls(scheme + "://" + hostname + portInUrl, context);
    }

    @NotNull
    public static String combineUrls(@NotNull String baseUrl, @NotNull String toAdd) {
        return UrlUtil.cutTrailingSlashes(baseUrl) + "/" + UrlUtil.cutLeadingSlashes(toAdd);
    }

    @NotNull
    private static String cutLeadingSlashes(@NotNull String value) {
        while (value.startsWith("/")) {
            value = value.substring(1, value.length());
        }
        return value;
    }

    @NotNull
    private static String cutTrailingSlashes(@NotNull String value) {
        while (value.endsWith("/")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    public static boolean isSecuredUrl(@NotNull String urlAsString) {
        try {
            URL url = new URL(urlAsString);
            return UrlUtil.isSecuredUrl(url);
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static boolean isSecuredUrl(@NotNull URL url) {
        return "https".equalsIgnoreCase(url.getProtocol());
    }

    public static int getPort(@NotNull String url) throws MalformedURLException {
        return UrlUtil.getPort(new URL(url));
    }

    public static int getPort(@NotNull URL url) {
        int port = url.getPort();
        if (port == -1) {
            port = UrlUtil.isSecuredUrl(url) ? 443 : 80;
        }
        return port;
    }

    public static boolean isContextStartedWith(String ctx1, String ctx2) {
        return UrlUtil.ensureStartsWithoutSlash(ctx1).startsWith(UrlUtil.ensureStartsWithoutSlash(ctx2));
    }
}

