/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.util.logging;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class SLF4JBridgePerContextClassLoaderHandler
extends SLF4JBridgeHandler {
    private static final String FQCN = Logger.class.getName();
    private static final String UNKNOWN_LOGGER_NAME = "unknown.jul.logger";
    private static final int TRACE_LEVEL_THRESHOLD = Level.FINEST.intValue();
    private static final int DEBUG_LEVEL_THRESHOLD = Level.FINE.intValue();
    private static final int INFO_LEVEL_THRESHOLD = Level.INFO.intValue();
    private static final int WARN_LEVEL_THRESHOLD = Level.WARNING.intValue();

    public static void install() {
        SLF4JBridgePerContextClassLoaderHandler.getRootLogger().addHandler((Handler)((Object)new SLF4JBridgePerContextClassLoaderHandler()));
    }

    static Logger getRootLogger() {
        return LogManager.getLogManager().getLogger("");
    }

    public static boolean isInstalled() throws SecurityException {
        Logger rootLogger = SLF4JBridgePerContextClassLoaderHandler.getRootLogger();
        Handler[] handlers = rootLogger.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            Handler handler = handlers[i];
            if (handler == null || !handler.getClass().getName().equals(SLF4JBridgePerContextClassLoaderHandler.class.getName())) continue;
            return true;
        }
        return false;
    }

    protected Class<?> getClassFromContextClassLoader(String clazz) throws ClassNotFoundException {
        return Class.forName(clazz, true, Thread.currentThread().getContextClassLoader());
    }

    protected void callLocationAwareLoggerReflection(Object slf4jLogger, LogRecord record) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        int julLevelValue = record.getLevel().intValue();
        int slf4jLevel = julLevelValue <= TRACE_LEVEL_THRESHOLD ? 0 : (julLevelValue <= DEBUG_LEVEL_THRESHOLD ? 10 : (julLevelValue <= INFO_LEVEL_THRESHOLD ? 20 : (julLevelValue <= WARN_LEVEL_THRESHOLD ? 30 : 40)));
        String i18nMessage = this.getMessageI18N(record);
        slf4jLogger.getClass().getMethod("log", this.getClassFromContextClassLoader("org.slf4j.Marker"), String.class, Integer.TYPE, String.class, Object[].class, Throwable.class).invoke(slf4jLogger, null, FQCN, slf4jLevel, i18nMessage, null, record.getThrown());
    }

    protected void callPlainSLF4JLoggerReflection(Object slf4jLogger, LogRecord record) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String i18nMessage = this.getMessageI18N(record);
        int julLevelValue = record.getLevel().intValue();
        if (julLevelValue <= TRACE_LEVEL_THRESHOLD) {
            slf4jLogger.getClass().getMethod("trace", String.class, Throwable.class).invoke(slf4jLogger, i18nMessage, record.getThrown());
        } else if (julLevelValue <= DEBUG_LEVEL_THRESHOLD) {
            slf4jLogger.getClass().getMethod("debug", String.class, Throwable.class).invoke(slf4jLogger, i18nMessage, record.getThrown());
        } else if (julLevelValue <= INFO_LEVEL_THRESHOLD) {
            slf4jLogger.getClass().getMethod("info", String.class, Throwable.class).invoke(slf4jLogger, i18nMessage, record.getThrown());
        } else if (julLevelValue <= WARN_LEVEL_THRESHOLD) {
            slf4jLogger.getClass().getMethod("warn", String.class, Throwable.class).invoke(slf4jLogger, i18nMessage, record.getThrown());
        } else {
            slf4jLogger.getClass().getMethod("error", String.class, Throwable.class).invoke(slf4jLogger, i18nMessage, record.getThrown());
        }
    }

    private String getMessageI18N(LogRecord record) {
        Object[] params;
        String message = record.getMessage();
        if (message == null) {
            return null;
        }
        ResourceBundle bundle = record.getResourceBundle();
        if (bundle != null) {
            try {
                message = bundle.getString(message);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if ((params = record.getParameters()) != null && params.length > 0) {
            message = MessageFormat.format(message, params);
        }
        return message;
    }

    public void publish(LogRecord record) {
        if (record == null) {
            return;
        }
        String name = record.getLoggerName();
        if (name == null) {
            name = UNKNOWN_LOGGER_NAME;
        }
        try {
            Class<?> slf4jLoggerFactoryClass = this.getClassFromContextClassLoader("org.slf4j.LoggerFactory");
            Method method = slf4jLoggerFactoryClass.getMethod("getLogger", String.class);
            Object slf4jLogger = method.invoke(null, name);
            if (this.getClassFromContextClassLoader("org.slf4j.spi.LocationAwareLogger").isAssignableFrom(slf4jLogger.getClass())) {
                this.callLocationAwareLoggerReflection(slf4jLogger, record);
            } else {
                this.callPlainSLF4JLoggerReflection(slf4jLogger, record);
            }
        }
        catch (Exception e) {
            super.publish(record);
        }
    }
}

