/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.util;

import java.security.Permission;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExitTrackingSecurityManager
extends SecurityManager {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final AtomicBoolean myExitCalled = new AtomicBoolean();

    @Override
    public void checkExit(int status) {
        RuntimeException ex = new RuntimeException("Exit called with exit code " + status);
        ex.printStackTrace();
        this.LOG.error(ex.getMessage(), (Throwable)ex);
        this.myExitCalled.set(true);
        throw ex;
    }

    @Override
    public void checkPermission(Permission perm) {
        if (perm.getName().equals("setSecurityManager")) {
            this.LOG.debug("setSecurityManager called", (Throwable)new RuntimeException());
        }
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
        this.checkPermission(perm);
    }

    public boolean getExitCalled() {
        return this.myExitCalled.get();
    }
}

