/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.util.logging;

import com.jetbrains.service.util.logging.SLF4JBridgePerContextClassLoaderHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class JavaUtilLoggingToSlf4jBridge {
    private static final Level DEFAULT_JUL_LOG_LEVEL = Level.INFO;
    private static final Logger LOG = LoggerFactory.getLogger(JavaUtilLoggingToSlf4jBridge.class);

    public static void install() {
        if (SLF4JBridgePerContextClassLoaderHandler.isInstalled()) {
            LOG.debug(String.format("[%s] has already bean installed", SLF4JBridgePerContextClassLoaderHandler.class));
            return;
        }
        if (SLF4JBridgeHandler.isInstalled()) {
            LOG.warn(String.format("[%s] has already bean installed, it will be replaced with customized [%s]", SLF4JBridgeHandler.class.getName(), SLF4JBridgePerContextClassLoaderHandler.class.getName()));
        }
        LogManager.getLogManager().reset();
        SLF4JBridgePerContextClassLoaderHandler.install();
        Level level = JavaUtilLoggingToSlf4jBridge.getJulLogLevel();
        SLF4JBridgePerContextClassLoaderHandler.getRootLogger().setLevel(level);
        java.util.logging.Logger.getGlobal().setLevel(level);
    }

    private static Level getJulLogLevel() {
        Level level;
        String levelAsString = System.getProperty("jetbrains.ring.jul_to_slf4j.log.level", DEFAULT_JUL_LOG_LEVEL.getName());
        try {
            level = Level.parse(levelAsString);
        }
        catch (Exception e) {
            level = DEFAULT_JUL_LOG_LEVEL;
        }
        return level;
    }
}

