/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.youtrack.service;

import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class ServerProperties {
    private String myListenAddress;
    private int myPort;
    private String myServiceId;
    private String myBaseUrl;
    private String myServiceContext;
    private Properties myProperties;

    public ServerProperties(@NotNull Properties bundleProperties) {
        this.myProperties = bundleProperties;
        this.myServiceId = bundleProperties.getProperty("id");
        this.myServiceContext = bundleProperties.getProperty("context");
        this.myListenAddress = bundleProperties.getProperty("listen");
        this.myPort = Integer.parseInt(bundleProperties.getProperty("port"));
        this.myBaseUrl = bundleProperties.getProperty("base-url");
    }

    public String getServiceBaseUrl(String serviceId) {
        if (serviceId.equals(this.myServiceId)) {
            return this.getServiceBaseUrl();
        }
        return PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)this.myProperties, serviceId, "base-url");
    }

    public String getServiceBaseUrl() {
        return this.myBaseUrl;
    }

    public String getListenAddress() {
        return this.myListenAddress;
    }

    public int getPort() {
        return this.myPort;
    }

    public String getServiceContext() {
        return this.myServiceContext;
    }
}

