/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.youtrack.service;

import com.jetbrains.service.jetty.JetLauncherJettyService;
import com.jetbrains.service.jetty.JettyServiceBase;
import com.jetbrains.service.jetty.SimpleJettyService;
import com.jetbrains.service.util.ServiceProperties;
import com.jetbrains.service.util.StatusException;
import com.jetbrains.youtrack.service.YouTrackBeforeStartCallback;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class YouTrackMain
extends JetLauncherJettyService {
    protected JettyServiceBase createJettyService() {
        return new SimpleJettyService(){

            @NotNull
            protected String getServiceCookieName() {
                return "YTJSESSIONID";
            }

            protected void beforeStart(@NotNull Properties properties) {
                super.beforeStart(properties);
                String dataDirectory = this.getMandatoryProperty(ServiceProperties.DATA_DIR_PROPERTY, this.getAllProperties());
                File file = new File(dataDirectory);
                if (!file.isDirectory() && !file.mkdirs()) {
                    throw new StatusException("Could not create YouTrack data directory: " + file);
                }
                new YouTrackBeforeStartCallback().setupSystemProperties(this.getAllProperties());
            }

            public void configure(@NotNull Properties properties) {
                File overrideDescriptor = new File(this.getWebApp(), "WEB-INF/override-web.xml");
                try {
                    properties.put("overridden-web-xml-path", overrideDescriptor.getCanonicalPath());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                super.configure(properties);
            }
        };
    }
}

