This is an official Docker image of [JetBrains YouTrack](https://www.jetbrains.com/youtrack/). 
The image is suitable for evaluation purposes as well as for production use.

## How to Use YouTrack Image

Pull the image from the Docker YouTrack Repository:

`docker pull jetbrains/youtrack:{version}`

As the `{version}`, specify a tag that contains YouTrack release version including the build number. For example:
```docker pull jetbrains/youtrack:2018.1.41826```

For the list of available versions, refer to the [Tags List](https://hub.docker.com/r/jetbrains/youtrack/tags/).

To view a list of commands that are supported by the entry point of YouTrack docker image, run the `help` command:
`docker run --rm -it jetbrains/youtrack:{version} help`

### Start YouTrack Container

#### Create and Configure YouTrack-specific Directories

YouTrack image container is a _stateful container_. Thus, before running it, you should create specific directories _on the host machine_ to store YouTrack database, configuration files, logs, backups, and _pass them to the YouTrack container as volumes_. Otherwise, you risk losing YouTrack data when the container is removed.

These directories are:

* `data` &mdash; a directory where YouTrack stores its database. For a new installation, this directory must be empty. 
* `conf` &mdash; a directory where YouTrack stores configuration files that contain environment settings, JVM options, Hub integration settings, and so on.
* `logs` &mdash; a directory where YouTrack stores its log files. 
* `backups` &mdash; a directory where YouTrack stores backups. For more information about managing backup files, refer to the [YouTrack documentation](https://www.jetbrains.com/help/youtrack/standalone/Back-Up-the-Database.html).

Another condition for YouTrack-specific directories is that they must be accessible to the user account that is used to run YouTrack service inside the container. YouTrack uses the non-root account `13001:13001` (`group:id`, respectively).

For example, if you use a Linux host machine, you can execute the following commands to create and configure YouTrack directories: 
```
mkdir -p -m 750 {path to data directory} {path to logs directory} {path to conf directory} {path to backups directory}
chown -R 13001:13001 {path to data directory} {path to logs directory} {path to conf directory} {path to backups directory}
```

When done, you can define the mapping between the directories on the host machine and inside the docker container as the attributes of the `docker run` command.

#### Run the Container

To run YouTrack container, execute the command:

```
docker run -it --name youtrack-server-instance  \
    -v {path to data directory}:/opt/youtrack/data \
    -v {path to conf directory}:/opt/youtrack/conf  \
    -v {path to logs directory}:/opt/youtrack/logs  \
    -v {path to backups directory}:/opt/youtrack/backups  \
    -p {port on host}:8080 \
    jetbrains/youtrack:{version}
```

Command attributes:

* `-it` &mdash; a flag that attaches YouTrack container input and output including the startup logs to the terminal window. Note that pressing `Ctrl+C` when the terminal is attached to a container output causes the container to shut down.  Use `Ctrl+PQ` in order to detach the terminal from container output. For more details, see the official [docker documentation](https://docs.docker.com/engine/reference/commandline/attach/#extended-description).
* `--name youtrack-server-instance` &mdash; the arbitrary name for the container.
* `-v {path to NNN directory}:/opt/youtrack/NNN` &mdash; binding the YouTrack-specific `NNN` directory on the  host machine to the respective `/opt/youtrack/NNN` directory inside the container.
* `-p {port on host}:8080` &mdash; parameter that defines the ports mapping. It instructs the host machine to listen on port `{port on host}` and propagate all traffic to the port `8080` inside the docker container.

When you run the container for the first time, the web-based Configuration Wizard starts on the main service port. It lets you configure the main parameters of the new YouTrack service. You can also skip the web-based configuration, and run YouTrack service with the default parameters. For more details, refer to [YouTrack documentation](https://www.jetbrains.com/help/youtrack/standalone/youtrack-docker-installation.html).

### Access the Running YouTrack Service
By default, the service starts on `{0.0.0.0:8080}` inside the Docker container. Port `8080` is mapped to a `{port on host}` in the start command. 
This way, the service can be accessed from any machine that has network access to the port `{port on host}` of the host machine. 
For example, if the FQDN of the host machine is `host.mydomain.com`, then the service is available at `http://{host.mydomain.com}:{port on host}`.

### Stop YouTrack
To stop the YouTrack service gracefully, run the command: 
`docker exec {containerId} stop`

For a graceful shutdown, you can also use the standard `docker kill --signal=SIGTERM {containerId}` command.

We do not recommend using the standard command `docker stop`. By default, this command sends the `SIGTERM` signal to the YouTrack process inside the Docker container, then waits for 10 seconds. If YouTrack does not finish the shutdown within that time period, the `SIGKILL` is sent to the kernel and the YouTrack process is killed. This may lead to data corruption. To avoid this outcome, specify an appropriate timeout value when using this command.
For example, the following command leaves enough time for the YouTrack service to shut down: ```docker stop -t 60 {containerId}```
    
### Configure YouTrack

You can configure YouTrack from a command line, including the properties that are set in the Configuration Wizard on the first start. Stop the YouTrack service and run the `configure` command:
```
docker run -it --rm \
    -v {path to data directory}:/opt/youtrack/data \
    -v {path to conf directory}:/opt/youtrack/conf  \
    -v {path to logs directory}:/opt/youtrack/logs  \
    -v {path to backups directory}:/opt/youtrack/backups  \
    jetbrains/youtrack:{version} \
    configure \
    {arguments}
```

Command attributes:
 
* `{arguments}` &mdash; a list of YouTrack system properties or JVM options. Refer to the YouTrack documentation for the [list of supported system properties](https://www.jetbrains.com/help/youtrack/standalone/YouTrack-Java-Start-Parameters.html)

For more details on the format of the `configure` command, run `docker run --rm -it jetbrains/youtrack:{version} help`. 

When you execute the `configure` command, make sure to keep all local system paths in volume mappings the same as the mappings specified in the run command for the main server. Otherwise, updates are not applied to the YouTrack configuration files.

## Run YouTrack container as a service

Docker team recommends to use cross-platform built-in restart policy for running container as a service.
For this, [configure your docker service to start on system boot](https://docs.docker.com/install/linux/linux-postinstall//#configure-docker-to-start-on-boot) and simply add parameter `--restart unless-stopped` to the `docker run` command that starts YouTrack.

That works fine until you need to schedule some other external process to be started after YouTrack finished starting.
In that case process manager could be used instead. See [official Docker documentation](https://docs.docker.com/engine/admin/start-containers-automatically/#use-a-process-manager) on that.
Below is an example of how to configure starting YouTrack container as a service on Linux with help of systemd.

For that simply create a service descriptor file `/etc/systemd/system/docker.youtrack.service` with the following content: 
```
[Unit]
Description=YouTrack Service
After=docker.service
Requires=docker.service

[Service]
TimeoutStartSec=0
Restart=always
ExecStartPre=-/usr/bin/docker exec %n stop 
ExecStartPre=-/usr/bin/docker rm %n
ExecStartPre=/usr/bin/docker pull jetbrains/youtrack:{version}
ExecStart=/usr/bin/docker run --rm --name %n \
    -v {path to data directory}:/opt/youtrack/data \
    -v {path to conf directory}:/opt/youtrack/conf  \
    -v {path to logs directory}:/opt/youtrack/logs  \
    -v {path to backups directory}:/opt/youtrack/backups  \
    -p {port on host}:8080 \
    jetbrains/youtrack:{version}

[Install]
WantedBy=default.target
```
And enable the service to start at boot time by the following command 
```
sudo systemctl enable docker.youtrack
```

Service can be stopped/started manually at any time with help of the following commands:
```
sudo service docker.youtrack stop
sudo service docker.youtrack start
```

## Upgrade YouTrack

If you use the _original YouTrack docker image_, then you can just stop the running container, pull a newer version of the YouTrack image, and run the server with the usual command. Make sure to provide mapping for volumes with application data from the previous version.

When you run the new version container and it finishes the startup process, the web-based Upgrade Wizard is deployed and listens on the YouTrack main port.
The URL of the Upgrade Wizard is printed at the startup container console and is recorded in the logs. To locate the Upgrade Wizard URL, 
search the startup console logs for a record that contains a phrase like "Configuration Wizard will be available on [http://&lt;host&gt;:&lt;port&gt;/contextPath?wizard_token=&lt;value&gt;] after start".

As soon as the Upgrade Wizard is complete, the YouTrack service starts.

For more details, see the [YouTrack documentaion](https://www.jetbrains.com/help/youtrack/standalone/upgrade-with-docker-image.html).

## License

The Docker image is available under the YouTrack license.

[Licensing details](https://www.jetbrains.com/youtrack/buy/license.html)

## Release Notes
You can find a link to the release notes for the current YouTrack version in the **Standalone** section of our [downloads page](https://www.jetbrains.com/youtrack/download/get_youtrack.html). To access the release notes for earlier versions and builds, check [Previous YouTrack Releases](https://www.jetbrains.com/youtrack/download/previous.html).

## Feedback

Report issues or suggestions in the [YouTrack issue tracker](https://youtrack.jetbrains.com/issues/JT)

## Under the Hood

This Docker image is built on top of a base image which includes:
* [openjdk:8-slim](https://hub.docker.com/_/openjdk/)