/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.apache;

import java.io.IOException;
import java.net.InetAddress;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLInitializationException;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.http.AbortableCallable;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.SdkRequestContext;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.http.apache.internal.ApacheHttpRequestConfig;
import software.amazon.awssdk.http.apache.internal.DefaultConfiguration;
import software.amazon.awssdk.http.apache.internal.SdkProxyRoutePlanner;
import software.amazon.awssdk.http.apache.internal.conn.ClientConnectionManagerFactory;
import software.amazon.awssdk.http.apache.internal.conn.SdkConnectionKeepAliveStrategy;
import software.amazon.awssdk.http.apache.internal.conn.SdkTlsSocketFactory;
import software.amazon.awssdk.http.apache.internal.impl.ApacheHttpRequestFactory;
import software.amazon.awssdk.http.apache.internal.impl.ApacheSdkHttpClient;
import software.amazon.awssdk.http.apache.internal.impl.ConnectionManagerAwareHttpClient;
import software.amazon.awssdk.http.apache.internal.utils.ApacheUtils;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.NumericUtils;

@SdkPublicApi
public final class ApacheHttpClient
implements SdkHttpClient {
    private static final Logger log = Logger.loggerFor(ApacheHttpClient.class);
    private final ApacheHttpRequestFactory apacheHttpRequestFactory = new ApacheHttpRequestFactory();
    private final ConnectionManagerAwareHttpClient httpClient;
    private final ApacheHttpRequestConfig requestConfig;
    private final AttributeMap resolvedOptions;

    private ApacheHttpClient(DefaultBuilder builder, AttributeMap resolvedOptions) {
        this.httpClient = this.createClient(builder, resolvedOptions);
        this.requestConfig = this.createRequestConfig(builder, resolvedOptions);
        this.resolvedOptions = resolvedOptions;
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    private ConnectionManagerAwareHttpClient createClient(DefaultBuilder configuration, AttributeMap standardOptions) {
        ApacheConnectionManagerFactory cmFactory = new ApacheConnectionManagerFactory();
        HttpClientBuilder builder = HttpClients.custom();
        HttpClientConnectionManager cm = cmFactory.create(configuration, standardOptions);
        builder.setRequestExecutor(new HttpRequestExecutor()).disableContentCompression().setKeepAliveStrategy(this.buildKeepAliveStrategy(configuration)).disableRedirectHandling().disableAutomaticRetries().setUserAgent("").setConnectionManager(ClientConnectionManagerFactory.wrap(cm));
        this.addProxyConfig(builder, configuration.proxyConfiguration);
        return new ApacheSdkHttpClient((HttpClient)builder.build(), cm);
    }

    private void addProxyConfig(HttpClientBuilder builder, ProxyConfiguration proxyConfiguration) {
        if (this.isProxyEnabled(proxyConfiguration)) {
            log.debug(() -> "Configuring Proxy. Proxy Host: " + proxyConfiguration.endpoint());
            builder.setRoutePlanner((HttpRoutePlanner)new SdkProxyRoutePlanner(proxyConfiguration.endpoint().getHost(), proxyConfiguration.endpoint().getPort(), proxyConfiguration.nonProxyHosts()));
            if (this.isAuthenticatedProxy(proxyConfiguration)) {
                builder.setDefaultCredentialsProvider(ApacheUtils.newProxyCredentialsProvider(proxyConfiguration));
            }
        }
    }

    private ConnectionKeepAliveStrategy buildKeepAliveStrategy(DefaultBuilder configuration) {
        long maxIdle = Optional.ofNullable(configuration.connectionMaxIdleTime).orElse(DefaultConfiguration.MAX_IDLE_CONNECTION_TIME).toMillis();
        return maxIdle > 0L ? new SdkConnectionKeepAliveStrategy(maxIdle) : null;
    }

    private boolean isAuthenticatedProxy(ProxyConfiguration proxyConfiguration) {
        return proxyConfiguration.username() != null && proxyConfiguration.password() != null;
    }

    private boolean isProxyEnabled(ProxyConfiguration proxyConfiguration) {
        return proxyConfiguration.endpoint() != null && proxyConfiguration.endpoint().getHost() != null && proxyConfiguration.endpoint().getPort() > 0;
    }

    public AbortableCallable<SdkHttpFullResponse> prepareRequest(SdkHttpFullRequest request, SdkRequestContext context) {
        final HttpRequestBase apacheRequest = this.toApacheRequest(request);
        return new AbortableCallable<SdkHttpFullResponse>(){

            public SdkHttpFullResponse call() throws Exception {
                return ApacheHttpClient.this.execute(apacheRequest);
            }

            public void abort() {
                apacheRequest.abort();
            }
        };
    }

    public <T> Optional<T> getConfigurationValue(SdkHttpConfigurationOption<T> key) {
        return Optional.ofNullable(this.resolvedOptions.get(key));
    }

    public void close() {
        this.httpClient.getHttpClientConnectionManager().shutdown();
    }

    private SdkHttpFullResponse execute(HttpRequestBase apacheRequest) throws IOException {
        HttpClientContext localRequestContext = ApacheUtils.newClientContext(this.requestConfig.proxyConfiguration());
        HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)apacheRequest, (HttpContext)localRequestContext);
        return this.createResponse(httpResponse, apacheRequest);
    }

    private HttpRequestBase toApacheRequest(SdkHttpFullRequest request) {
        return this.apacheHttpRequestFactory.create(request, this.requestConfig);
    }

    private SdkHttpFullResponse createResponse(HttpResponse apacheHttpResponse, HttpRequestBase apacheRequest) throws IOException {
        return (SdkHttpFullResponse)SdkHttpFullResponse.builder().statusCode(apacheHttpResponse.getStatusLine().getStatusCode()).statusText(apacheHttpResponse.getStatusLine().getReasonPhrase()).content(apacheHttpResponse.getEntity() != null ? this.toAbortableInputStream(apacheHttpResponse, apacheRequest) : null).headers(this.transformHeaders(apacheHttpResponse)).build();
    }

    private AbortableInputStream toAbortableInputStream(HttpResponse apacheHttpResponse, HttpRequestBase apacheRequest) throws IOException {
        return new AbortableInputStream(apacheHttpResponse.getEntity().getContent(), () -> ((HttpRequestBase)apacheRequest).abort());
    }

    private Map<String, List<String>> transformHeaders(HttpResponse apacheHttpResponse) {
        return Stream.of(apacheHttpResponse.getAllHeaders()).collect(Collectors.groupingBy(NameValuePair::getName, Collectors.mapping(NameValuePair::getValue, Collectors.toList())));
    }

    private ApacheHttpRequestConfig createRequestConfig(DefaultBuilder builder, AttributeMap resolvedOptions) {
        return ApacheHttpRequestConfig.builder().socketTimeout((Duration)resolvedOptions.get((AttributeMap.Key)SdkHttpConfigurationOption.READ_TIMEOUT)).connectionTimeout((Duration)resolvedOptions.get((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT)).proxyConfiguration(builder.proxyConfiguration).localAddress(Optional.ofNullable(builder.localAddress).orElse(null)).expectContinueEnabled(Optional.ofNullable(builder.expectContinueEnabled).orElse(DefaultConfiguration.EXPECT_CONTINUE_ENABLED)).build();
    }

    private static class ApacheConnectionManagerFactory {
        private ApacheConnectionManagerFactory() {
        }

        public HttpClientConnectionManager create(DefaultBuilder configuration, AttributeMap standardOptions) {
            ConnectionSocketFactory sslsf = this.getPreferredSocketFactory(standardOptions);
            PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(this.createSocketFactoryRegistry(sslsf), null, (SchemePortResolver)DefaultSchemePortResolver.INSTANCE, null, Optional.ofNullable(configuration.connectionTimeToLive).orElse(DefaultConfiguration.CONNECTION_POOL_TTL).toMillis(), TimeUnit.MILLISECONDS);
            cm.setDefaultMaxPerRoute(((Integer)standardOptions.get((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS)).intValue());
            cm.setMaxTotal(((Integer)standardOptions.get((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS)).intValue());
            cm.setDefaultSocketConfig(this.buildSocketConfig(standardOptions));
            return cm;
        }

        private ConnectionSocketFactory getPreferredSocketFactory(AttributeMap standardOptions) {
            return new SdkTlsSocketFactory(this.getSslContext(standardOptions), this.getHostNameVerifier(standardOptions));
        }

        private HostnameVerifier getHostNameVerifier(AttributeMap standardOptions) {
            return (Boolean)standardOptions.get((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES) != false ? NoopHostnameVerifier.INSTANCE : SSLConnectionSocketFactory.getDefaultHostnameVerifier();
        }

        private SSLContext getSslContext(AttributeMap standardOptions) {
            TrustManager[] trustManagers = null;
            if (((Boolean)standardOptions.get((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES)).booleanValue()) {
                log.warn(() -> "SSL Certificate verification is disabled. This is not a safe setting and should only be used for testing.");
                trustManagers = ApacheConnectionManagerFactory.trustAllTrustManager();
            }
            try {
                SSLContext sslcontext = SSLContext.getInstance("TLS");
                sslcontext.init(null, trustManagers, null);
                return sslcontext;
            }
            catch (KeyManagementException | NoSuchAlgorithmException ex) {
                throw new SSLInitializationException(ex.getMessage(), (Throwable)ex);
            }
        }

        private static TrustManager[] trustAllTrustManager() {
            return new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    log.debug(() -> "Accepting a client certificate: " + x509Certificates[0].getSubjectDN());
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    log.debug(() -> "Accepting a client certificate: " + x509Certificates[0].getSubjectDN());
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
        }

        private SocketConfig buildSocketConfig(AttributeMap standardOptions) {
            return SocketConfig.custom().setSoKeepAlive(false).setSoTimeout(NumericUtils.saturatedCast((long)((Duration)standardOptions.get((AttributeMap.Key)SdkHttpConfigurationOption.READ_TIMEOUT)).toMillis())).setTcpNoDelay(true).build();
        }

        private Registry<ConnectionSocketFactory> createSocketFactoryRegistry(ConnectionSocketFactory sslSocketFactory) {
            return RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build();
        }
    }

    private static final class DefaultBuilder
    implements Builder {
        private final AttributeMap.Builder standardOptions = AttributeMap.builder();
        private ProxyConfiguration proxyConfiguration = (ProxyConfiguration)ProxyConfiguration.builder().build();
        private InetAddress localAddress;
        private Boolean expectContinueEnabled;
        private Duration connectionTimeToLive;
        private Duration connectionMaxIdleTime;

        private DefaultBuilder() {
        }

        @Override
        public Builder socketTimeout(Duration socketTimeout) {
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.READ_TIMEOUT, (Object)socketTimeout);
            return this;
        }

        public void setSocketTimeout(Duration socketTimeout) {
            this.socketTimeout(socketTimeout);
        }

        @Override
        public Builder connectionTimeout(Duration connectionTimeout) {
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT, (Object)connectionTimeout);
            return this;
        }

        public void setConnectionTimeout(Duration connectionTimeout) {
            this.connectionTimeout(connectionTimeout);
        }

        @Override
        public Builder maxConnections(Integer maxConnections) {
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS, (Object)maxConnections);
            return this;
        }

        public void setMaxConnections(Integer maxConnections) {
            this.maxConnections(maxConnections);
        }

        @Override
        public Builder proxyConfiguration(ProxyConfiguration proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration;
            return this;
        }

        public void setProxyConfiguration(ProxyConfiguration proxyConfiguration) {
            this.proxyConfiguration(proxyConfiguration);
        }

        @Override
        public Builder localAddress(InetAddress localAddress) {
            this.localAddress = localAddress;
            return this;
        }

        public void setLocalAddress(InetAddress localAddress) {
            this.localAddress(localAddress);
        }

        @Override
        public Builder expectContinueEnabled(Boolean expectContinueEnabled) {
            this.expectContinueEnabled = expectContinueEnabled;
            return this;
        }

        public void setExpectContinueEnabled(Boolean useExpectContinue) {
            this.expectContinueEnabled = useExpectContinue;
        }

        @Override
        public Builder connectionTimeToLive(Duration connectionTimeToLive) {
            this.connectionTimeToLive = connectionTimeToLive;
            return this;
        }

        public void setConnectionTimeToLive(Duration connectionTimeToLive) {
            this.connectionTimeToLive(connectionTimeToLive);
        }

        @Override
        public Builder connectionMaxIdleTime(Duration maxIdleConnectionTimeout) {
            this.connectionMaxIdleTime = maxIdleConnectionTimeout;
            return this;
        }

        public void setConnectionMaxIdleTime(Duration connectionMaxIdleTime) {
            this.connectionMaxIdleTime(connectionMaxIdleTime);
        }

        public SdkHttpClient buildWithDefaults(AttributeMap serviceDefaults) {
            AttributeMap resolvedOptions = this.standardOptions.build().merge(serviceDefaults).merge(SdkHttpConfigurationOption.GLOBAL_HTTP_DEFAULTS);
            return new ApacheHttpClient(this, resolvedOptions);
        }
    }

    public static interface Builder
    extends SdkHttpClient.Builder<Builder> {
        public Builder socketTimeout(Duration var1);

        public Builder connectionTimeout(Duration var1);

        public Builder maxConnections(Integer var1);

        public Builder proxyConfiguration(ProxyConfiguration var1);

        public Builder localAddress(InetAddress var1);

        public Builder expectContinueEnabled(Boolean var1);

        public Builder connectionTimeToLive(Duration var1);

        public Builder connectionMaxIdleTime(Duration var1);
    }
}

