/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.signer.internal;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.AwsS3V4Signer;
import software.amazon.awssdk.auth.signer.internal.AbstractAws4Signer;
import software.amazon.awssdk.auth.signer.internal.ChunkContentIterator;
import software.amazon.awssdk.auth.signer.internal.DecodedStreamBuffer;
import software.amazon.awssdk.auth.signer.internal.SigningAlgorithm;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.io.SdkInputStream;
import software.amazon.awssdk.utils.BinaryUtils;

@SdkInternalApi
public final class AwsChunkedEncodingInputStream
extends SdkInputStream {
    private static final int DEFAULT_CHUNK_SIZE = 131072;
    private static final int DEFAULT_BUFFER_SIZE = 262144;
    private static final String CRLF = "\r\n";
    private static final String CHUNK_STRING_TO_SIGN_PREFIX = "AWS4-HMAC-SHA256-PAYLOAD";
    private static final String CHUNK_SIGNATURE_HEADER = ";chunk-signature=";
    private static final int SIGNATURE_LENGTH = 64;
    private static final byte[] FINAL_CHUNK = new byte[0];
    private static final Logger log = LoggerFactory.getLogger(AwsChunkedEncodingInputStream.class);
    private InputStream is = null;
    private final int maxBufferSize;
    private final String dateTime;
    private final String keyPath;
    private final String headerSignature;
    private String priorChunkSignature;
    private final AwsS3V4Signer aws4Signer;
    private final MessageDigest sha256;
    private final Mac hmacSha256;
    private ChunkContentIterator currentChunkIterator;
    private DecodedStreamBuffer decodedStreamBuffer;
    private boolean isAtStart = true;
    private boolean isTerminating = false;

    public AwsChunkedEncodingInputStream(InputStream in, byte[] kSigning, String datetime, String keyPath, String headerSignature, AwsS3V4Signer aws4Signer) {
        this(in, 262144, kSigning, datetime, keyPath, headerSignature, aws4Signer);
    }

    public AwsChunkedEncodingInputStream(InputStream in, int maxBufferSize, byte[] kSigning, String datetime, String keyPath, String headerSignature, AwsS3V4Signer aws4Signer) {
        if (in instanceof AwsChunkedEncodingInputStream) {
            AwsChunkedEncodingInputStream originalChunkedStream = (AwsChunkedEncodingInputStream)((Object)in);
            maxBufferSize = Math.max(originalChunkedStream.maxBufferSize, maxBufferSize);
            this.is = originalChunkedStream.is;
            this.decodedStreamBuffer = originalChunkedStream.decodedStreamBuffer;
        } else {
            this.is = in;
            this.decodedStreamBuffer = null;
        }
        if (maxBufferSize < 131072) {
            throw new IllegalArgumentException("Max buffer size should not be less than chunk size");
        }
        try {
            this.sha256 = MessageDigest.getInstance("SHA-256");
            String signingAlgo = SigningAlgorithm.HmacSHA256.toString();
            this.hmacSha256 = Mac.getInstance(signingAlgo);
            this.hmacSha256.init(new SecretKeySpec(kSigning, signingAlgo));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(e);
        }
        this.maxBufferSize = maxBufferSize;
        this.dateTime = datetime;
        this.keyPath = keyPath;
        this.headerSignature = headerSignature;
        this.priorChunkSignature = headerSignature;
        this.aws4Signer = aws4Signer;
    }

    public int read() throws IOException {
        byte[] tmp = new byte[1];
        int count = this.read(tmp, 0, 1);
        if (count != -1) {
            if (log.isDebugEnabled()) {
                log.debug("One byte read from the stream.");
            }
            int unsignedByte = tmp[0] & 0xFF;
            return unsignedByte;
        }
        return count;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int count;
        this.abortIfNeeded();
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (null == this.currentChunkIterator || !this.currentChunkIterator.hasNext()) {
            if (this.isTerminating) {
                return -1;
            }
            this.isTerminating = this.setUpNextChunk();
        }
        if ((count = this.currentChunkIterator.read(b, off, len)) > 0) {
            this.isAtStart = false;
            if (log.isTraceEnabled()) {
                log.trace(count + " byte read from the stream.");
            }
        }
        return count;
    }

    public long skip(long n) throws IOException {
        long remaining;
        int count;
        if (n <= 0L) {
            return 0L;
        }
        int toskip = (int)Math.min(262144L, n);
        byte[] temp = new byte[toskip];
        for (remaining = n; remaining > 0L && (count = this.read(temp, 0, toskip)) >= 0; remaining -= (long)count) {
        }
        return n - remaining;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readlimit) {
        this.abortIfNeeded();
        if (!this.isAtStart) {
            throw new UnsupportedOperationException("Chunk-encoded stream only supports mark() at the start of the stream.");
        }
        if (this.is.markSupported()) {
            if (log.isDebugEnabled()) {
                log.debug("AwsChunkedEncodingInputStream marked at the start of the stream (will directly mark the wrapped stream since it's mark-supported).");
            }
            this.is.mark(readlimit);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("AwsChunkedEncodingInputStream marked at the start of the stream (initializing the buffer since the wrapped stream is not mark-supported).");
            }
            this.decodedStreamBuffer = new DecodedStreamBuffer(this.maxBufferSize);
        }
    }

    public void reset() throws IOException {
        this.abortIfNeeded();
        this.currentChunkIterator = null;
        this.priorChunkSignature = this.headerSignature;
        if (this.is.markSupported()) {
            if (log.isDebugEnabled()) {
                log.debug("AwsChunkedEncodingInputStream reset (will reset the wrapped stream because it is mark-supported).");
            }
            this.is.reset();
        } else {
            if (log.isDebugEnabled()) {
                log.debug("AwsChunkedEncodingInputStream reset (will use the buffer of the decoded stream).");
            }
            if (null == this.decodedStreamBuffer) {
                throw new IOException("Cannot reset the stream because the mark is not set.");
            }
            this.decodedStreamBuffer.startReadBuffer();
        }
        this.currentChunkIterator = null;
        this.isAtStart = true;
        this.isTerminating = false;
    }

    public static long calculateStreamContentLength(long originalLength) {
        if (originalLength < 0L) {
            throw new IllegalArgumentException("Nonnegative content length expected.");
        }
        long maxSizeChunks = originalLength / 131072L;
        long remainingBytes = originalLength % 131072L;
        return maxSizeChunks * AwsChunkedEncodingInputStream.calculateSignedChunkLength(131072L) + (remainingBytes > 0L ? AwsChunkedEncodingInputStream.calculateSignedChunkLength(remainingBytes) : 0L) + AwsChunkedEncodingInputStream.calculateSignedChunkLength(0L);
    }

    private static long calculateSignedChunkLength(long chunkDataSize) {
        return (long)(Long.toHexString(chunkDataSize).length() + CHUNK_SIGNATURE_HEADER.length() + 64 + CRLF.length()) + chunkDataSize + (long)CRLF.length();
    }

    private boolean setUpNextChunk() throws IOException {
        byte[] chunkData = new byte[131072];
        int chunkSizeInBytes = 0;
        while (chunkSizeInBytes < 131072) {
            if (null != this.decodedStreamBuffer && this.decodedStreamBuffer.hasNext()) {
                chunkData[chunkSizeInBytes++] = this.decodedStreamBuffer.next();
                continue;
            }
            int bytesToRead = 131072 - chunkSizeInBytes;
            int count = this.is.read(chunkData, chunkSizeInBytes, bytesToRead);
            if (count == -1) break;
            if (null != this.decodedStreamBuffer) {
                this.decodedStreamBuffer.buffer(chunkData, chunkSizeInBytes, count);
            }
            chunkSizeInBytes += count;
        }
        if (chunkSizeInBytes == 0) {
            byte[] signedFinalChunk = this.createSignedChunk(FINAL_CHUNK);
            this.currentChunkIterator = new ChunkContentIterator(signedFinalChunk);
            return true;
        }
        if (chunkSizeInBytes < chunkData.length) {
            chunkData = Arrays.copyOf(chunkData, chunkSizeInBytes);
        }
        byte[] signedChunkContent = this.createSignedChunk(chunkData);
        this.currentChunkIterator = new ChunkContentIterator(signedChunkContent);
        return false;
    }

    private byte[] createSignedChunk(byte[] chunkData) {
        String chunkSignature;
        StringBuilder chunkHeader = new StringBuilder();
        chunkHeader.append(Integer.toHexString(chunkData.length));
        String chunkStringToSign = "AWS4-HMAC-SHA256-PAYLOAD\n" + this.dateTime + "\n" + this.keyPath + "\n" + this.priorChunkSignature + "\n" + AbstractAws4Signer.EMPTY_STRING_SHA256_HEX + "\n" + BinaryUtils.toHex((byte[])this.sha256.digest(chunkData));
        this.priorChunkSignature = chunkSignature = BinaryUtils.toHex((byte[])this.aws4Signer.signWithMac(chunkStringToSign, this.hmacSha256));
        chunkHeader.append(CHUNK_SIGNATURE_HEADER).append(chunkSignature).append(CRLF);
        try {
            byte[] header = chunkHeader.toString().getBytes(StandardCharsets.UTF_8);
            byte[] trailer = CRLF.getBytes(StandardCharsets.UTF_8);
            byte[] signedChunk = new byte[header.length + chunkData.length + trailer.length];
            System.arraycopy(header, 0, signedChunk, 0, header.length);
            System.arraycopy(chunkData, 0, signedChunk, header.length, chunkData.length);
            System.arraycopy(trailer, 0, signedChunk, header.length + chunkData.length, trailer.length);
            return signedChunk;
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to sign the chunked data. " + e.getMessage()).cause((Throwable)e).build();
        }
    }

    protected InputStream getWrappedInputStream() {
        return this.is;
    }
}

