/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import software.amazon.awssdk.annotations.SdkInternalApi;

@SdkInternalApi
public final class AwsErrorCode {
    public static final Set<String> RETRYABLE_ERROR_CODES;
    public static final Set<String> THROTTLING_ERROR_CODES;
    public static final Set<String> CLOCK_SKEW_ERROR_CODES;

    private AwsErrorCode() {
    }

    static {
        HashSet<String> throttlingErrorCodes = new HashSet<String>(9);
        throttlingErrorCodes.add("Throttling");
        throttlingErrorCodes.add("ThrottlingException");
        throttlingErrorCodes.add("ThrottledException");
        throttlingErrorCodes.add("ProvisionedThroughputExceededException");
        throttlingErrorCodes.add("SlowDown");
        throttlingErrorCodes.add("TooManyRequestsException");
        throttlingErrorCodes.add("RequestLimitExceeded");
        throttlingErrorCodes.add("BandwidthLimitExceeded");
        throttlingErrorCodes.add("RequestThrottled");
        THROTTLING_ERROR_CODES = Collections.unmodifiableSet(throttlingErrorCodes);
        HashSet<String> clockSkewErrorCodes = new HashSet<String>(6);
        clockSkewErrorCodes.add("RequestTimeTooSkewed");
        clockSkewErrorCodes.add("RequestExpired");
        clockSkewErrorCodes.add("InvalidSignatureException");
        clockSkewErrorCodes.add("SignatureDoesNotMatch");
        clockSkewErrorCodes.add("AuthFailure");
        clockSkewErrorCodes.add("RequestInTheFuture");
        CLOCK_SKEW_ERROR_CODES = Collections.unmodifiableSet(clockSkewErrorCodes);
        HashSet<String> retryableErrorCodes = new HashSet<String>(1);
        retryableErrorCodes.add("PriorRequestNotComplete");
        RETRYABLE_ERROR_CODES = Collections.unmodifiableSet(retryableErrorCodes);
    }
}

