/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.protocol.json;

import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequest;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonErrorUnmarshaller;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsStructuredCborFactory;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsStructuredIonFactory;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsStructuredJsonFactory;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsStructuredPlainJsonFactory;
import software.amazon.awssdk.awscore.internal.protocol.json.JsonContentResolverFactory;
import software.amazon.awssdk.awscore.internal.protocol.json.JsonContentTypeResolver;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.http.JsonResponseHandler;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.json.BaseJsonProtocolFactory;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.protocol.json.StructuredJsonGenerator;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

@ThreadSafe
@SdkProtectedApi
public final class AwsJsonProtocolFactory
extends BaseJsonProtocolFactory<AwsRequest, AwsServiceException> {
    private final AwsJsonProtocolMetadata protocolMetadata;
    private final List<AwsJsonErrorUnmarshaller> errorUnmarshallers = new ArrayList<AwsJsonErrorUnmarshaller>();

    public AwsJsonProtocolFactory(JsonClientMetadata metadata, AwsJsonProtocolMetadata protocolMetadata) {
        super(metadata);
        this.protocolMetadata = protocolMetadata;
        this.createErrorUnmarshallers();
    }

    public <T> JsonResponseHandler<T> createResponseHandler(JsonOperationMetadata operationMetadata, Unmarshaller<T, JsonUnmarshallerContext> responseUnmarshaller) {
        return this.getSdkFactory().createResponseHandler(operationMetadata, responseUnmarshaller);
    }

    public HttpResponseHandler<AwsServiceException> createErrorResponseHandler(JsonErrorResponseMetadata errorResponseMetadata) {
        return this.getSdkFactory().createErrorResponseHandler(this.errorUnmarshallers, errorResponseMetadata.getCustomErrorCodeFieldName());
    }

    protected StructuredJsonGenerator createGenerator(OperationInfo operationInfo) {
        if (operationInfo.hasPayloadMembers() || this.protocolMetadata.protocol() == AwsJsonProtocol.AWS_JSON) {
            return this.createGenerator();
        }
        return StructuredJsonGenerator.NO_OP;
    }

    @SdkTestInternalApi
    StructuredJsonGenerator createGenerator() {
        return this.getSdkFactory().createWriter(this.getContentType());
    }

    @SdkTestInternalApi
    protected String getContentType() {
        return this.getContentTypeResolver().resolveContentType(this.jsonClientMetadata, this.protocolMetadata);
    }

    private void createErrorUnmarshallers() {
        for (JsonErrorShapeMetadata errorMetadata : this.jsonClientMetadata.getErrorShapeMetadata()) {
            this.errorUnmarshallers.add(new AwsJsonErrorUnmarshaller(errorMetadata.getModeledClass(), errorMetadata.getErrorCode()));
        }
        this.errorUnmarshallers.add(new AwsJsonErrorUnmarshaller(this.jsonClientMetadata.getBaseServiceExceptionClass(), null));
    }

    private JsonContentTypeResolver getContentTypeResolver() {
        if (this.isCborEnabled()) {
            return JsonContentResolverFactory.AWS_CBOR;
        }
        if (this.isIonEnabled()) {
            return this.isIonBinaryEnabled() ? JsonContentResolverFactory.ION_BINARY : JsonContentResolverFactory.ION_TEXT;
        }
        return JsonContentResolverFactory.AWS_JSON;
    }

    private AwsStructuredJsonFactory getSdkFactory() {
        if (this.isCborEnabled()) {
            return AwsStructuredCborFactory.SDK_CBOR_FACTORY;
        }
        if (this.isIonEnabled()) {
            return this.isIonBinaryEnabled() ? AwsStructuredIonFactory.SDK_ION_BINARY_FACTORY : AwsStructuredIonFactory.SDK_ION_TEXT_FACTORY;
        }
        return AwsStructuredPlainJsonFactory.SDK_JSON_FACTORY;
    }
}

