/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.authentication;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.authentication.BaseAuthenticationManager;
import jetbrains.charisma.authentication.IAuthenticationManager;
import jetbrains.charisma.authentication.LoginContext;
import jetbrains.charisma.authentication.LoginIsAllowedForAdminsOnlyException;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.service.UserService;
import jetbrains.exodus.core.crypto.MessageDigestUtil;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.Or;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.exodus.query.TreeKeepingEntityIterable;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.security.Permission;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webr.framework.controller.BaseApplication;

public class AuthenticationManager
extends BaseAuthenticationManager {
    protected static Log log = LogFactory.getLog(AuthenticationManager.class);

    @Override
    public Entity authorize(LoginContext context) {
        block7: {
            try {
                Entity localUser = this.authenticateWithLocalAccount(context);
                if (!EntityOperations.equals((Entity)localUser, null)) {
                    context.setUser(localUser);
                }
            }
            catch (Throwable ex) {
                if (!log.isErrorEnabled()) break block7;
                log.error((Object)"Error on local authentificating", ex);
            }
        }
        Entity result = context.getUser();
        if (!EntityOperations.equals((Entity)result, null) && ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)result, (String)"User")).isBanned(result)) {
            result = null;
        }
        if (!EntityOperations.equals((Entity)result, null) && context.getRestrictToLowLevelAdmins()) {
            if (((UserImpl)DnqUtils.getPersistentClassInstance((Entity)result, (String)"User")).hasPermission(Permission.ADMIN_READ_APP, result)) {
                BaseApplication.setSessionField((String)"lastLoginError", (Object)((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("AuthenticationManagerDelegate.Warning_User_authentication_is_disabled_due_to_technical_problems_with_Ring_integration_Check_integration_settings_and_status", new Object[0]), (boolean)true);
            } else {
                throw new LoginIsAllowedForAdminsOnlyException();
            }
        }
        DnqUtils.getCurrentTransientSession().flush();
        return result;
    }

    @Override
    public IAuthenticationManager.LoginUrlBuilder getLogin() {
        return new BaseAuthenticationManager.LoginUrlBuilder(){

            @Override
            public String url() {
                return AuthenticationManager.this.getRelativeLocalLoginUrl();
            }
        };
    }

    @Override
    public IAuthenticationManager.LogoutUrlBuilder getLogout() {
        return new BaseAuthenticationManager.LogoutUrlBuilder(){

            @Override
            public String url() {
                return AuthenticationManager.this.getRelativeLocalLoginUrl();
            }
        };
    }

    public String getRelativeLocalLoginUrl() {
        return BaseApplication.getRequest().getContextPath() + "/login";
    }

    private Entity authenticateWithLocalAccount(LoginContext context) {
        Entity u = null;
        if (EntityOperations.equals((Entity)context.getUser(), null)) {
            String loginOrEmail = context.getLogin();
            if (loginOrEmail != null && loginOrEmail.length() > 0) {
                loginOrEmail = (loginOrEmail == null ? null : loginOrEmail.trim()).replace(' ', '_');
            }
            String notHashedPassword = context.getPassword();
            if (AuthenticationManager.eq_j2u7ei_a0e0b0e(loginOrEmail, "guest")) {
                u = ((UserService)ServiceLocator.getBean((String)"userService")).getGuest();
            } else if (loginOrEmail == null || notHashedPassword == null) {
                u = ((UserService)ServiceLocator.getBean((String)"userService")).getGuest();
            } else {
                TreeKeepingEntityIterable users = QueryOperations.query(null, (String)"User", (NodeBase)new Or((NodeBase)new PropertyEqual("login", (Comparable)((Object)loginOrEmail)), (NodeBase)new PropertyEqual("email", (Comparable)((Object)loginOrEmail))));
                String hashedPassword = MessageDigestUtil.sha256((String)notHashedPassword);
                u = QueryOperations.getFirst((Iterable)QueryOperations.query((Iterable)users, (String)"User", (NodeBase)new PropertyEqual("password", (Comparable)((Object)hashedPassword))));
            }
        }
        return u;
    }

    private static boolean eq_j2u7ei_a0e0b0e(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }
}

