/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.authentication;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.Iterator;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.UserConstraintValidationException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.And;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ITranslator2;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.youtrack.core.user.PasswordGenerator;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserImportUtil {
    protected static Log log = LogFactory.getLog(UserImportUtil.class);

    public static Entity findOrCreateUser(String login, String email, String fullName, Iterable<Entity> userDatas, _FunctionTypes._return_P2_E0<? extends Entity, ? super String, ? super Entity> newUserDataCreator) {
        return UserImportUtil.findOrCreateUserFiltered((Iterable<Entity>)QueryOperations.query(userDatas, (String)"BaseUserData", (NodeBase)new PropertyEqual("login", (Comparable)((Object)login))), (Iterable<String>)Sequence.singleton((Object)email), login, fullName, newUserDataCreator);
    }

    public static Entity findOrCreateUser(String login, Iterable<String> emails, String fullName, Iterable<Entity> userDatas, _FunctionTypes._return_P2_E0<? extends Entity, ? super String, ? super Entity> newUserDataCreator) {
        return UserImportUtil.findOrCreateUserFiltered((Iterable<Entity>)QueryOperations.query(userDatas, (String)"BaseUserData", (NodeBase)new PropertyEqual("login", (Comparable)((Object)login))), emails, login, fullName, newUserDataCreator);
    }

    public static Entity findOrCreateUserFiltered(Iterable<Entity> datas, Iterable<String> emails, String login, String fullName, _FunctionTypes._return_P2_E0<? extends Entity, ? super String, ? super Entity> newUserDataCreator) {
        Entity result;
        if (login != null && login.length() > 0) {
            login = login.replace(' ', '_');
        }
        if (datas == null || QueryOperations.isEmpty(datas)) {
            boolean greaterThan1;
            Entity firstUser;
            Iterator users = Sequence.fromIterable(emails).where((_FunctionTypes._return_P1_E0)new IWhereFilter<String>(){

                public boolean accept(String it) {
                    return it != null && it.length() > 0;
                }
            }).translate((_FunctionTypes._return_P1_E0)new ITranslator2<String, Entity>(){

                public Iterable<Entity> translate(String eml) {
                    return QueryOperations.query(null, (String)"User", (NodeBase)new PropertyEqual("email", (Comparable)((Object)eml)));
                }
            }).iterator();
            if (users.hasNext()) {
                firstUser = (Entity)users.next();
                greaterThan1 = users.hasNext();
            } else {
                firstUser = null;
                greaterThan1 = false;
            }
            if (greaterThan1) {
                if (Sequence.fromIterable(emails).count() > 1) {
                    final StringBuilder sb = new StringBuilder(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("UserImportUtil.Too_many_users_with_emails_in_set", new Object[0]));
                    Sequence.fromIterable(emails).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<String>(){

                        public void visit(String it) {
                            sb.append(' ').append(it);
                        }
                    });
                    sb.append(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("UserImportUtil._can_t_import_user", new Object[0])).append(login);
                    throw EntityOperations.isRemoved((Entity)firstUser) ? new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(sb.toString())) : new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(sb.toString(), (Entity)((TransientEntity)firstUser)));
                }
                String email = (String)Sequence.fromIterable(emails).first();
                result = QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"User", (NodeBase)new And((NodeBase)new PropertyEqual("login", (Comparable)((Object)login)), (NodeBase)new PropertyEqual("email", (Comparable)((Object)email)))));
                if (EntityOperations.equals((Entity)result, null)) {
                    result = UserImportUtil.createUniqueUser(login, fullName, email);
                }
                newUserDataCreator.invoke((Object)login, (Object)result);
            } else {
                result = EntityOperations.equals((Entity)firstUser, null) ? UserImportUtil.createUniqueUser(login, fullName, (String)Sequence.fromIterable(emails).first()) : firstUser;
                newUserDataCreator.invoke((Object)login, (Object)result);
            }
        } else {
            result = AssociationSemantics.getToOne((Entity)QueryOperations.getFirst(datas), (String)"user");
        }
        return result;
    }

    public static Entity createUniqueUser(String login, String fullName, String email) {
        String uniqueLogin = login;
        while (!QueryOperations.isEmpty((Iterable)QueryOperations.query(null, (String)"User", (NodeBase)new PropertyEqual("login", (Comparable)((Object)uniqueLogin))))) {
            uniqueLogin = login + "_" + RandomStringUtils.randomAlphanumeric((int)4);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Create user [" + uniqueLogin + "]"));
        }
        Entity result = UserImpl.constructor(uniqueLogin, true);
        PrimitiveAssociationSemantics.setHashed((Entity)result, (String)"password", (String)PasswordGenerator.generate());
        PrimitiveAssociationSemantics.set((Entity)result, (String)"fullName", (Comparable)((Object)fullName), String.class);
        PrimitiveAssociationSemantics.set((Entity)result, (String)"email", (Comparable)((Object)email), String.class);
        return result;
    }
}

